/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Optional;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public enum Visibility {
    VISIBLE("visible"),
    VISIBLE_ONLY_IN_UI("visible-only-in-ui"),
    VISIBLE_ONLY_FOR_TOOLS("visible-only-for-tools"),
    HIDDEN("hidden");

    private final String id;

    private Visibility(String id) {
        this.id = id;
    }

    @JsonCreator
    public static Visibility fromString(String id) {
        Optional<Visibility> type = Stream.of(Visibility.values()).filter(t -> t.id.equalsIgnoreCase(id)).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        return VISIBLE;
    }
}

