/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oxygenxml.positron.api.connector.dto.ResponseJsonSchemaDTO;
import com.oxygenxml.positron.utilities.json.ChatFunctionRef;
import com.oxygenxml.positron.utilities.json.Engine;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Parameters
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(Parameters.class);
    @JsonProperty(value="engine")
    private Engine engine;
    @JsonProperty(value="temperature")
    private float temperature = 0.0f;
    @JsonProperty(value="max_tokens")
    private int maxTokens = 0;
    @JsonProperty(value="max_completion_tokens")
    private Integer maxCompletionTokens;
    @JsonProperty(value="reasoning_effort")
    private String reasoningEffort;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="response_format_schema")
    private ResponseJsonSchemaDTO responseFormatSchema;
    @JsonProperty(value="response_format_ref")
    private String responseFormatRef;
    @JsonProperty(value="function_refs")
    private List<ChatFunctionRef> functionRefs;

    public Engine getEngine() {
        return this.engine;
    }

    protected Parameters clone() throws CloneNotSupportedException {
        Parameters cloned = (Parameters)super.clone();
        if (this.engine != null) {
            cloned.engine = this.engine.clone();
        }
        if (this.stop != null) {
            cloned.stop = new ArrayList<String>(this.stop);
        }
        if (this.functionRefs != null) {
            cloned.functionRefs = new ArrayList<ChatFunctionRef>(this.functionRefs.size());
            for (ChatFunctionRef ref : this.functionRefs) {
                cloned.functionRefs.add(ref.clone());
            }
        }
        return cloned;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public String getReasoningEffort() {
        return this.reasoningEffort;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public ResponseJsonSchemaDTO getResponseFormatSchema() {
        return this.responseFormatSchema;
    }

    public String getResponseFormatRef() {
        return this.responseFormatRef;
    }

    public List<ChatFunctionRef> getFunctionRefs() {
        return this.functionRefs;
    }

    @JsonProperty(value="engine")
    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @JsonProperty(value="temperature")
    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="max_completion_tokens")
    public void setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
    }

    @JsonProperty(value="reasoning_effort")
    public void setReasoningEffort(String reasoningEffort) {
        this.reasoningEffort = reasoningEffort;
    }

    @JsonProperty(value="stop")
    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="response_format_schema")
    public void setResponseFormatSchema(ResponseJsonSchemaDTO responseFormatSchema) {
        this.responseFormatSchema = responseFormatSchema;
    }

    @JsonProperty(value="response_format_ref")
    public void setResponseFormatRef(String responseFormatRef) {
        this.responseFormatRef = responseFormatRef;
    }

    @JsonProperty(value="function_refs")
    public void setFunctionRefs(List<ChatFunctionRef> functionRefs) {
        this.functionRefs = functionRefs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (this.getMaxTokens() != other.getMaxTokens()) {
            return false;
        }
        Integer this$maxCompletionTokens = this.getMaxCompletionTokens();
        Integer other$maxCompletionTokens = other.getMaxCompletionTokens();
        if (this$maxCompletionTokens == null ? other$maxCompletionTokens != null : !((Object)this$maxCompletionTokens).equals(other$maxCompletionTokens)) {
            return false;
        }
        Engine this$engine = this.getEngine();
        Engine other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !((Object)this$engine).equals(other$engine)) {
            return false;
        }
        String this$reasoningEffort = this.getReasoningEffort();
        String other$reasoningEffort = other.getReasoningEffort();
        if (this$reasoningEffort == null ? other$reasoningEffort != null : !this$reasoningEffort.equals(other$reasoningEffort)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        ResponseJsonSchemaDTO this$responseFormatSchema = this.getResponseFormatSchema();
        ResponseJsonSchemaDTO other$responseFormatSchema = other.getResponseFormatSchema();
        if (this$responseFormatSchema == null ? other$responseFormatSchema != null : !this$responseFormatSchema.equals(other$responseFormatSchema)) {
            return false;
        }
        String this$responseFormatRef = this.getResponseFormatRef();
        String other$responseFormatRef = other.getResponseFormatRef();
        if (this$responseFormatRef == null ? other$responseFormatRef != null : !this$responseFormatRef.equals(other$responseFormatRef)) {
            return false;
        }
        List<ChatFunctionRef> this$functionRefs = this.getFunctionRefs();
        List<ChatFunctionRef> other$functionRefs = other.getFunctionRefs();
        return !(this$functionRefs == null ? other$functionRefs != null : !((Object)this$functionRefs).equals(other$functionRefs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Parameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getTemperature());
        result = result * 59 + this.getMaxTokens();
        Integer $maxCompletionTokens = this.getMaxCompletionTokens();
        result = result * 59 + ($maxCompletionTokens == null ? 43 : ((Object)$maxCompletionTokens).hashCode());
        Engine $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : ((Object)$engine).hashCode());
        String $reasoningEffort = this.getReasoningEffort();
        result = result * 59 + ($reasoningEffort == null ? 43 : $reasoningEffort.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        ResponseJsonSchemaDTO $responseFormatSchema = this.getResponseFormatSchema();
        result = result * 59 + ($responseFormatSchema == null ? 43 : $responseFormatSchema.hashCode());
        String $responseFormatRef = this.getResponseFormatRef();
        result = result * 59 + ($responseFormatRef == null ? 43 : $responseFormatRef.hashCode());
        List<ChatFunctionRef> $functionRefs = this.getFunctionRefs();
        result = result * 59 + ($functionRefs == null ? 43 : ((Object)$functionRefs).hashCode());
        return result;
    }

    public String toString() {
        return "Parameters(engine=" + this.getEngine() + ", temperature=" + this.getTemperature() + ", maxTokens=" + this.getMaxTokens() + ", maxCompletionTokens=" + this.getMaxCompletionTokens() + ", reasoningEffort=" + this.getReasoningEffort() + ", stop=" + this.getStop() + ", responseFormatSchema=" + this.getResponseFormatSchema() + ", responseFormatRef=" + this.getResponseFormatRef() + ", functionRefs=" + this.getFunctionRefs() + ")";
    }
}

