/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Optional;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public enum OutputAction {
    REPLACE("replace"),
    INSERT("insert"),
    AGENTIC("agentic"),
    NEW_DOCUMENT("create-new-document"),
    NONE("none");

    private final String id;

    private OutputAction(String id) {
        this.id = id;
    }

    @JsonCreator
    public static OutputAction fromString(String id) {
        Optional<OutputAction> type = Stream.of(OutputAction.values()).filter(t -> t.id.equalsIgnoreCase(id)).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        return REPLACE;
    }

    public String toString() {
        return this.id;
    }
}

