/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Optional;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public enum InputType {
    PLAIN_TEXT("plain-text"),
    MARKUP("markup"),
    MARKUP_WITH_IMAGES("markup-with-images");

    private final String id;

    private InputType(String id) {
        this.id = id;
    }

    @JsonCreator
    public static InputType fromString(String id) {
        Optional<InputType> type = Stream.of(InputType.values()).filter(t -> t.id.equalsIgnoreCase(id)).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        return MARKUP;
    }
}

