/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Optional;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public enum ActionType {
    GENERATE_CONTENT_FROM_CONTEXT("generate-content-from-context"),
    INSERT_SUGGESTION_FOR_LEFT_CONTENT("insert-suggestion-for-left-content"),
    INSERT_SCHEMA_AWARE("insert-schema-aware-fragment"),
    REPLACE_SELECTION("replace-selection-with-fragment"),
    CREATE_NEW_DOCUMENT_FROM_TEXT("create-new-document"),
    PROMPT_USER("prompt-user"),
    GENERATE_DOCUMENTATION_DRAFT("generate-documentation-draft"),
    PSEUDO("pseudo"),
    CHAT_MODE("chat-mode"),
    SHOW_RESPONSE("show-response"),
    UPDATE_ENTIRE_DOCUMENT_BASED_ON_IMAGES("update-entire-document-based-on-images"),
    REPLACE_SELECTION_BASED_ON_IMAGE_ANALYSIS("replace-selection-based-on-image-analysis");

    private final String id;

    private ActionType(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @JsonCreator
    public static ActionType fromString(String id) {
        Optional<ActionType> type = Stream.of(ActionType.values()).filter(t -> t.id.compareToIgnoreCase(id) == 0).findFirst();
        if (type.isPresent()) {
            return type.get();
        }
        return null;
    }
}

