/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import java.util.Set;

public class ValidationReportConfig {
    private static final Set<String> KEYS_OF_ERRORS_TO_EXCLUDE_FROM_VALIDATION = Set.of("dmv.key.ref.empty", "dmv.key.undef", "dmv.incorect.capit.ref", "dmv.bad.id.ref", "dmv.invalid.ref.id.path", "dmv.invalid.ref.id.path.keyref.elemid", "dmv.invalid.ref.id", "dmv.invalid.ref.topic.id", "dmv.invalid.parse.dita.content", "dmv.dup.topic", "dmv.dup.topic.id", "dmv.dup.el.id", "dmv.not.used.key.defs", "dmv.not.used.reusable.component", "dmv.recursive.ref", "dmv.folder.ref", "dmv.file.not.found");
    public static final ValidationReportConfig NO_LOCATION_DETAILS = new ValidationReportConfig(false, false, false);
    public static final ValidationReportConfig NO_RESOURCE_DETAILS = new ValidationReportConfig(false, true, false);
    private boolean includeSystemId;
    private boolean includeLocation;
    private boolean includeEngine;

    public ValidationReportConfig() {
        this(true, true, true);
    }

    public ValidationReportConfig(boolean includeSystemId, boolean includeLocation) {
        this(includeSystemId, includeLocation, true);
    }

    public ValidationReportConfig(boolean includeSystemId, boolean includeLocation, boolean includeEngine) {
        this.includeSystemId = includeSystemId;
        this.includeLocation = includeLocation;
        this.includeEngine = includeEngine;
    }

    public boolean isIncludeSystemId() {
        return this.includeSystemId;
    }

    public void setIncludeSystemId(boolean includeSystemId) {
        this.includeSystemId = includeSystemId;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public void setIncludeLocation(boolean includeLocation) {
        this.includeLocation = includeLocation;
    }

    public boolean isIncludeEngine() {
        return this.includeEngine;
    }

    public void setIncludeEngine(boolean includeEngine) {
        this.includeEngine = includeEngine;
    }

    public boolean isIgnoredProblem(String errorKey) {
        return errorKey != null ? KEYS_OF_ERRORS_TO_EXCLUDE_FROM_VALIDATION.contains(errorKey) : false;
    }
}

