/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeCmdLineParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeCmdLineFunctionSignature
implements ChatFunctionSignature {
    private static final Logger log = LoggerFactory.getLogger(InvokeCmdLineFunctionSignature.class);

    @Override
    public String getName() {
        return "run_command_line";
    }

    @Override
    public String getDescription() {
        return "Start a command process on behalf of the user.\nIf you have this tool, note that you DO have the ability to run commands directly on the USER's system.\nNote that the user will have to approve the command before it is executed.\nThe user may reject it if it is not to their liking and propose command line changes. If they propose changes, take those changes into account.\nIn using these tools, adhere to the following guidelines:\n 1. The command line starts having the project directory as the current directory.\n 2. For ANY commands that would require user interaction, ASSUME THE USER IS NOT AVAILABLE TO INTERACT and PASS THE NON-INTERACTIVE FLAGS (e.g. --yes for npx).\n 3. If the command would use a pager, append ` | cat` to the command.\n 4. For commands that are possibly long running, set a longer timeout.\n 5. When passing file and folder paths as parameters, they must be passed in general as absolute paths, not as URLs.\n 6. Do not include any newlines in the command.\n 7. When running commands on Windows, if they are builtin commands like 'del' or 'dir', ALWAYS use 'cmd.exe /c' to run them. Remember to use Windows style separators '' in file and folder paths.\n 8. When running on Linux and Mac when the commands you want to run include '&&' inside them (chained commands) ALWAYS start them using 'bash -c' followed by the quoted command.";
    }

    @Override
    public Class<?> getParameters() {
        return InvokeCmdLineParams.class;
    }

    @Override
    public String getUIDecriptionForChatMessage() {
        return "Run command line";
    }

    @Override
    public boolean isEnabled() {
        FunctionsAndRAGHelper projectRAGHelper = FunctionsAndRAGHelperProvider.getProjectRAGHelper();
        boolean canInvokeCmdLine = projectRAGHelper == null || projectRAGHelper.canInvokeCommandLine();
        return canInvokeCmdLine && ChatFunctionSignature.super.isEnabled();
    }

    @Override
    public String getCategory() {
        return "Agentic";
    }

    @Override
    public boolean isSafe() {
        return false;
    }

    @Override
    public String getUnsafeToolMessage(String parameters) {
        try {
            InvokeCmdLineParams params = (InvokeCmdLineParams)this.deserializeArguments(parameters);
            return "Warning: This operation cannot be undone if changes are rejected in the chat session.\nStart command line: '" + params.commandLine + "' with timeout (seconds): " + params.timeoutSeconds + ".\nDo you want to proceed?";
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

