/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.RAGFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.ExtractDitamapContextParams;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GetDitaMapStructureContextFunctionSignature
implements RAGFunctionSignature {
    @Override
    public String getName() {
        return "get_ditamap_structure";
    }

    @Override
    public List<String> getAlternateNames() {
        return Collections.unmodifiableList(Arrays.asList("get_topic_context_in_toc"));
    }

    @Override
    public String getDescription() {
        return "Returns the hierarchical structure of the DITA Map around a selected topic, including ancestors, some siblings, and optionally descendants with configurable depth. If no topic is specified, returns the structure starting from the DITA Map root.";
    }

    @Override
    public String getUIDecriptionForChatMessage() {
        return "Get DITA map structure";
    }

    @Override
    public Class<?> getParameters() {
        return ExtractDitamapContextParams.class;
    }

    @Override
    public boolean isEnabled() {
        FunctionsAndRAGHelper projectRAGHelper = FunctionsAndRAGHelperProvider.getProjectRAGHelper();
        boolean hasOpenedDITAMap = projectRAGHelper == null || projectRAGHelper.hasDITAMapOpenedInDITAMapsManager();
        return hasOpenedDITAMap && RAGFunctionSignature.super.isEnabled();
    }
}

