/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.oxygenxml.positron.utilities.functions.RAGFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.DocumentParams;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GetContentForDocumentURLFunctionSignature
implements RAGFunctionSignature {
    @Override
    public String getName() {
        return "get_document_content";
    }

    @Override
    public List<String> getAlternateNames() {
        return Collections.unmodifiableList(Arrays.asList("get_content_for_document_url"));
    }

    @Override
    public String getDescription() {
        return "Read content from a local file or a remote URL resource (e.g. web resource or custom CMS protocol) by specifying its file path or URL. Returns content with line numbers in cat -n format.\n\nCRITICAL: Line numbers are for REFERENCE ONLY to help you locate content. When editing files, you MUST provide the actual text content WITHOUT any line numbers. Line numbers are NOT part of the file content.\n\nImportant guidelines:\n- Minimum read size is 200 lines per call\n- For large files (>500 lines), read in chunks rather than entire file\n- Reading entire file is permitted after editing operations or before performing operations for which the entire content is required\n- Always verify if retrieved content is sufficient before proceeding\n- If more context needed, call again with different line ranges\n\nExample of what you receive:\n1\t  <title>My Document</title>\n2\t  <body>Content here</body>\n\nExample of what you should use when editing:\n  <title>My Document</title>\n  <body>Content here</body>";
    }

    @Override
    public Class<?> getParameters() {
        return DocumentParams.class;
    }

    @Override
    public String getUIDecriptionForChatMessage() {
        return "Read document";
    }
}

