/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.api.connector.dto.ChatFunctionDTO;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalChatFunctionSignature
implements ChatFunctionSignature {
    private static final Logger log = LoggerFactory.getLogger(ExternalChatFunctionSignature.class);
    private String name;
    private String description;
    private String parametersSchema;
    private String uiCallDescription;
    private Object externalFunctionObject;

    public ExternalChatFunctionSignature(String name, String description, String uiCallDescription, String parametersSchema, Object externalFunctionObject) {
        this.name = name;
        this.description = description;
        this.parametersSchema = parametersSchema;
        this.uiCallDescription = uiCallDescription;
        this.externalFunctionObject = externalFunctionObject;
    }

    @Override
    public ChatFunctionDTO toDto() {
        ChatFunctionDTO chatFunctionDTO = new ChatFunctionDTO();
        chatFunctionDTO.setName(this.name);
        chatFunctionDTO.setDescription(this.description);
        String schema = this.getParamsSchema();
        try {
            chatFunctionDTO.setParametersObj(AIRequestUtil.defaultObjectMapper().readValue(schema, Object.class));
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return chatFunctionDTO;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getUIDecriptionForChatMessage() {
        return this.uiCallDescription;
    }

    @Override
    public Class<?> getParameters() {
        return Object.class;
    }

    @Override
    public boolean isEnabled() {
        boolean toRet;
        block7: {
            FunctionsAndRAGHelper projectRAGHelper = FunctionsAndRAGHelperProvider.getProjectRAGHelper();
            toRet = true;
            if (projectRAGHelper != null) {
                String functionName = this.getName();
                if ("search_project_resources".equals(functionName) || "get_ditamap_structure".equals(functionName)) {
                    toRet = projectRAGHelper.isRAGEnabledForChatAndActions();
                } else if ("add_dita_reference_to_ditamap".equals(functionName)) {
                    toRet = projectRAGHelper.isWriteEnabledForChatAndActions();
                }
            }
            if (toRet && this.externalFunctionObject != null) {
                try {
                    Method isEnabledMethod = this.externalFunctionObject.getClass().getMethod("isEnabled", new Class[0]);
                    toRet = (Boolean)isEnabledMethod.invoke(this.externalFunctionObject, new Object[0]);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return toRet;
    }

    @Override
    public String getParamsSchema() {
        String schema = this.parametersSchema;
        if (schema == null || schema.isEmpty()) {
            schema = "{\"$schema\" : \"https://json-schema.org/draft/2020-12/schema\",\"type\" : \"object\",\"properties\" : {}}";
        }
        return schema;
    }

    @Override
    public String getCategory() {
        return "External";
    }
}

