/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.functions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.WriteFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.CopyMoveRenameParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyMoveRenamePathFunctionSignature
implements WriteFunctionSignature {
    private static final Logger log = LoggerFactory.getLogger(CopyMoveRenamePathFunctionSignature.class);

    @Override
    public String getName() {
        return "copy_move_rename_path";
    }

    @Override
    public String getDescription() {
        return "Copy, move or rename a local file or folder.\nThe application notifies in the return status if it was successfull and if it managed also to updated references to the moved/renamed resources.";
    }

    @Override
    public Class<?> getParameters() {
        return CopyMoveRenameParams.class;
    }

    @Override
    public boolean isEnabled() {
        return WriteFunctionSignature.super.isEnabled() && FunctionsAndRAGHelperProvider.getProjectRAGHelper() != null && FunctionsAndRAGHelperProvider.getProjectRAGHelper().isCopyMoveRenamePathsAvailable();
    }

    @Override
    public String getUIDecriptionForChatMessage() {
        return "Copy, move or rename";
    }

    @Override
    public boolean isSafe() {
        return false;
    }

    @Override
    public String getUnsafeToolMessage(String parameters) {
        try {
            CopyMoveRenameParams params = (CopyMoveRenameParams)this.deserializeArguments(parameters);
            return "Warning: This operation cannot be undone if changes are rejected in the chat session.\n" + (params.copy ? "Copy " : "Move or rename ") + params.source_path + " to: " + params.destination_path + ".\nDo you want to proceed?";
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

