/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.debug;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.util.ArrayList;

public class LoggerUtil {
    private LoggerUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String writeValueAsPrettyJsonString(Object obj) {
        try {
            ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();
            DefaultIndenter indenter = new DefaultIndenter("    ", DefaultIndenter.SYS_LF);
            DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
            printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
            printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
            ObjectWriter writer = objectMapper.writer((PrettyPrinter)printer);
            return writer.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return e.getMessage();
        }
    }

    public static String filterMessagesFromRequestBody(String requestBody) {
        ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();
        try {
            JsonNode root = objectMapper.readTree(requestBody);
            LoggerUtil.filterSensitiveFields(root);
            return objectMapper.writeValueAsString((Object)root);
        }
        catch (Exception e) {
            return requestBody;
        }
    }

    private static void filterSensitiveFields(JsonNode node) {
        block5: {
            block4: {
                if (!node.isObject()) break block4;
                ObjectNode obj = (ObjectNode)node;
                ArrayList fieldsToProcess = new ArrayList();
                obj.fieldNames().forEachRemaining(fieldsToProcess::add);
                for (String field : fieldsToProcess) {
                    JsonNode child = obj.get(field);
                    if ("messages".equals(field)) {
                        obj.put(field, "[ **FILTERED_CONTENT** ]");
                        continue;
                    }
                    if ("content".equals(field) || "input".equals(field) || "description".equals(field) || "system".equals(field)) {
                        obj.put(field, " **FILTERED_CONTENT** ");
                        continue;
                    }
                    if (child == null || !child.isObject() && !child.isArray()) continue;
                    LoggerUtil.filterSensitiveFields(child);
                }
                break block5;
            }
            if (!node.isArray()) break block5;
            for (JsonNode item : node) {
                if (item == null || !item.isObject() && !item.isArray()) continue;
                LoggerUtil.filterSensitiveFields(item);
            }
        }
    }
}

