/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.credits;

import com.oxygenxml.positron.utilities.exceptions.InvalidParamException;
import com.oxygenxml.positron.utilities.models.ModelDTO;
import com.oxygenxml.positron.utilities.models.ModelLoader;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreditsConverterUtil {
    private static final Logger log = LoggerFactory.getLogger(CreditsConverterUtil.class);
    public static final float APPROX_TOKENS_PER_WORD_ENGLISH = 1.3f;

    private CreditsConverterUtil() {
    }

    public static final int getNoOfInputCreditsConsideringTier(int noOfTokens, int tierSelectionTokens, String engine) throws InvalidParamException {
        float noOfCredits = noOfTokens;
        float modelWeight = CreditsConverterUtil.getModelWeightWithTiers(tierSelectionTokens, engine, CostType.INPUT);
        return Math.round(noOfCredits *= modelWeight);
    }

    public static final int getNoOfOutputCreditsConsideringInput(int noOfOutputTokens, int tierSelectionTokens, String engine) throws InvalidParamException {
        float noOfCredits = noOfOutputTokens;
        float modelWeight = CreditsConverterUtil.getModelWeightWithTiers(tierSelectionTokens, engine, CostType.OUTPUT);
        return Math.round(noOfCredits *= modelWeight);
    }

    private static float getModelWeightWithTiers(int noOfTokens, String engine, CostType costType) throws InvalidParamException {
        List<ModelDTO.PricingTier> tiers;
        ModelLoader modelLoader = ModelLoader.getInstance();
        ModelDTO modelDTO = modelLoader.getBestMatchingModelDTO(engine);
        if (modelDTO == null) {
            throw new InvalidParamException("The model \"" + engine + "\" is not supported. Please use another model.");
        }
        boolean useInputTiers = costType == CostType.INPUT || costType == CostType.CACHE_READ || costType == CostType.CACHE_WRITE;
        List<ModelDTO.PricingTier> list = tiers = useInputTiers ? modelDTO.getInputPricingTiers() : modelDTO.getOutputPricingTiers();
        if (tiers != null && !tiers.isEmpty()) {
            tiers.sort(new Comparator<ModelDTO.PricingTier>(){

                @Override
                public int compare(ModelDTO.PricingTier a, ModelDTO.PricingTier b) {
                    return Integer.compare(this.getMaxTokens(a), this.getMaxTokens(b));
                }

                private int getMaxTokens(ModelDTO.PricingTier a) {
                    return a.getUpToTokens() == null || a.getUpToTokens() < 0 ? Integer.MAX_VALUE : a.getUpToTokens();
                }
            });
            ModelDTO.PricingTier matchingTier = null;
            for (ModelDTO.PricingTier tier : tiers) {
                Integer upto = tier.getUpToTokens();
                int cap = upto == null || upto < 0 ? Integer.MAX_VALUE : upto;
                if (noOfTokens > cap) continue;
                matchingTier = tier;
                break;
            }
            if (matchingTier == null) {
                matchingTier = tiers.get(tiers.size() - 1);
            }
            Float weight = null;
            switch (costType) {
                case INPUT: {
                    weight = matchingTier.getInputWeight();
                    break;
                }
                case OUTPUT: {
                    weight = matchingTier.getOutputWeight();
                    break;
                }
                case CACHE_READ: {
                    weight = matchingTier.getInputCacheReadWeight();
                    break;
                }
                case CACHE_WRITE: {
                    weight = matchingTier.getInputCacheWriteWeight();
                }
            }
            if (weight != null && weight.floatValue() > 0.0f) {
                return weight.floatValue();
            }
        }
        switch (costType) {
            case INPUT: {
                return modelDTO.getInputWeight();
            }
            case OUTPUT: {
                return modelDTO.getOutputWeight();
            }
            case CACHE_READ: {
                if (modelDTO.getInputCacheReadWeight() == 0.0f) {
                    log.error("The model \"" + engine + "\" does not have a cache read weight. Returning 0 credits.");
                }
                return modelDTO.getInputCacheReadWeight();
            }
            case CACHE_WRITE: {
                float weight = modelDTO.getInputCacheWriteWeight();
                if (weight == 0.0f) {
                    weight = modelDTO.getInputWeight();
                }
                return weight;
            }
        }
        return 0.0f;
    }

    public static final int getNoOfCreditsForCacheRead(int noOfCacheReadTokens, int tierSelectionTokens, String engine) throws InvalidParamException {
        float weight = CreditsConverterUtil.getModelWeightWithTiers(tierSelectionTokens, engine, CostType.CACHE_READ);
        float noOfCredits = (float)noOfCacheReadTokens * weight;
        return Math.round(noOfCredits);
    }

    public static final int getNoOfCreditsForCacheWrite(int noOfCacheWriteTokens, int tierSelectionTokens, String engine) throws InvalidParamException {
        float weight = CreditsConverterUtil.getModelWeightWithTiers(tierSelectionTokens, engine, CostType.CACHE_WRITE);
        float noOfCredits = (float)noOfCacheWriteTokens * weight;
        return Math.round(noOfCredits);
    }

    public static final float getApproximateCreditsPerWord(float creditsPerTokenWeight) {
        float rawCredits = 1.3f * creditsPerTokenWeight;
        if (rawCredits > 0.0f && rawCredits < 1.0f) {
            return Math.max(0.01f, (float)Math.round((double)rawCredits * 100.0) / 100.0f);
        }
        if (rawCredits >= 1.0f) {
            return (float)Math.floor(rawCredits);
        }
        return 0.0f;
    }

    private static enum CostType {
        INPUT,
        OUTPUT,
        CACHE_READ,
        CACHE_WRITE;

    }
}

