/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.claude;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.ChatFunctionDTO;
import com.oxygenxml.positron.api.connector.dto.CompletionChoice;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionFunctionCall;
import com.oxygenxml.positron.api.connector.dto.CompletionMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageContentType;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.PromptTokensDetails;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.api.connector.dto.TokensUsageInfo;
import com.oxygenxml.positron.api.connector.dto.Tool;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeCacheControl;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeCompletionRequest;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeCompletionResponse;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeFunctionDTO;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeImage;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeMessage;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeMessageContent;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeMessageContentType;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeMessageImageUrlContent;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeMessageInputJsonContent;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeMessageTextContent;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeToolResultContent;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeToolUseContent;
import com.oxygenxml.positron.utilities.claude.dto.ClaudeUsageInfo;
import com.oxygenxml.positron.utilities.claude.dto.EmptyClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClaudeRequestResponseMapper {
    private static final Logger log = LoggerFactory.getLogger(ClaudeRequestResponseMapper.class);
    private static final ObjectMapper OBJ_MAPPER = AIRequestUtil.defaultObjectMapper();
    private static final int DEFAULT_MAX_TOKENS = 4094;

    private ClaudeRequestResponseMapper() {
    }

    public static ClaudeCompletionRequest mapToClaudeRequest(CompletionRequest completionRequest) {
        ClaudeMessage lastMessage;
        List<ClaudeMessageContent> lastContent;
        List<ClaudeMessage> msgs;
        List messages = completionRequest.getMessages();
        List<ClaudeFunctionDTO> claudeFunctions = ClaudeRequestResponseMapper.getClaudeFunctions(completionRequest);
        ClaudeMessagesWithSystemPrompt updatedMessages = ClaudeRequestResponseMapper.updateMessages(messages, claudeFunctions);
        int maxTokens = completionRequest.getMaxTokens() != null ? completionRequest.getMaxTokens() : ClaudeRequestResponseMapper.getMaxTokensForModel(completionRequest.getModel());
        boolean shouldEnableCache = Boolean.TRUE.equals(completionRequest.getEnableCache());
        if (shouldEnableCache && (msgs = updatedMessages.messages) != null && !msgs.isEmpty() && (lastContent = (lastMessage = msgs.get(msgs.size() - 1)).getContent()) != null && !lastContent.isEmpty()) {
            lastContent.get(lastContent.size() - 1).setCacheControl(ClaudeCacheControl.ephemeral());
        }
        ClaudeCompletionRequest request = ClaudeCompletionRequest.builder().model(completionRequest.getModel()).system(updatedMessages.systemPrompt).messages(updatedMessages.messages).temperature(completionRequest.getTemperature() != null ? completionRequest.getTemperature().floatValue() : 0.0f).stream(completionRequest.getStream()).stop_sequences(completionRequest.getStop()).maxTokens(maxTokens).tools(claudeFunctions).build();
        return request;
    }

    public static CompletionChunk translateClaudeChunkToCommonChunk(ClaudeCompletionResponse chunk) {
        CompletionChunk translated = new CompletionChunk();
        List<ClaudeMessageContent> messages = chunk.getContent();
        ArrayList<CompletionChoice> choices = new ArrayList<CompletionChoice>(1);
        if (messages != null) {
            for (ClaudeMessageContent message : messages) {
                choices.add(ClaudeRequestResponseMapper.translateClaudeChunkMessageContentToCommonCompletion(chunk, message));
            }
        } else if (chunk.getContentBlock() != null) {
            choices.add(ClaudeRequestResponseMapper.translateClaudeChunkMessageContentToCommonCompletion(chunk, chunk.getContentBlock()));
        } else if (chunk.getDelta() != null) {
            choices.add(ClaudeRequestResponseMapper.translateClaudeChunkMessageContentToCommonCompletion(chunk, chunk.getDelta()));
        } else if (chunk.getMessage() != null) {
            return ClaudeRequestResponseMapper.translateClaudeChunkToCommonChunk(chunk.getMessage());
        }
        translated.setChoices(choices);
        translated.setModel(chunk.getModel());
        ClaudeUsageInfo claudeUsage = chunk.getUsage();
        if (claudeUsage != null) {
            TokensUsageInfo commonUsage = new TokensUsageInfo();
            int totalPromptTokens = claudeUsage.getInputTokens() + claudeUsage.getCacheReadInputTokens() + claudeUsage.getCacheCreationInputTokens();
            commonUsage.setPromptTokens(totalPromptTokens);
            commonUsage.setCompletionTokens(claudeUsage.getOutputTokens());
            commonUsage.setTotalTokens(totalPromptTokens + claudeUsage.getOutputTokens());
            if (claudeUsage.getCacheReadInputTokens() > 0 || claudeUsage.getCacheCreationInputTokens() > 0) {
                PromptTokensDetails details = new PromptTokensDetails();
                details.setCachedTokens(claudeUsage.getCacheReadInputTokens());
                details.setCacheCreationInputTokens(claudeUsage.getCacheCreationInputTokens());
                commonUsage.setPromptTokensDetails(details);
            }
            translated.setUsage(commonUsage);
        }
        return translated;
    }

    private static int getMaxTokensForModel(String model) {
        int maxTokens = 4094;
        if (model != null) {
            String normalizedModel = model.toLowerCase();
            if (normalizedModel.contains("haiku")) {
                maxTokens = ClaudeRequestResponseMapper.getMaxTokensForHaiku(normalizedModel);
            } else if (normalizedModel.contains("sonnet")) {
                maxTokens = ClaudeRequestResponseMapper.getMaxTokensForSonnet(normalizedModel);
            } else if (normalizedModel.contains("opus")) {
                maxTokens = ClaudeRequestResponseMapper.getMaxTokensForOpus(normalizedModel);
            }
        }
        return maxTokens;
    }

    private static int getMaxTokensForHaiku(String normalizedModel) {
        int maxTokens = 4096;
        if (normalizedModel.contains("3-5")) {
            maxTokens = 8192;
        } else if (normalizedModel.contains("4-5")) {
            maxTokens = 64000;
        }
        return maxTokens;
    }

    private static int getMaxTokensForSonnet(String normalizedModel) {
        int maxTokens = 8192;
        if (normalizedModel.contains("sonnet-4")) {
            maxTokens = 64000;
        }
        return maxTokens;
    }

    private static int getMaxTokensForOpus(String normalizedModel) {
        int maxTokens = 4094;
        if (normalizedModel.contains("opus-4")) {
            maxTokens = 32000;
        } else if (normalizedModel.contains("opus-4-5")) {
            maxTokens = 64000;
        }
        return maxTokens;
    }

    private static ClaudeMessagesWithSystemPrompt updateMessages(List<Message> messages, List<ClaudeFunctionDTO> functions) {
        ArrayList<ClaudeMessage> updatedMessagesList = new ArrayList<ClaudeMessage>();
        ClaudeMessage lastMessage = null;
        StringBuilder systemMessage = new StringBuilder();
        RoleType lastRole = RoleType.SYSTEM;
        for (int i = 0; i < messages.size(); ++i) {
            ClaudeMessage newMessage;
            Message message = messages.get(i);
            if (ClaudeRequestResponseMapper.isInitialSystemRoleFollowedByUserRole(lastRole, message, i, messages)) {
                StringBuilder textContent = new StringBuilder();
                List content = message.getContent();
                for (MessageContent messageContent : content) {
                    if (messageContent instanceof MessageTextContent) {
                        textContent.append(((MessageTextContent)messageContent).getText());
                        continue;
                    }
                    textContent.setLength(0);
                    break;
                }
                if (textContent.length() > 0) {
                    systemMessage.append((CharSequence)textContent);
                    continue;
                }
            }
            lastRole = message.getRole();
            RoleType role = ClaudeRequestResponseMapper.getAllowedRole(message);
            List<ClaudeMessageContent> translateMessageToClaudeMessageContent = ClaudeRequestResponseMapper.translateMessageToClaudeMessageContent(message, functions);
            if (translateMessageToClaudeMessageContent.isEmpty()) continue;
            if (lastMessage == null) {
                lastMessage = newMessage = new ClaudeMessage(role, new ArrayList<ClaudeMessageContent>(translateMessageToClaudeMessageContent));
                updatedMessagesList.add(newMessage);
                continue;
            }
            if (lastMessage.getRole() == role) {
                lastMessage.getContent().addAll(translateMessageToClaudeMessageContent);
                continue;
            }
            lastMessage = newMessage = new ClaudeMessage(role, new ArrayList<ClaudeMessageContent>(translateMessageToClaudeMessageContent));
            updatedMessagesList.add(newMessage);
        }
        if (updatedMessagesList.isEmpty()) {
            ArrayList<ClaudeMessageContent> defaultContent = new ArrayList<ClaudeMessageContent>();
            defaultContent.add(new ClaudeMessageTextContent("Please help me with this task."));
            updatedMessagesList.add(new ClaudeMessage(RoleType.USER, defaultContent));
        }
        ClaudeMessagesWithSystemPrompt messagesWithPrompt = new ClaudeMessagesWithSystemPrompt();
        messagesWithPrompt.messages = updatedMessagesList;
        if (systemMessage.length() > 0) {
            messagesWithPrompt.systemPrompt = systemMessage.toString();
        }
        return messagesWithPrompt;
    }

    private static boolean isInitialSystemRoleFollowedByUserRole(RoleType lastRole, Message message, int index, List<Message> messages) {
        boolean isInitialSystem;
        boolean bl = isInitialSystem = message.getRole() == RoleType.SYSTEM && lastRole == RoleType.SYSTEM;
        if (isInitialSystem) {
            int size = messages.size();
            for (int i = index + 1; i < size; ++i) {
                Message after = messages.get(i);
                if (after.getRole() == RoleType.SYSTEM) continue;
                return after.getRole() == RoleType.USER;
            }
        }
        return false;
    }

    private static List<ClaudeMessageContent> translateMessageToClaudeMessageContent(Message message, List<ClaudeFunctionDTO> functions) {
        ArrayList<ClaudeMessageContent> newContentList = new ArrayList<ClaudeMessageContent>();
        if (message.getRole() == RoleType.TOOL) {
            ClaudeToolResultContent claudeToolResultContent = new ClaudeToolResultContent();
            ToolCallResponseMessage toolCallMessage = (ToolCallResponseMessage)message;
            claudeToolResultContent.setToolUseId(toolCallMessage.getToolCallId());
            MessageContent content = (MessageContent)toolCallMessage.getContent().get(0);
            claudeToolResultContent.setContent(((MessageTextContent)content).getText());
            newContentList.add(claudeToolResultContent);
        } else {
            List contentList = message.getContent();
            if (contentList != null) {
                for (MessageContent messageContent : contentList) {
                    if (messageContent.getType() == MessageContentType.TEXT) {
                        String text = ((MessageTextContent)messageContent).getText();
                        if (text == null || text.trim().isEmpty()) continue;
                        newContentList.add(new ClaudeMessageTextContent(text));
                        continue;
                    }
                    if (messageContent.getType() != MessageContentType.IMAGE_URL) continue;
                    MessageImageUrlContent imageContent = (MessageImageUrlContent)messageContent;
                    String base64URL = imageContent.getImageUrl().getUrl();
                    int indexOfSemi = base64URL.indexOf(59);
                    int base64PreambleAfter = base64URL.indexOf(";base64,") + ";base64,".length();
                    String mediaType = base64URL.substring("data:".length(), indexOfSemi);
                    String data = base64URL.substring(base64PreambleAfter);
                    ClaudeImage ci = new ClaudeImage(data.trim(), "base64", mediaType.trim().toLowerCase());
                    ClaudeMessageImageUrlContent claudeImageContent = new ClaudeMessageImageUrlContent(ci);
                    newContentList.add(claudeImageContent);
                }
            }
            ClaudeRequestResponseMapper.translateToolCallsToToolUseContents(message, functions, newContentList);
        }
        return newContentList;
    }

    private static void translateToolCallsToToolUseContents(Message message, List<ClaudeFunctionDTO> functions, List<ClaudeMessageContent> newContentList) {
        if (message instanceof AssistantMessage && ((AssistantMessage)message).getToolCalls() != null) {
            List toolCalls = ((AssistantMessage)message).getToolCalls();
            for (CompletionToolCall toolCall : toolCalls) {
                ClaudeToolUseContent toolUseContent = new ClaudeToolUseContent();
                toolUseContent.setId(toolCall.getId());
                toolUseContent.setName(toolCall.getFunction().getName());
                try {
                    if (functions != null) {
                        Optional<ClaudeFunctionDTO> function = functions.stream().filter(f -> f.getName().equals(toolCall.getFunction().getName())).findAny();
                        if (function.isPresent() && toolCall.getFunction().getArguments() != null && !toolCall.getFunction().getArguments().isBlank()) {
                            ClaudeFunctionDTO claudeFunction = function.get();
                            if (claudeFunction.getParametersObject() != null) {
                                toolUseContent.setInput(OBJ_MAPPER.readValue(toolCall.getFunction().getArguments(), Object.class));
                            } else {
                                toolUseContent.setInput(new EmptyClass());
                            }
                        } else {
                            toolUseContent.setInput(new EmptyClass());
                        }
                    }
                }
                catch (JsonProcessingException e) {
                    log.error("Failed to serialized the tool use input: " + toolCall.getFunction().getArguments() + " Error: " + e.getMessage(), (Throwable)e);
                }
                newContentList.add(toolUseContent);
            }
        }
    }

    private static RoleType getAllowedRole(Message message) {
        RoleType role = message.getRole();
        if (role == RoleType.SYSTEM || role == RoleType.TOOL) {
            role = RoleType.USER;
        }
        return role;
    }

    private static String mapClaudeFinishReasonToOpenAI(String claudeFinishReason) {
        if (claudeFinishReason == null) {
            return null;
        }
        switch (claudeFinishReason) {
            case "end_turn": 
            case "stop_sequence": {
                return "stop";
            }
            case "max_tokens": 
            case "model_context_window_exceeded": {
                return "length";
            }
            case "tool_use": 
            case "pause_turn": {
                return "tool_calls";
            }
            case "refusal": {
                return "content_filter";
            }
        }
        return claudeFinishReason;
    }

    private static CompletionChoice translateClaudeChunkMessageContentToCommonCompletion(ClaudeCompletionResponse chunk, ClaudeMessageContent claudeContent) {
        ClaudeMessageTextContent claudeTextContent;
        ArrayList<CompletionToolCall> toolCalls;
        CompletionMessage message = new CompletionMessage();
        if (claudeContent.getType() == ClaudeMessageContentType.TOOL_USE) {
            ClaudeToolUseContent toolUseContent = (ClaudeToolUseContent)claudeContent;
            toolCalls = new ArrayList<CompletionToolCall>(1);
            CompletionToolCall completionToolCall = new CompletionToolCall();
            completionToolCall.setId(toolUseContent.getId());
            completionToolCall.setType("function");
            CompletionFunctionCall function = new CompletionFunctionCall();
            function.setName(toolUseContent.getName());
            if (toolUseContent.getInput() != null) {
                try {
                    String inputString = toolUseContent.getInput() instanceof String ? (String)toolUseContent.getInput() : OBJ_MAPPER.writeValueAsString(toolUseContent.getInput());
                    if (!inputString.isEmpty() && !inputString.equals("{}")) {
                        function.setArguments(inputString);
                    }
                }
                catch (JsonProcessingException e) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
            completionToolCall.setFunction(function);
            completionToolCall.setIndex(chunk.getIndex());
            toolCalls.add(completionToolCall);
            message.setToolCalls(toolCalls);
        } else if (claudeContent.getType() == ClaudeMessageContentType.INPUT_JSON_DELTA) {
            ClaudeMessageInputJsonContent deltaToolUseContent = (ClaudeMessageInputJsonContent)claudeContent;
            toolCalls = new ArrayList(1);
            CompletionToolCall completionToolCall = new CompletionToolCall();
            completionToolCall.setType("function");
            CompletionFunctionCall function = new CompletionFunctionCall();
            function.setArguments(deltaToolUseContent.getPartialJson());
            completionToolCall.setFunction(function);
            completionToolCall.setIndex(chunk.getIndex());
            toolCalls.add(completionToolCall);
            message.setToolCalls(toolCalls);
        } else if (claudeContent instanceof ClaudeMessageTextContent && (claudeTextContent = (ClaudeMessageTextContent)claudeContent).getText() != null && !claudeTextContent.getText().isEmpty()) {
            message.setContent(claudeTextContent.getText());
        }
        CompletionChoice cc = new CompletionChoice();
        cc.setMessage(message);
        String claudeFinishReason = claudeContent.getFinishReason() != null ? claudeContent.getFinishReason() : chunk.getFinishReason();
        cc.setFinishReason(ClaudeRequestResponseMapper.mapClaudeFinishReasonToOpenAI(claudeFinishReason));
        return cc;
    }

    private static List<ClaudeFunctionDTO> getClaudeFunctions(CompletionRequest completionRequest) {
        ArrayList<ClaudeFunctionDTO> functions = null;
        List tools = completionRequest.getTools();
        if (tools instanceof List) {
            List toolsList = tools;
            for (Object tool : toolsList) {
                if (!(tool instanceof Tool)) continue;
                if (functions == null) {
                    functions = new ArrayList<ClaudeFunctionDTO>();
                }
                ChatFunctionDTO function = ((Tool)tool).getFunction();
                ClaudeFunctionDTO claudeFunctionDTO = new ClaudeFunctionDTO();
                claudeFunctionDTO.setContent(function);
                functions.add(claudeFunctionDTO);
            }
        }
        return functions;
    }

    private static class ClaudeMessagesWithSystemPrompt {
        private String systemPrompt;
        private List<ClaudeMessage> messages;

        private ClaudeMessagesWithSystemPrompt() {
        }
    }
}

