/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.utilities.action.IActionsRepository;
import com.oxygenxml.positron.utilities.exceptions.InvalidParamException;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.Engine;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionsUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)ActionsUtil.class.getName());

    private ActionsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static AIActionDetails getActionDetails(String id, IActionsRepository actionsRepository, Map<String, String> actionParams) throws InvalidParamException {
        AIActionDetails actionDetails = actionsRepository.searchForActionDetails(id);
        if (actionDetails == null) {
            throw new InvalidParamException("Invalid action ID: " + id);
        }
        return ActionsUtil.getActionDetailsWithNewEngine(actionParams, actionDetails);
    }

    public static AIActionDetails clearEngineFromActionDetails(AIActionDetails actionDetails) {
        AIActionDetails actionDetailsToReturn = actionDetails;
        if (actionDetails.getParameters() != null && actionDetails.getParameters().getEngine() != null) {
            try {
                actionDetailsToReturn = (AIActionDetails)ActionsUtil.cloneJSONSerializableObject(actionDetails, AIActionDetails.class);
                if (actionDetailsToReturn != null) {
                    actionDetailsToReturn.getParameters().setEngine(null);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return actionDetailsToReturn;
    }

    public static AIActionDetails getActionDetailsWithNewEngine(Map<String, String> actionParams, AIActionDetails actionDetails) {
        AIActionDetails actionDetailsToReturn = actionDetails;
        try {
            AIActionDetails clonedActionDetails = (AIActionDetails)ActionsUtil.cloneJSONSerializableObject(actionDetails, AIActionDetails.class);
            if (clonedActionDetails != null && actionParams != null) {
                boolean shouldUseImposedEngineParam;
                String newEngineParamName = null;
                boolean bl = shouldUseImposedEngineParam = actionParams.getOrDefault("imposed.engine.model", null) != null;
                if (shouldUseImposedEngineParam) {
                    newEngineParamName = "imposed.engine.model";
                } else if (ActionsUtil.shouldUseDefaultEngineInActionDetails(actionParams, actionDetails)) {
                    newEngineParamName = "default.engine.model";
                }
                if (newEngineParamName != null) {
                    Engine engine = new Engine(actionParams.get(newEngineParamName));
                    clonedActionDetails.getParameters().setEngine(engine);
                    actionDetailsToReturn = clonedActionDetails;
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return actionDetailsToReturn;
    }

    private static boolean shouldUseDefaultEngineInActionDetails(Map<String, String> actionParams, AIActionDetails actionDetails) {
        return Objects.isNull(actionParams.getOrDefault("imposed.engine.model", null)) && actionParams.containsKey("default.engine.model") && actionDetails != null && actionDetails.getParameters().getEngine() == null;
    }

    public static Object cloneJSONSerializableObject(Object object, Class objectClass) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        objectMapper.writeValue((Writer)sw, object);
        sw.close();
        return objectMapper.readValue((Reader)new StringReader(sw.toString()), objectClass);
    }

    public static void expandPromptRef(Collection<AIActionDetails> actionDetails, URL url) {
        if (actionDetails != null) {
            for (AIActionDetails details : actionDetails) {
                if (details.getPromptRef() == null) continue;
                ActionsUtil.expandPromptRef(url, details);
            }
        }
    }

    private static void expandPromptRef(URL url, AIActionDetails details) {
        String prHref = details.getPromptRef();
        try {
            URL prRef = new URL(url, prHref);
            Object promptRefContent = ActionsUtil.readUTF8URL(url, prRef);
            if (ActionsUtil.isMarkdown(prHref)) {
                promptRefContent = ActionsUtil.unescapeEditorVariables((String)promptRefContent);
            }
            details.setPromptRef(null);
            String prompt = details.getPrompt();
            if (prompt != null) {
                promptRefContent = prompt + "\n" + (String)promptRefContent;
            }
            details.setPrompt((String)promptRefContent);
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Problem expanding promptref " + prHref, (Throwable)e);
        }
    }

    private static boolean isMarkdown(String prHref) {
        return prHref.endsWith(".md") || prHref.endsWith(".markdown");
    }

    public static String unescapeEditorVariables(String content) {
        if (content.contains("$\\{")) {
            content = content.replaceAll("\\$\\\\\\{(.*?)\\\\}", "\\$\\{$1\\}");
        }
        return content;
    }

    static String readUTF8URL(URL baseURL, URL url) throws IOException, URISyntaxException {
        StringBuilder result = new StringBuilder();
        if ("file".equals(url.getProtocol()) && ActionsUtil.isInsideBaseURLFolder(baseURL, url)) {
            File promptFile = new File(url.toURI());
            try (FileInputStream originalIs = new FileInputStream(promptFile);){
                ActionsUtil.readFromIS(result, originalIs);
            }
        }
        try (InputStream originalIs = url.openConnection().getInputStream();){
            ActionsUtil.readFromIS(result, originalIs);
        }
        return result.toString();
    }

    private static boolean isInsideBaseURLFolder(URL baseURL, URL url) {
        String baseURLStr;
        int slashIndex;
        if (baseURL != null && (slashIndex = (baseURLStr = baseURL.toString()).lastIndexOf(47)) != -1) {
            String baseURLDir = baseURLStr.substring(0, slashIndex + 1);
            String urlStr = url.toString();
            if (urlStr.startsWith(baseURLDir) && !urlStr.contains("../")) {
                return true;
            }
        }
        return false;
    }

    private static void readFromIS(StringBuilder result, InputStream originalIs) throws IOException {
        InputStream is = ActionsUtil.consumeUTF8BOM(originalIs);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            char[] buffer = new char[1024];
            int len = -1;
            while ((len = in.read(buffer)) != -1) {
                result.append(buffer, 0, len);
            }
        }
    }

    private static InputStream consumeUTF8BOM(InputStream in) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(3);
        try {
            if (bin.read() != 239 || bin.read() != 187 || bin.read() != 191) {
                bin.reset();
            }
        }
        catch (IOException e) {
            bin.reset();
        }
        return bin;
    }

    public static void expandPromptRef(Collection<AIActionDetails> actionDetails, String path, Map<String, byte[]> extraDefinitions) {
        if (actionDetails != null) {
            for (AIActionDetails details : actionDetails) {
                if (details.getPromptRef() == null) continue;
                ActionsUtil.expandPromptRef(path, extraDefinitions, details);
            }
        }
    }

    private static void expandPromptRef(String path, Map<String, byte[]> extraDefinitions, AIActionDetails details) {
        String prHref = details.getPromptRef();
        try {
            String ref;
            byte[] content;
            String parentPath = "";
            int indexOfSlash = path.lastIndexOf(47);
            if (indexOfSlash != -1) {
                parentPath = path.substring(0, indexOfSlash + 1);
            }
            if ((content = extraDefinitions.get(ref = parentPath + prHref)) != null) {
                Object promptRefContent = new String(content, "UTF-8");
                if (ActionsUtil.isMarkdown(prHref)) {
                    promptRefContent = ActionsUtil.unescapeEditorVariables((String)promptRefContent);
                }
                details.setPromptRef(null);
                String prompt = details.getPrompt();
                if (prompt != null) {
                    promptRefContent = prompt + "\n" + (String)promptRefContent;
                }
                details.setPrompt((String)promptRefContent);
            } else {
                logger.error("Could not find content referenced with prompt_ref for action {}  reference {} gathered content {} ", new Object[]{details.getId(), ref, extraDefinitions});
            }
        }
        catch (IOException e) {
            logger.error("Problem expanding promptref " + prHref, (Throwable)e);
        }
    }

    public static boolean isNewFileWithAIPseudoaction(String actionID) {
        return actionID != null && actionID.startsWith("pseudoaction.new.file.with.ai.");
    }

    public static boolean isAgentAction(AIActionDetails actionDetails) {
        if (actionDetails == null) {
            return false;
        }
        String actionId = actionDetails.getId();
        if (actionId == null) {
            return false;
        }
        return actionId.contains(".agent");
    }
}

