/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities;

import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageContentType;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlWithResolutionContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.exceptions.ModelTokensLimitExcededException;
import com.oxygenxml.positron.utilities.json.Engine;
import com.oxygenxml.positron.utilities.models.ModelDTO;
import com.oxygenxml.positron.utilities.models.ModelLoader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokensUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)TokensUtil.class.getName());
    private static final int OPEN_AI_SMALL_SQUARE_TOKENS_COST = 170;
    private static final int OPEN_AI_MAX_SHORT_SIDE_IMAGE_DIMENSION = 768;
    private static final int OPEN_AI_MAX_IMAGE_DIMENSION = 2048;
    private static final int OPEN_AI_LOW_RES_DIMENSION = 512;
    private static final int OPEN_AI_LOW_RES_IMG_TOKENS = 85;

    private TokensUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static void checkLimit(List<Message> requestMessages, Engine engine) throws ModelTokensLimitExcededException, InvalidMessageException {
        if (engine != null) {
            int maxTotalTokensForEngine = TokensUtil.getMaxTotalTokensForEngine(engine.getId());
            if (maxTotalTokensForEngine != -1) {
                int inputTokens = Math.round(TokensUtil.calculateTokens(requestMessages));
                if (inputTokens > maxTotalTokensForEngine) {
                    throw new ModelTokensLimitExcededException(maxTotalTokensForEngine, inputTokens, requestMessages);
                }
            } else {
                logger.debug("Cannot find max total tokens mapping for engine: {}. Input tokens limit check was skipped.", (Object)engine.getId());
            }
        }
    }

    static int getMaxTotalTokensForEngine(String engineID) {
        int max = -1;
        ModelLoader modelLoader = ModelLoader.getInstance();
        ModelDTO bestMatchingModelDTO = modelLoader.getBestMatchingModelDTO(engineID);
        if (bestMatchingModelDTO != null) {
            max = bestMatchingModelDTO.getMaxTotalTokens();
        }
        return max;
    }

    public static float getAproximateNumberOfTextTokens(String text) {
        return (float)text.length() / 4.0f;
    }

    public static float calculateTokens(List<Message> messages) throws InvalidMessageException {
        float noOfTokens = 0.0f;
        for (Message message : messages) {
            List contentItems = message.getContent();
            for (MessageContent contentItem : contentItems) {
                if (contentItem.getType() == MessageContentType.TEXT) {
                    MessageTextContent textContent = (MessageTextContent)contentItem;
                    noOfTokens += TokensUtil.getAproximateNumberOfTextTokens(textContent.getText());
                    continue;
                }
                if (contentItem.getType() == MessageContentType.IMAGE_URL) {
                    if (contentItem instanceof MessageImageUrlWithResolutionContent) {
                        noOfTokens += (float)TokensUtil.calculateImageTokens((Pair<Integer, Integer>)((MessageImageUrlWithResolutionContent)contentItem).getImageResolution());
                        continue;
                    }
                    logger.debug("Invalid message content item of class {}. Expected MessageImageUrlWithResolutionContent.", contentItem.getClass());
                    throw new InvalidMessageException("Invalid type of content item detected in a request message.");
                }
                throw new InvalidMessageException("Invalid message content type: " + contentItem.getType());
            }
        }
        return noOfTokens;
    }

    static int calculateImageTokens(Pair<Integer, Integer> imageResolution) {
        boolean isLowResImage;
        int noOfTokens = 85;
        Integer width = (Integer)imageResolution.getFirst();
        Integer height = (Integer)imageResolution.getSecond();
        boolean bl = isLowResImage = width <= 512 && height <= 512;
        if (!isLowResImage) {
            if (height > 2048 || width > 2048) {
                double aspectRatio = (double)width.intValue() / (double)height.intValue();
                if (width > height) {
                    width = 2048;
                    height = (int)((double)width.intValue() / aspectRatio);
                } else {
                    height = 2048;
                    width = (int)((double)height.intValue() * aspectRatio);
                }
            }
            if (Math.min(width, height) > 768) {
                double scalingFactor = 768.0 / (double)Math.min(width, height);
                width = (int)((double)width.intValue() * scalingFactor);
                height = (int)((double)height.intValue() * scalingFactor);
            }
            int squares = (int)Math.ceil((double)width.intValue() / 512.0) * (int)Math.ceil((double)height.intValue() / 512.0);
            noOfTokens += 170 * squares;
        }
        return noOfTokens;
    }
}

