/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.utilities;

import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.Engine;
import com.oxygenxml.positron.utilities.json.Parameters;

public final class ModelIdentifierUtil {
    private static final String NAMESPACE_SEPARATOR = "::";

    public static String[] splitModelIdentifier(String modelIdentifier) {
        String[] toRet = new String[2];
        if (modelIdentifier != null && modelIdentifier.contains(NAMESPACE_SEPARATOR)) {
            String[] parts = modelIdentifier.split(NAMESPACE_SEPARATOR, 2);
            toRet[0] = parts.length > 0 ? parts[0] : null;
            toRet[1] = parts.length > 1 ? parts[1] : null;
        } else {
            toRet[0] = null;
            toRet[1] = modelIdentifier;
        }
        return toRet;
    }

    public static String buildModelIdentifier(String configurationId, String modelId) {
        String model = modelId != null ? modelId : "";
        return configurationId + NAMESPACE_SEPARATOR + model;
    }

    public static String extractModelId(String namespacedIdentifier) {
        if (namespacedIdentifier == null) {
            return null;
        }
        int idx = namespacedIdentifier.indexOf(NAMESPACE_SEPARATOR);
        return idx >= 0 ? namespacedIdentifier.substring(idx + NAMESPACE_SEPARATOR.length()) : namespacedIdentifier;
    }

    public static AIActionDetails stripConfigurationFromEngineIfPresent(AIActionDetails actionDetails) {
        Parameters parameters;
        String engineId;
        if (actionDetails != null && actionDetails.getParameters() != null && actionDetails.getParameters().getEngine() != null && (engineId = (parameters = actionDetails.getParameters()).getEngine().getId()) != null) {
            String modelOnly = ModelIdentifierUtil.extractModelId(engineId);
            Engine engineToSet = null;
            if (modelOnly != null && !modelOnly.isEmpty()) {
                engineToSet = new Engine(modelOnly);
            }
            parameters.setEngine(engineToSet);
        }
        return actionDetails;
    }

    public static String buildPositronServiceDefaultModelIdentifier(Engine engine) {
        return ModelIdentifierUtil.buildModelIdentifier("aips", engine.getId());
    }

    public static String createConfigurationId(String name) {
        String configId = name.trim().toLowerCase().replaceAll("\\s+", "_");
        configId = configId.replace(":", "_");
        configId = configId.replaceAll("_+", "_");
        return configId;
    }

    private ModelIdentifierUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

