/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach.pdf;

import com.oxygenxml.positron.core.util.attach.pdf.ImagePosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;

class PDFImageExtractor
extends PDFStreamEngine {
    private final List<ImagePosition> images = new ArrayList<ImagePosition>();

    public PDFImageExtractor() throws IOException {
        this.addOperator(PDFImageExtractor.createOperatorProcessor(Concatenate.class, this));
        this.addOperator(PDFImageExtractor.createOperatorProcessor(DrawObject.class, this));
        this.addOperator(PDFImageExtractor.createOperatorProcessor(SetGraphicsStateParameters.class, this));
        this.addOperator(PDFImageExtractor.createOperatorProcessor(Save.class, this));
        this.addOperator(PDFImageExtractor.createOperatorProcessor(Restore.class, this));
        this.addOperator(PDFImageExtractor.createOperatorProcessor(SetMatrix.class, this));
    }

    private static OperatorProcessor createOperatorProcessor(Class clazz, PDFStreamEngine engine) {
        try {
            return (OperatorProcessor)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            try {
                return (OperatorProcessor)clazz.getConstructor(PDFStreamEngine.class).newInstance(engine);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    protected void processOperator(Operator operator, List<COSBase> operands) throws IOException {
        String operation = operator.getName();
        if ("Do".equals(operation)) {
            COSName objectName = (COSName)operands.get(0);
            PDXObject xobject = this.getResources().getXObject(objectName);
            if (xobject instanceof PDImageXObject) {
                Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
                float yPos = ctm.getTranslateY();
                this.images.add(new ImagePosition((PDImageXObject)xobject, yPos));
            } else if (xobject instanceof PDFormXObject) {
                PDFormXObject form = (PDFormXObject)xobject;
                this.showForm(form);
            }
        }
        super.processOperator(operator, operands);
    }

    public List<ImagePosition> getImages() {
        return this.images;
    }
}

