/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach.pdf;

import com.oxygenxml.positron.core.util.attach.pdf.PdfDocumentUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

class FontAwareTextStripper
extends PDFTextStripper {
    private static final int MIN_GAP_BETWEEN_COLUMNS = 20;
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private List<PdfDocumentUtils.TextLineInfo> textLines = new ArrayList<PdfDocumentUtils.TextLineInfo>();
    private StringBuilder currentLine = new StringBuilder();
    private float currentFontSize = 0.0f;
    private boolean currentIsBold = false;
    private boolean currentIsItalic = false;
    private String currentFontName = "";
    private int currentCharCount = 0;
    private int currentPageNumber = 1;
    private List<Float> currentXPositions = new ArrayList<Float>();
    private List<String> currentSegments = new ArrayList<String>();
    private List<PdfDocumentUtils.TextSegment> currentTextSegments = new ArrayList<PdfDocumentUtils.TextSegment>();
    private float lastXPosition = -1.0f;
    private float currentYPosition = 0.0f;
    private StringBuilder currentSegment = new StringBuilder();
    private StringBuilder currentFormattedSegment = new StringBuilder();
    private boolean currentSegmentIsBold = false;
    private boolean currentSegmentIsItalic = false;
    private boolean currentSegmentIsMonospaced = false;

    public FontAwareTextStripper() throws IOException {
        this.setSortByPosition(true);
    }

    protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
        for (TextPosition position : textPositions) {
            boolean isBold;
            String fontName = position.getFont().getName();
            float fontSize = position.getFontSizeInPt();
            float xPos = position.getXDirAdj();
            float yPos = position.getYDirAdj();
            boolean isItalic = this.isItalic(fontName);
            boolean isMonospaced = this.isMonospaceFont(fontName);
            boolean bl = isBold = !isMonospaced && this.isBold(fontName);
            if (this.currentCharCount == 0) {
                this.currentFontSize = fontSize;
                this.currentIsBold = isBold;
                this.currentIsItalic = isItalic;
                this.currentFontName = fontName != null ? fontName : "";
                this.currentYPosition = yPos;
            } else {
                this.currentFontSize = (this.currentFontSize * (float)this.currentCharCount + fontSize) / (float)(this.currentCharCount + 1);
                this.currentIsBold = this.currentIsBold && isBold;
                this.currentIsItalic = this.currentIsItalic && isItalic;
            }
            ++this.currentCharCount;
            if (isBold != this.currentSegmentIsBold || isItalic != this.currentSegmentIsItalic || isMonospaced != this.currentSegmentIsMonospaced) {
                if (this.currentFormattedSegment.length() > 0) {
                    this.currentTextSegments.add(new PdfDocumentUtils.TextSegment(this.currentFormattedSegment.toString(), this.currentSegmentIsBold, this.currentSegmentIsItalic, this.currentSegmentIsMonospaced));
                    this.currentFormattedSegment = new StringBuilder();
                }
                this.currentSegmentIsBold = isBold;
                this.currentSegmentIsItalic = isItalic;
                this.currentSegmentIsMonospaced = isMonospaced;
            }
            if (this.lastXPosition > 0.0f && xPos - this.lastXPosition > 20.0f && this.currentSegment.length() > 0) {
                if (this.currentFormattedSegment.length() > 0) {
                    this.currentTextSegments.add(new PdfDocumentUtils.TextSegment(this.currentFormattedSegment.toString(), this.currentSegmentIsBold, this.currentSegmentIsItalic, this.currentSegmentIsMonospaced));
                    this.currentFormattedSegment = new StringBuilder();
                }
                this.currentSegments.add(this.currentSegment.toString());
                this.currentXPositions.add(Float.valueOf(this.lastXPosition));
                this.currentSegment = new StringBuilder();
                this.currentSegmentIsBold = false;
                this.currentSegmentIsItalic = false;
                this.currentSegmentIsMonospaced = false;
            }
            this.currentSegment.append(position.getUnicode());
            this.currentFormattedSegment.append(position.getUnicode());
            this.lastXPosition = xPos;
        }
        this.currentLine.append(text);
        super.writeString(text, textPositions);
    }

    private boolean isItalic(String fontName) {
        return fontName != null && (fontName.toLowerCase().contains("italic") || fontName.toLowerCase().contains("oblique"));
    }

    private boolean isBold(String fontName) {
        return fontName != null && (fontName.toLowerCase().contains("bold") || fontName.toLowerCase().contains("heavy") || fontName.toLowerCase().contains("black"));
    }

    private boolean isMonospaceFont(String fontName) {
        if (fontName == null || fontName.isEmpty()) {
            return false;
        }
        String lowerFontName = fontName.toLowerCase();
        return lowerFontName.contains("courier") || lowerFontName.contains("consolas") || lowerFontName.contains("monaco") || lowerFontName.contains("menlo") || lowerFontName.contains("lucida console") || lowerFontName.contains("dejavu sans mono") || lowerFontName.contains("source code") || lowerFontName.contains("fira code") || lowerFontName.contains("fira mono") || lowerFontName.contains("mono") || lowerFontName.contains("code") || lowerFontName.contains("console") || lowerFontName.contains("fixed") || lowerFontName.contains("typewriter") || lowerFontName.contains("terminal") || lowerFontName.contains("pre") || lowerFontName.contains("monospace");
    }

    protected void writeLineSeparator() throws IOException {
        if (this.currentSegment.length() > 0) {
            this.currentSegments.add(this.currentSegment.toString());
            this.currentXPositions.add(Float.valueOf(this.lastXPosition));
        }
        if (this.currentFormattedSegment.length() > 0) {
            this.currentTextSegments.add(new PdfDocumentUtils.TextSegment(this.currentFormattedSegment.toString(), this.currentSegmentIsBold, this.currentSegmentIsItalic, this.currentSegmentIsMonospaced));
        }
        if (this.currentLine.length() > 0 || this.currentCharCount == 0) {
            PdfDocumentUtils.TextLineInfo lineInfo = new PdfDocumentUtils.TextLineInfo(this.currentLine.toString(), this.currentFontSize > 0.0f ? this.currentFontSize : 12.0f, this.currentIsBold, this.currentIsItalic, this.currentFontName, this.currentPageNumber);
            lineInfo.segments = new ArrayList<String>(this.currentSegments);
            lineInfo.xPositions = new ArrayList<Float>(this.currentXPositions);
            lineInfo.textSegments = new ArrayList<PdfDocumentUtils.TextSegment>(this.currentTextSegments);
            lineInfo.yPosition = this.currentYPosition;
            this.textLines.add(lineInfo);
        }
        this.resetState();
        super.writeLineSeparator();
    }

    private void resetState() {
        this.currentLine = new StringBuilder();
        this.currentFontSize = 0.0f;
        this.currentIsBold = false;
        this.currentIsItalic = false;
        this.currentFontName = "";
        this.currentCharCount = 0;
        this.currentXPositions = new ArrayList<Float>();
        this.currentSegments = new ArrayList<String>();
        this.currentTextSegments = new ArrayList<PdfDocumentUtils.TextSegment>();
        this.currentSegment = new StringBuilder();
        this.currentFormattedSegment = new StringBuilder();
        this.currentSegmentIsBold = false;
        this.currentSegmentIsItalic = false;
        this.currentSegmentIsMonospaced = false;
        this.lastXPosition = -1.0f;
        this.currentYPosition = 0.0f;
    }

    protected void startPage(PDPage page) throws IOException {
        this.currentPageNumber = this.getCurrentPageNo();
        super.startPage(page);
    }

    protected void endPage(PDPage page) throws IOException {
        if (this.currentLine.length() > 0) {
            if (this.currentSegment.length() > 0) {
                this.currentSegments.add(this.currentSegment.toString());
                this.currentXPositions.add(Float.valueOf(this.lastXPosition));
            }
            if (this.currentFormattedSegment.length() > 0) {
                this.currentTextSegments.add(new PdfDocumentUtils.TextSegment(this.currentFormattedSegment.toString(), this.currentSegmentIsBold, this.currentSegmentIsItalic, this.currentSegmentIsMonospaced));
            }
            PdfDocumentUtils.TextLineInfo lineInfo = new PdfDocumentUtils.TextLineInfo(this.currentLine.toString(), this.currentFontSize > 0.0f ? this.currentFontSize : 12.0f, this.currentIsBold, this.currentIsItalic, this.currentFontName, this.currentPageNumber);
            lineInfo.segments = new ArrayList<String>(this.currentSegments);
            lineInfo.xPositions = new ArrayList<Float>(this.currentXPositions);
            lineInfo.textSegments = new ArrayList<PdfDocumentUtils.TextSegment>(this.currentTextSegments);
            lineInfo.yPosition = this.currentYPosition;
            this.textLines.add(lineInfo);
            this.resetState();
        }
        super.endPage(page);
    }

    public List<PdfDocumentUtils.TextLineInfo> getTextLines() {
        return this.textLines;
    }
}

