/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach;

import com.oxygenxml.positron.core.util.attach.DocumentSplitFolderUtils;
import com.oxygenxml.positron.core.util.attach.OfficeDocumentUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;

public class WordSplitFolderManager {
    private static final String WORD_RELS_DOCUMENT_XML_RELS_PATH = "word/_rels/document.xml.rels";
    private static final String WORD_IMAGE_DIRS_PATH = "word/media/image";
    private static final String DEFAULT_SECTION_TITLE = "Content";
    private static final String[] SUPPORTED_IMAGE_EXTENSIONS;
    private static final Pattern IMAGE_MATCH_PATTERN;
    private static final Pattern LINK_MATCH_PATTERN;
    private static File splitParentFolder;

    private WordSplitFolderManager() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static File getOrCreateSplitFolder(String wordFilePath, byte[] wordBytes) throws IOException, TransformerException, NoSuchAlgorithmException, ParserConfigurationException, SAXException {
        String folderName = URLUtil.extractFileName((String)wordFilePath) + "-" + wordFilePath.hashCode();
        File splitFolder = new File(splitParentFolder, "oxygen-ai-word-splits/" + folderName);
        if (DocumentSplitFolderUtils.isFolderValid(splitFolder, wordBytes)) {
            return splitFolder;
        }
        splitFolder.mkdirs();
        splitFolder.deleteOnExit();
        File imagesDir = new File(splitFolder, "images");
        imagesDir.mkdir();
        imagesDir.deleteOnExit();
        WordSplitFolderManager.splitWordIntoFiles(wordFilePath, wordBytes, splitFolder, imagesDir);
        DocumentSplitFolderUtils.saveMetadata(splitFolder, wordBytes);
        return splitFolder;
    }

    private static void splitWordIntoFiles(String wordFilePath, byte[] wordBytes, File splitFolder, File imagesDir) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        Map<String, byte[]> zipEntries = OfficeDocumentUtils.readAllZipEntries(new ByteArrayInputStream(wordBytes));
        Map.Entry<String, byte[]> docXml = OfficeDocumentUtils.findDocumentXML(zipEntries);
        if (docXml == null) {
            throw new IOException("Could not find document.xml in Word file");
        }
        String text = OfficeDocumentUtils.extractTextFromDocxOrPPTxXML(docXml.getValue(), false);
        Map<String, String> imageMap = WordSplitFolderManager.extractImages(zipEntries, imagesDir);
        Map<String, String> relsMap = WordSplitFolderManager.parseRelationships(zipEntries, false);
        Map<String, String> hyperlinkMap = WordSplitFolderManager.parseRelationships(zipEntries, true);
        text = WordSplitFolderManager.replaceImageReferences(text, relsMap, imageMap);
        text = WordSplitFolderManager.replaceLinkReferences(text, hyperlinkMap);
        List<WordSection> sections = WordSplitFolderManager.splitTextIntoSections(text, imageMap);
        WordSplitFolderManager.handleSplitSections(splitFolder, sections);
        WordSplitFolderManager.createTableOfContentsFile(splitFolder, wordFilePath, sections, new ArrayList<String>(imageMap.values()));
    }

    private static void handleSplitSections(File splitFolder, List<WordSection> sections) throws IOException {
        int size = sections.size();
        for (int i = 0; i < size; ++i) {
            WordSection section = sections.get(i);
            String fileName = String.format("%s-%03d.md", DocumentSplitFolderUtils.sanitizeFilename(WordSplitFolderManager.cleanHtmlTags(section.title)), i + 1);
            File sectionFile = new File(splitFolder, fileName);
            sectionFile.deleteOnExit();
            StringBuilder content = new StringBuilder();
            content.append("# ").append(section.title).append("\n\n");
            content.append(section.content);
            Files.write(sectionFile.toPath(), content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private static Map<String, String> extractImages(Map<String, byte[]> zipEntries, File imagesDir) throws IOException {
        LinkedHashMap<String, String> imageMap = new LinkedHashMap<String, String>();
        HashMap<String, Integer> nameCounters = new HashMap<String, Integer>();
        for (Map.Entry<String, byte[]> entry : zipEntries.entrySet()) {
            String entryName = entry.getKey();
            String extension = URLUtil.getExtension((String)entryName);
            if (!OfficeDocumentUtils.isSupportedImageExtension(SUPPORTED_IMAGE_EXTENSIONS, extension)) continue;
            String originalFileName = URLUtil.extractFileName((String)entryName);
            String sanitizedFileName = WordSplitFolderManager.sanitizeImageFilename(originalFileName);
            String imageFileName = sanitizedFileName;
            if (nameCounters.containsKey(imageFileName)) {
                int counter = (Integer)nameCounters.get(imageFileName) + 1;
                nameCounters.put(imageFileName, counter);
                imageFileName = WordSplitFolderManager.addCounterToFileName(imageFileName, counter);
            } else {
                nameCounters.put(imageFileName, 1);
            }
            File imageFile = new File(imagesDir, imageFileName);
            imageFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(imageFile);){
                fos.write(entry.getValue());
            }
            imageMap.put(entryName, imageFileName);
        }
        return imageMap;
    }

    private static String addCounterToFileName(String imageFileName, int counter) {
        int lastDotIndex = ((String)imageFileName).lastIndexOf(46);
        if (lastDotIndex > 0) {
            String baseName = ((String)imageFileName).substring(0, lastDotIndex);
            String ext = ((String)imageFileName).substring(lastDotIndex);
            imageFileName = baseName + "_" + counter + ext;
        } else {
            imageFileName = (String)imageFileName + "_" + counter;
        }
        return imageFileName;
    }

    private static String sanitizeImageFilename(String filename) {
        if (filename == null || filename.isEmpty()) {
            return "image.png";
        }
        Object sanitized = filename.replaceAll("[<>:\"|?*\\\\]", "_");
        String extension = URLUtil.getExtension((String)sanitized);
        if (extension == null || extension.isEmpty()) {
            sanitized = (String)sanitized + ".png";
        }
        return sanitized;
    }

    private static Map<String, String> parseRelationships(Map<String, byte[]> zipEntries, boolean onlyLinks) throws IOException, ParserConfigurationException, SAXException {
        HashMap<String, String> relsMap = new HashMap<String, String>();
        byte[] relsBytes = zipEntries.get(WORD_RELS_DOCUMENT_XML_RELS_PATH);
        if (relsBytes == null) {
            for (Map.Entry<String, byte[]> entry : zipEntries.entrySet()) {
                String entryName = entry.getKey();
                if (!entryName.contains("_rels") || !entryName.endsWith(".rels") || !entryName.contains("document")) continue;
                relsBytes = entry.getValue();
                break;
            }
        }
        if (relsBytes != null) {
            return OfficeDocumentUtils.parseRelationships(relsBytes, !onlyLinks, onlyLinks);
        }
        return relsMap;
    }

    private static String replaceLinkReferences(String text, Map<String, String> hyperlinkMap) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        Matcher matcher = LINK_MATCH_PATTERN.matcher(text);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String linkText = matcher.group(1);
            String relationshipId = matcher.group(2);
            String url = hyperlinkMap.get(relationshipId);
            if (url != null) {
                matcher.appendReplacement(result, Matcher.quoteReplacement("[" + linkText + "](" + url + ")"));
                continue;
            }
            matcher.appendReplacement(result, matcher.group(0));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String replaceImageReferences(String text, Map<String, String> relsMap, Map<String, String> imageMap) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        Matcher matcher = IMAGE_MATCH_PATTERN.matcher(text);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String savedFilename;
            String relationshipId = matcher.group(1);
            String extension = matcher.group(2);
            Object zipEntryName = relsMap.get(relationshipId);
            if (zipEntryName == null) {
                zipEntryName = WORD_IMAGE_DIRS_PATH + relationshipId + "." + extension;
            }
            if ((savedFilename = imageMap.get(zipEntryName)) != null) {
                matcher.appendReplacement(result, Matcher.quoteReplacement("![Image](images/" + savedFilename + ")"));
                continue;
            }
            matcher.appendReplacement(result, matcher.group(0));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static List<WordSection> splitTextIntoSections(String text, Map<String, String> imageMap) {
        ArrayList<WordSection> sections = new ArrayList<WordSection>();
        if (text == null || text.trim().isEmpty()) {
            sections.add(new WordSection(DEFAULT_SECTION_TITLE, ""));
            return sections;
        }
        String[] lines = text.split("\n");
        StringBuilder currentContent = new StringBuilder();
        String currentTitle = "Introduction";
        boolean hasFoundFirstHeading = false;
        for (String line : lines) {
            String trimmed = line.trim();
            boolean isHeading = WordSplitFolderManager.isHeading(trimmed);
            if (isHeading && !trimmed.isEmpty()) {
                if (hasFoundFirstHeading && currentContent.length() > 0) {
                    sections.add(new WordSection(currentTitle, currentContent.toString().trim()));
                    currentContent = new StringBuilder();
                }
                currentTitle = trimmed.replaceAll("^#+\\s*", "");
                hasFoundFirstHeading = true;
                continue;
            }
            if (currentContent.length() > 0) {
                currentContent.append("\n");
            }
            currentContent.append(line);
        }
        if (currentContent.length() > 0 || !hasFoundFirstHeading) {
            sections.add(new WordSection(currentTitle, currentContent.toString().trim()));
        }
        if (sections.isEmpty()) {
            sections.add(new WordSection(DEFAULT_SECTION_TITLE, text));
        }
        return sections;
    }

    private static boolean isHeading(String trimmed) {
        return !trimmed.isEmpty() && trimmed.startsWith("#");
    }

    private static String cleanHtmlTags(String text) {
        if (text == null) {
            return "";
        }
        String cleaned = text.replaceAll("<a[^>]*>", "").replaceAll("</a>", "");
        cleaned = cleaned.replaceAll("<[^>]+>", "");
        cleaned = cleaned.trim().replaceAll("\\s+", " ");
        return cleaned;
    }

    private static void createTableOfContentsFile(File splitFolder, String wordFilePath, List<WordSection> sections, List<String> imageFiles) throws IOException {
        StringBuilder toc = new StringBuilder();
        toc.append("# Table of Contents\n\n");
        String displayName = "[Unknown]";
        if (wordFilePath != null && !wordFilePath.isEmpty() && ((displayName = URLUtil.extractFileName((String)wordFilePath)) == null || displayName.isEmpty())) {
            displayName = "[Unknown]";
        }
        toc.append("**Original Word Document:** `").append(displayName).append("`\n\n");
        toc.append("## Sections\n\n");
        for (int i = 0; i < sections.size(); ++i) {
            WordSection section = sections.get(i);
            String cleanTitle = WordSplitFolderManager.cleanHtmlTags(section.title);
            String fileName = String.format("%s-%03d.md", DocumentSplitFolderUtils.sanitizeFilename(cleanTitle), i + 1);
            toc.append(String.format("%d. [%s](%s)\n", i + 1, cleanTitle, fileName));
        }
        if (!imageFiles.isEmpty()) {
            toc.append("\n## Images\n\n");
            toc.append("The following images were extracted from the Word document:\n\n");
            for (String imageFile : imageFiles) {
                toc.append(String.format("- `%s/%s`\n", "images", imageFile));
            }
        }
        toc.append("\n## Instructions\n\n");
        toc.append("To process this Word document:\n\n");
        toc.append("1. Read the relevant section files using the `list_dir` and file reading tools\n");
        toc.append("2. Use `invoke_ai_agent` to process each section as needed\n");
        toc.append("3. Copy images from the `images/` directory to your documentation project as needed\n");
        File tocFile = new File(splitFolder, "table_of_contents.md");
        tocFile.deleteOnExit();
        Files.write(tocFile.toPath(), toc.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    static final void setSplitParentFolder(File splitParentFolder) {
        if (splitParentFolder == null) {
            splitParentFolder = FileSystemUtil.getOxygenTempDirectory();
        }
        WordSplitFolderManager.splitParentFolder = splitParentFolder;
    }

    static {
        ArrayList<String> supported = new ArrayList<String>(Arrays.asList(OfficeDocumentUtils.SUPPORTED_IMAGE_EXTENSIONS));
        supported.add("bmp");
        SUPPORTED_IMAGE_EXTENSIONS = supported.toArray(new String[0]);
        Object supportedExtensions = "";
        for (int i = 0; i < SUPPORTED_IMAGE_EXTENSIONS.length; ++i) {
            supportedExtensions = (String)supportedExtensions + SUPPORTED_IMAGE_EXTENSIONS[i];
            if (i >= SUPPORTED_IMAGE_EXTENSIONS.length - 1) continue;
            supportedExtensions = (String)supportedExtensions + "|";
        }
        IMAGE_MATCH_PATTERN = Pattern.compile("!\\[Image\\]\\(image-([^)]+)\\.(" + (String)supportedExtensions + ")\\)");
        LINK_MATCH_PATTERN = Pattern.compile("\\[([^\\]]+)\\]\\(link-([^)]+)\\)");
        splitParentFolder = FileSystemUtil.getOxygenTempDirectory();
    }

    private static class WordSection {
        private String title;
        private String content;

        WordSection(String title, String content) {
            this.title = title;
            this.content = content;
        }
    }
}

