/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach;

import com.oxygenxml.positron.api.connector.dto.ImageUrl;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlWithResolutionContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.util.attach.MessageAttachmentUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.sync.basic.util.URLUtil;

public class OfficeDocumentUtils {
    private static final Logger log = LoggerFactory.getLogger(OfficeDocumentUtils.class);
    public static final String[] SUPPORTED_IMAGE_EXTENSIONS = new String[]{"png", "jpg", "jpeg", "gif", "webp"};

    private OfficeDocumentUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static List<MessageContent> getDocxText(String filePath, byte[] fileBytes) throws IOException, TransformerFactoryConfigurationError, TransformerException, CannotComputeCompletionDetailsException {
        ArrayList<MessageContent> mcs = new ArrayList<MessageContent>();
        Map<String, byte[]> zipEntries = OfficeDocumentUtils.readAllZipEntries(new ByteArrayInputStream(fileBytes));
        Map.Entry<String, byte[]> documentXml = OfficeDocumentUtils.findDocumentXML(zipEntries);
        if (documentXml != null) {
            mcs.addAll(OfficeDocumentUtils.processDocxDocumentEntry(documentXml.getKey(), documentXml.getValue(), filePath, zipEntries));
        }
        return mcs;
    }

    private static List<MessageContent> processDocxDocumentEntry(String entryName, byte[] documentXmlBytes, String filePath, Map<String, byte[]> zipEntries) throws IOException, TransformerException, CannotComputeCompletionDetailsException {
        ArrayList<MessageContent> mcs = new ArrayList<MessageContent>();
        String fileName = URLUtil.extractFileName((String)entryName);
        String baseRoot = entryName.contains("/") ? entryName.substring(0, entryName.indexOf(47) + 1) : "";
        String relsPath = baseRoot + "_rels/" + fileName + ".rels";
        Map<Object, Object> relsMap = new HashMap();
        if (zipEntries.containsKey(relsPath)) {
            try {
                relsMap = OfficeDocumentUtils.parseRelationships(zipEntries.get(relsPath), false, false);
            }
            catch (Exception ex) {
                log.warn((Throwable)ex);
            }
        }
        String text = OfficeDocumentUtils.extractTextFromDocxOrPPTxXML(documentXmlBytes, true);
        Matcher attachMatcher = MessageAttachmentUtils.ATTACH_PATTERN.matcher(text);
        StringBuffer processedTextBuf = new StringBuffer();
        while (attachMatcher.find()) {
            String entryPath;
            String found;
            String inner = attachMatcher.group(1);
            Object replacementInner = inner;
            if (!inner.contains(":")) {
                String target = null;
                target = relsMap != null && relsMap.containsKey(inner) ? (String)relsMap.get(inner) : inner;
                if (target != null) {
                    String entryPath2 = OfficeDocumentUtils.normalizePath(baseRoot, target);
                    replacementInner = "jar:" + filePath + "!/" + entryPath2;
                }
            }
            if (((String)replacementInner).startsWith("jar:") && ((String)replacementInner).contains("!/") && (found = OfficeDocumentUtils.findBestEntryForJar(entryPath = ((String)replacementInner).substring(((String)replacementInner).indexOf("!/") + 2), baseRoot, zipEntries)) != null) {
                replacementInner = "jar:" + filePath + "!/" + found;
            }
            attachMatcher.appendReplacement(processedTextBuf, Matcher.quoteReplacement("${attach(" + (String)replacementInner + ")}"));
        }
        attachMatcher.appendTail(processedTextBuf);
        text = processedTextBuf.toString();
        List<MessageContent> inlined = OfficeDocumentUtils.inlineImagesFromZip(text, baseRoot, zipEntries);
        if (inlined != null && !inlined.isEmpty()) {
            return inlined;
        }
        mcs.addAll(OfficeDocumentUtils.expandTextWithMarkers(filePath, text));
        return mcs;
    }

    private static List<MessageContent> expandTextWithMarkers(String filePath, String text) throws CannotComputeCompletionDetailsException {
        String textWithMarkers = MessageAttachmentUtils.addFileURLMarkers(filePath, text);
        ArrayList<Message> tempMessages = new ArrayList<Message>();
        tempMessages.add(new Message(RoleType.USER, (MessageContent)new MessageTextContent(textWithMarkers)));
        List<Message> expandedMessages = MessageAttachmentUtils.expandAttachments(tempMessages, null, null);
        if (expandedMessages.size() == 1) {
            return expandedMessages.get(0).getContent();
        }
        ArrayList<MessageContent> fallback = new ArrayList<MessageContent>();
        fallback.add((MessageContent)new MessageTextContent(textWithMarkers));
        return fallback;
    }

    public static String extractTextFromDocxOrPPTxXML(byte[] documentXmlBytes, boolean expandImages) throws IOException, TransformerException {
        byte[] bytes = documentXmlBytes;
        StringWriter sw = new StringWriter();
        try (InputStream is = OfficeDocumentUtils.class.getResourceAsStream("/extract-docx-pptx-text.xsl");){
            StreamResult res = new StreamResult(sw);
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                // empty catch block
            }
            Transformer tr = factory.newTransformer(new StreamSource(is));
            tr.setParameter("expandImages", expandImages ? "true" : "false");
            StreamSource src = new StreamSource(new ByteArrayInputStream(bytes));
            tr.transform(src, res);
            sw.close();
        }
        return sw.toString();
    }

    public static Map.Entry<String, byte[]> findDocumentXML(Map<String, byte[]> zipEntries) {
        for (Map.Entry<String, byte[]> entry : zipEntries.entrySet()) {
            String entryName = entry.getKey();
            String fileName = URLUtil.extractFileName((String)entryName);
            if (!fileName.startsWith("document") || !fileName.endsWith(".xml") || !entryName.contains("word/")) continue;
            return entry;
        }
        return null;
    }

    private static byte[] readZipEntryBytes(ZipInputStream zis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read = zis.read(buffer, 0, buffer.length);
        while (read > -1) {
            baos.write(buffer, 0, read);
            read = zis.read(buffer, 0, buffer.length);
        }
        baos.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public static Map<String, byte[]> readAllZipEntries(InputStream is) throws IOException {
        LinkedHashMap<String, byte[]> zipEntries = new LinkedHashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry nextEntry = null;
            while ((nextEntry = zis.getNextEntry()) != null) {
                if (nextEntry.isDirectory()) continue;
                String entryName = nextEntry.getName();
                byte[] bytes = OfficeDocumentUtils.readZipEntryBytes(zis);
                zipEntries.put(entryName, bytes);
            }
        }
        return zipEntries;
    }

    public static List<MessageContent> getPPTxText(String filePath, byte[] fileBytes) throws IOException, TransformerFactoryConfigurationError, TransformerException {
        ArrayList<MessageContent> mcs = new ArrayList<MessageContent>();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(fileBytes));){
            ZipEntry nextEntry = null;
            while ((nextEntry = zis.getNextEntry()) != null) {
                String entryName = nextEntry.getName();
                String fileName = URLUtil.extractFileName((String)entryName);
                if (!fileName.startsWith("slide") || !fileName.endsWith(".xml") || fileName.contains("Layout") || fileName.contains("Master")) continue;
                byte[] slideBytes = OfficeDocumentUtils.readZipEntryBytes(zis);
                String text = OfficeDocumentUtils.extractTextFromDocxOrPPTxXML(slideBytes, false);
                mcs.add((MessageContent)new MessageTextContent(MessageAttachmentUtils.addFileURLMarkers(filePath, text)));
            }
        }
        return mcs;
    }

    public static Map<String, String> parseRelationships(byte[] relsBytes, boolean normalizeTargetPath, boolean onlyLinks) throws IOException, ParserConfigurationException, SAXException {
        HashMap<String, String> rels = new HashMap<String, String>();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(relsBytes);){
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(bais);
            NodeList relNodes = doc.getElementsByTagNameNS("http://schemas.openxmlformats.org/package/2006/relationships", "Relationship");
            for (int i = 0; i < relNodes.getLength(); ++i) {
                String type;
                Element rel = (Element)relNodes.item(i);
                String id = rel.getAttribute("Id");
                String target = rel.getAttribute("Target");
                if (id == null || id.isEmpty() || target == null || target.isEmpty() || onlyLinks && ((type = rel.getAttribute("Type")) == null || !type.contains("hyperlink"))) continue;
                if (normalizeTargetPath) {
                    rels.put(id, OfficeDocumentUtils.normalizePath("word/", target));
                    continue;
                }
                rels.put(id, target);
            }
        }
        return rels;
    }

    public static String normalizePath(String baseRoot, String target) {
        String base;
        if (target == null) {
            return "";
        }
        String string = base = baseRoot == null ? "" : baseRoot;
        while (target.startsWith("./")) {
            target = target.substring(2);
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (!base.isEmpty()) {
            for (String p : base.split("/")) {
                if (p == null || p.isEmpty()) continue;
                parts.add(p);
            }
        }
        for (String p : target.split("/")) {
            if (p == null || p.isEmpty()) continue;
            if (p.equals("..")) {
                if (parts.isEmpty()) continue;
                parts.remove(parts.size() - 1);
                continue;
            }
            if (p.equals(".")) continue;
            parts.add(p);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            sb.append((String)parts.get(i));
            if (i >= parts.size() - 1) continue;
            sb.append('/');
        }
        return sb.toString();
    }

    private static String findBestEntryForJar(String entryPath, String baseRoot, Map<String, byte[]> zipEntries) {
        ArrayList<Object> candidates = new ArrayList<Object>();
        candidates.add(entryPath);
        if (baseRoot != null && !baseRoot.isEmpty() && entryPath.startsWith(baseRoot)) {
            candidates.add(entryPath.substring(baseRoot.length()));
        }
        if (baseRoot != null && !baseRoot.isEmpty()) {
            candidates.add(baseRoot + entryPath);
        }
        String fileName = entryPath.contains("/") ? entryPath.substring(entryPath.lastIndexOf(47) + 1) : entryPath;
        candidates.add("media/" + fileName);
        for (String string : candidates) {
            if (!zipEntries.containsKey(string)) continue;
            return string;
        }
        return null;
    }

    public static boolean isSupportedImageExtension(String[] supportedExtensions, String extension) {
        if (extension == null) {
            return false;
        }
        String lowerExt = extension.toLowerCase();
        for (int i = 0; i < supportedExtensions.length; ++i) {
            if (!supportedExtensions[i].equals(lowerExt)) continue;
            return true;
        }
        return false;
    }

    private static List<MessageContent> inlineImagesFromZip(String text, String baseRoot, Map<String, byte[]> zipEntries) throws CannotComputeCompletionDetailsException {
        String tail;
        ArrayList<Object> result = new ArrayList<Object>();
        Matcher matcher = MessageAttachmentUtils.ATTACH_PATTERN.matcher(text);
        int lastEnd = 0;
        boolean foundAnyImage = false;
        boolean errorExpandingImageRef = false;
        while (matcher.find() && !errorExpandingImageRef) {
            block12: {
                String between;
                if (matcher.start() > lastEnd && (between = text.substring(lastEnd, matcher.start())) != null && !between.isEmpty()) {
                    result.add(new MessageTextContent(between));
                }
                String inner = matcher.group(1);
                String entryKey = null;
                try {
                    if (inner != null && inner.startsWith("jar:") && inner.contains("!/")) {
                        String entryPath = inner.substring(inner.indexOf("!/") + 2);
                        entryKey = OfficeDocumentUtils.findBestEntryForJar(entryPath, baseRoot, zipEntries);
                    } else {
                        entryKey = OfficeDocumentUtils.findBestEntryForJar(inner, baseRoot, zipEntries);
                    }
                }
                catch (Exception e) {
                    errorExpandingImageRef = true;
                    break;
                }
                if (entryKey == null) {
                    errorExpandingImageRef = true;
                    break;
                }
                byte[] entryBytes = zipEntries.get(entryKey);
                if (entryBytes == null) {
                    errorExpandingImageRef = true;
                    break;
                }
                String extension = URLUtil.getExtension((String)entryKey);
                if (OfficeDocumentUtils.isSupportedImageExtension(SUPPORTED_IMAGE_EXTENSIONS, extension)) {
                    try {
                        MessageAttachmentUtils.ImageDetails imageDetails = MessageAttachmentUtils.getImageDetails(entryKey, entryBytes);
                        result.add(new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution));
                        foundAnyImage = true;
                        break block12;
                    }
                    catch (IOException ioe) {
                        errorExpandingImageRef = true;
                        break;
                    }
                }
                errorExpandingImageRef = true;
                break;
            }
            lastEnd = matcher.end();
        }
        if (!errorExpandingImageRef && lastEnd < text.length() && (tail = text.substring(lastEnd)) != null && !tail.isEmpty()) {
            result.add(new MessageTextContent(tail));
        }
        return !errorExpandingImageRef && foundAnyImage ? result : null;
    }
}

