/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach;

import com.oxygenxml.positron.api.connector.dto.ImageUrl;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlWithResolutionContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.attach.ImageAttachmentsFilter;
import com.oxygenxml.positron.core.util.attach.ImageNotSupportedException;
import com.oxygenxml.positron.core.util.attach.InvalidAttachmentException;
import com.oxygenxml.positron.core.util.attach.OfficeDocumentUtils;
import com.oxygenxml.positron.core.util.attach.PrivateChatAttachmentContentResolver;
import com.oxygenxml.positron.core.util.attach.SelectionAttachmentUtil;
import com.oxygenxml.positron.core.util.attach.SessionIdSetter;
import com.oxygenxml.positron.core.util.attach.WordSplitFolderManager;
import com.oxygenxml.positron.core.util.attach.pdf.PdfDocumentUtils;
import com.oxygenxml.positron.core.util.attach.pdf.PdfSplitFolderManager;
import com.oxygenxml.positron.utilities.functions.CopyMoveRenamePathFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeAgentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.ListFilesFunctionSignature;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ChatFunctionRef;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.xml.encoding.EncodingDetector;

public class MessageAttachmentUtils {
    private static final String COULD_NOT_OBTAIN_IMAGE_CONTENT_FROM_URL = "Could not obtain image content from URL: ";
    public static final String ATTACH_EDITOR_VARIABLE_START = "${attach(";
    public static final Pattern ATTACH_PATTERN = Pattern.compile("\\$\\{attach\\((.*?)\\)\\}");
    private static final String[] SUPPORTED_IMAGE_TYPES = new String[]{"png", "jpg", "gif", "webp"};

    private MessageAttachmentUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static MessageImageUrlWithResolutionContent createImageAttachmentMessageContent(String src) throws IOException {
        return MessageAttachmentUtils.createImageAttachmentMessageContent(src, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageImageUrlWithResolutionContent createImageAttachmentMessageContent(String src, SessionIdSetter sessionIdSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver) throws IOException {
        ImageDetails imageDetails = null;
        if (MessageAttachmentUtils.isBase64OpenAIAcceptedImg(src)) {
            Pair<Integer, Integer> resolution = MessageAttachmentUtils.getImageResolutionFromBase64Representation(src);
            imageDetails = new ImageDetails(resolution, src);
            return new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution);
        } else if (localAttachmentsContentResolver != null && PrivateChatAttachmentContentResolver.isChatAttachment(src)) {
            byte[] content = localAttachmentsContentResolver.getContent(sessionIdSetter.getSessionId(), src);
            if (content == null) throw new IOException(COULD_NOT_OBTAIN_IMAGE_CONTENT_FROM_URL + URLUtil.clearUserInfo((String)src));
            imageDetails = MessageAttachmentUtils.getImageDetails(src, content);
            return new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution);
        } else {
            URL url = MessageAttachmentUtils.getUrlFromSrcValue(src);
            if (sessionIdSetter != null) {
                url = sessionIdSetter.setSessionId(url);
            }
            imageDetails = MessageAttachmentUtils.getImageDetails(url);
        }
        return new MessageImageUrlWithResolutionContent(new ImageUrl(imageDetails.base64Representation), imageDetails.resolution);
    }

    private static boolean isBase64OpenAIAcceptedImg(String s) {
        for (int i = 0; i < SUPPORTED_IMAGE_TYPES.length; ++i) {
            if (!s.startsWith("data:image/" + SUPPORTED_IMAGE_TYPES[i] + ";base64")) continue;
            return true;
        }
        return false;
    }

    private static boolean isBase64OpenAIAcceptedImgExtension(String extension) {
        for (int i = 0; i < SUPPORTED_IMAGE_TYPES.length; ++i) {
            if (!extension.equals(SUPPORTED_IMAGE_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    private static ImageDetails getImageDetails(URL url) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        URLConnection openConnection = url.openConnection();
        if (openConnection != null) {
            try (InputStream is = openConnection.getInputStream();){
                int n;
                byte[] byteChunk = new byte[1024];
                while ((n = is.read(byteChunk)) > 0) {
                    outputStream.write(byteChunk, 0, n);
                }
            }
        } else {
            throw new IOException(COULD_NOT_OBTAIN_IMAGE_CONTENT_FROM_URL + URLUtil.clearUserInfo((URL)url));
        }
        return MessageAttachmentUtils.getImageDetails(url.toExternalForm(), outputStream.toByteArray());
    }

    public static ImageDetails getImageDetails(String imageUrlAsString, byte[] imageAsByteArray) throws IOException {
        PluginWorkspace pw;
        String base64String = Base64.getEncoder().encodeToString(imageAsByteArray);
        String extension = URLUtil.getExtension((String)imageUrlAsString);
        if ("jpg".equals(extension)) {
            extension = "jpeg";
        }
        String imageType = "data:image/" + extension + ";base64,";
        String imgBase64Representation = imageType + base64String;
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageAsByteArray));
        if (img != null) {
            Pair imgResolution = new Pair((Object)img.getWidth(), (Object)img.getHeight());
            return new ImageDetails((Pair<Integer, Integer>)imgResolution, imgBase64Representation);
        }
        if (!MessageAttachmentUtils.isBase64OpenAIAcceptedImgExtension(extension) && (pw = PluginWorkspaceProvider.getPluginWorkspace()) != null && pw.getUtilAccess() != null) {
            try {
                if (pw.getUtilAccess().isSupportedImageURL(new URL(imageUrlAsString))) {
                    throw new ImageNotSupportedException("Large Language Model does not have vision support for image format \"" + extension + "\".");
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        throw new IOException(COULD_NOT_OBTAIN_IMAGE_CONTENT_FROM_URL + URLUtil.clearUserInfo((String)imageUrlAsString));
    }

    private static Pair<Integer, Integer> getImageResolutionFromBase64Representation(String base64Str) throws IOException {
        base64Str = base64Str.substring(base64Str.indexOf(44) + 1);
        byte[] imgBytes = Base64.getDecoder().decode(base64Str);
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(imgBytes));
        return new Pair((Object)img.getWidth(), (Object)img.getHeight());
    }

    public static URL getUrlFromSrcValue(String srcAttrVal) throws MalformedURLException {
        URL url;
        try {
            url = new URL(srcAttrVal);
        }
        catch (MalformedURLException e) {
            File file = new File(srcAttrVal);
            if (file.isAbsolute()) {
                url = URLUtil.correct((File)file);
            }
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            if (pluginWorkspace != null) {
                try {
                    WSEditor editor = pluginWorkspace.getCurrentEditorAccess(0);
                    if (editor == null) {
                        throw e;
                    }
                    URL editorLocation = editor.getEditorLocation();
                    url = new URL(editorLocation, file.toString());
                }
                catch (UnsupportedOperationException ex) {
                    throw e;
                }
            }
            throw e;
        }
        return url;
    }

    private static boolean hasUnreferencedSelectionAttachments(List<Message> messages) {
        for (Message message : messages) {
            List mcList = message.getContent();
            if (mcList == null) continue;
            for (MessageContent mc : mcList) {
                int attachmentsMarker;
                MessageTextContent mtc;
                String text;
                if (!(mc instanceof MessageTextContent) || (text = (mtc = (MessageTextContent)mc).getText()) == null || (attachmentsMarker = text.indexOf("#################attachments#################")) == -1) continue;
                String sub = text.substring(attachmentsMarker + "#################attachments#################".length());
                Matcher matcher = ATTACH_PATTERN.matcher(sub);
                while (matcher.find()) {
                    String filePath = matcher.group(1);
                    if (filePath.isEmpty() || !SelectionAttachmentUtil.isSelectionURL(filePath)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<Message> expandAttachments(List<Message> messages, AIActionDetails actionDetails) throws CannotComputeCompletionDetailsException {
        return MessageAttachmentUtils.expandAttachments(messages, null, null, actionDetails);
    }

    public static List<Message> expandAttachments(List<Message> messages, SessionIdSetter webAuthorSessionSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver) throws CannotComputeCompletionDetailsException {
        return MessageAttachmentUtils.expandAttachments(messages, webAuthorSessionSetter, localAttachmentsContentResolver, null);
    }

    public static List<Message> expandAttachments(List<Message> messages, SessionIdSetter webAuthorSessionSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver, AIActionDetails actionDetails) throws CannotComputeCompletionDetailsException {
        boolean splitPDFAndWordDocsInTempDir = MessageAttachmentUtils.shouldUsePdfWordSplitting(actionDetails);
        boolean hasUnreferencedSelectionAttachments = MessageAttachmentUtils.hasUnreferencedSelectionAttachments(messages);
        ArrayList<Message> expandedMessages = new ArrayList<Message>(messages.size());
        for (Message message : messages) {
            boolean messageExpanded = false;
            List mcList = message.getContent();
            if (mcList != null) {
                ArrayList<MessageContent> expandedList = new ArrayList<MessageContent>();
                for (int i = 0; i < mcList.size(); ++i) {
                    MessageContent mc = (MessageContent)mcList.get(i);
                    if (mc instanceof MessageTextContent) {
                        MessageTextContent mtc = (MessageTextContent)mc;
                        String text = mtc.getText();
                        boolean currentMessageModified = false;
                        if (text != null && text.contains(ATTACH_EDITOR_VARIABLE_START)) {
                            Matcher matcher = ATTACH_PATTERN.matcher(text);
                            while (matcher.find()) {
                                MessageAttachmentUtils.attachMessagePart(expandedList, matcher, webAuthorSessionSetter, localAttachmentsContentResolver, splitPDFAndWordDocsInTempDir, hasUnreferencedSelectionAttachments);
                            }
                            StringBuffer sb = new StringBuffer();
                            matcher.appendTail(sb);
                            text = sb.toString();
                            currentMessageModified = true;
                        }
                        if (currentMessageModified) {
                            if (!text.isEmpty()) {
                                expandedList.add((MessageContent)new MessageTextContent(text));
                            }
                            messageExpanded = true;
                            continue;
                        }
                        expandedList.add(mc);
                        continue;
                    }
                    expandedList.add(mc);
                }
                if (messageExpanded) {
                    message = new Message(message.getRole(), expandedList);
                }
            }
            expandedMessages.add(message);
        }
        return expandedMessages;
    }

    private static boolean shouldUsePdfWordSplitting(AIActionDetails actionDetails) {
        if (actionDetails == null) {
            return false;
        }
        Set<String> toolNames = MessageAttachmentUtils.extractToolNames(actionDetails);
        if (toolNames == null || toolNames.isEmpty()) {
            return false;
        }
        InvokeAgentFunctionSignature invokeAgentFunctionSignature = new InvokeAgentFunctionSignature();
        boolean hasInvokeAgent = toolNames.contains(invokeAgentFunctionSignature.getName()) && invokeAgentFunctionSignature.isEnabled();
        ListFilesFunctionSignature listFilesFunctionSignature = new ListFilesFunctionSignature();
        boolean hasListDir = toolNames.contains(listFilesFunctionSignature.getName()) && listFilesFunctionSignature.isEnabled();
        CopyMoveRenamePathFunctionSignature copyMoveRename = new CopyMoveRenamePathFunctionSignature();
        return hasInvokeAgent && hasListDir && copyMoveRename.isEnabled();
    }

    public static void checkAttachments(Collection<Message> messages, ImageAttachmentsFilter filter, SessionIdSetter webAuthorSessionIdSetter) throws InvalidAttachmentException {
        for (Message message : messages) {
            List mcList = message.getContent();
            if (mcList == null) continue;
            for (int i = 0; i < mcList.size(); ++i) {
                MessageContent mc = (MessageContent)mcList.get(i);
                if (!(mc instanceof MessageTextContent)) continue;
                MessageAttachmentUtils.checkAttachments(((MessageTextContent)mc).getText(), filter, webAuthorSessionIdSetter);
            }
        }
    }

    private static void checkAttachments(String messageText, ImageAttachmentsFilter filter, SessionIdSetter webAuthorSessionIdSetter) throws InvalidAttachmentException {
        if (messageText == null || !messageText.contains(ATTACH_EDITOR_VARIABLE_START)) {
            return;
        }
        Matcher matcher = ATTACH_PATTERN.matcher(messageText);
        while (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            matcher.appendReplacement(sb, "");
            String filePath = matcher.group(1);
            try {
                if (filePath.isEmpty() || MessageAttachmentUtils.isBase64OpenAIAcceptedImg(filePath)) continue;
                URL url = MessageAttachmentUtils.getUrlFromSrcValue(filePath);
                if (webAuthorSessionIdSetter != null) {
                    url = webAuthorSessionIdSetter.setSessionId(url);
                }
                filter.accept(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    private static void attachMessagePart(List<MessageContent> expandedList, Matcher matcher, SessionIdSetter sessionIdSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver, boolean splitPDFAndWordDocsInTempDir, boolean hasUnreferencedSelectionAttachments) throws CannotComputeCompletionDetailsException {
        String filePath;
        StringBuffer sb = new StringBuffer();
        matcher.appendReplacement(sb, "");
        String str = sb.toString();
        if (!str.isEmpty()) {
            str = str.replace("#################attachments#################", "");
            expandedList.add((MessageContent)new MessageTextContent(str));
        }
        if (!(filePath = matcher.group(1)).isEmpty()) {
            if (SelectionAttachmentUtil.isSelectionURL(filePath)) {
                MessageAttachmentUtils.expandSelectionAttachments(expandedList, sessionIdSetter, localAttachmentsContentResolver, filePath, hasUnreferencedSelectionAttachments);
            } else {
                MessageAttachmentUtils.expandNonSelectionAttachments(expandedList, sessionIdSetter, localAttachmentsContentResolver, filePath, splitPDFAndWordDocsInTempDir);
            }
        }
    }

    private static void expandSelectionAttachments(List<MessageContent> expandedList, SessionIdSetter sessionIdSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver, String filePath, boolean hasUnreferencedSelectionAttachments) throws CannotComputeCompletionDetailsException {
        String contentQueryParam = SelectionAttachmentUtil.getContentQueryParam(URLUtil.convertToURL((String)filePath));
        if (contentQueryParam != null) {
            Object text = hasUnreferencedSelectionAttachments ? "--initial selection start--" + contentQueryParam + "--initial-selection-end--" : contentQueryParam;
            MessageTextContent msgTextContent = new MessageTextContent((String)text);
            boolean contains = contentQueryParam.contains(ATTACH_EDITOR_VARIABLE_START);
            if (contains) {
                ArrayList<MessageTextContent> expanded = new ArrayList<MessageTextContent>(1);
                expanded.add(msgTextContent);
                Message mess = new Message();
                mess.setContent(expanded);
                ArrayList<Message> messages = new ArrayList<Message>(1);
                messages.add(mess);
                List<Message> messagesExpanded = MessageAttachmentUtils.expandAttachments(messages, sessionIdSetter, localAttachmentsContentResolver);
                expandedList.addAll(hasUnreferencedSelectionAttachments ? 0 : expandedList.size(), messagesExpanded.get(0).getContent());
            } else {
                expandedList.add(hasUnreferencedSelectionAttachments ? 0 : expandedList.size(), (MessageContent)msgTextContent);
            }
        }
    }

    private static void expandNonSelectionAttachments(List<MessageContent> expandedList, SessionIdSetter sessionIdSetter, PrivateChatAttachmentContentResolver localAttachmentsContentResolver, String filePath, boolean splitPDFAndWordDocsInTempDir) throws CannotComputeCompletionDetailsException {
        block16: {
            AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
            if (aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(URLUtil.convertToURL((String)filePath))) {
                String msg = MessageFormat.format(Translator.getInstance().getTranslation("Access_denied_to_File_is_not_AI_accessible"), URLUtil.filterPasswords((String)filePath));
                throw new CannotComputeCompletionDetailsException(msg);
            }
            try {
                expandedList.add((MessageContent)MessageAttachmentUtils.createImageAttachmentMessageContent(filePath, sessionIdSetter, localAttachmentsContentResolver));
            }
            catch (ImageNotSupportedException e) {
                throw new CannotComputeCompletionDetailsException(e.getMessage(), e);
            }
            catch (IOException e) {
                boolean noContentExtracted;
                boolean addedContent;
                block15: {
                    addedContent = false;
                    noContentExtracted = false;
                    try {
                        if (localAttachmentsContentResolver != null && PrivateChatAttachmentContentResolver.isChatAttachment(filePath)) {
                            byte[] content = localAttachmentsContentResolver.getContent(sessionIdSetter.getSessionId(), filePath);
                            if (content == null) break block15;
                            try {
                                List<MessageContent> messagesContent = MessageAttachmentUtils.getTextContent(filePath, splitPDFAndWordDocsInTempDir, content);
                                if (messagesContent != null && !messagesContent.isEmpty()) {
                                    expandedList.addAll(messagesContent);
                                    addedContent = true;
                                } else {
                                    noContentExtracted = true;
                                }
                                break block15;
                            }
                            catch (Throwable ex) {
                                if (e instanceof IOException) {
                                    throw e;
                                }
                                throw new IOException("Could not convert content to text: " + e.getMessage(), e);
                            }
                        }
                        List<MessageContent> messagesContent = MessageAttachmentUtils.getTextContent(filePath, sessionIdSetter, splitPDFAndWordDocsInTempDir);
                        if (messagesContent != null && !messagesContent.isEmpty()) {
                            expandedList.addAll(messagesContent);
                            addedContent = true;
                        } else {
                            noContentExtracted = true;
                        }
                    }
                    catch (IOException ex) {
                        e = ex;
                    }
                }
                if (addedContent) break block16;
                String message = (noContentExtracted ? "Could not extract content: " : "Cannot attach file: ") + URLUtil.filterPasswords((String)filePath);
                if (!noContentExtracted && e != null) {
                    message = message + "\nReason: " + e.getMessage();
                }
                throw new CannotComputeCompletionDetailsException(message, e);
            }
        }
    }

    public static List<MessageContent> getTextContent(String referenceAttrValue, SessionIdSetter sessionIdSetter) throws IOException {
        return MessageAttachmentUtils.getTextContent(referenceAttrValue, sessionIdSetter, false);
    }

    public static List<MessageContent> getTextContent(String referenceAttrValue, SessionIdSetter sessionIdSetter, boolean splitPDFAndWordDocsInTempDir) throws IOException {
        List<MessageContent> list;
        block11: {
            URL url = MessageAttachmentUtils.getUrlFromSrcValue(referenceAttrValue);
            if (sessionIdSetter != null) {
                url = sessionIdSetter.setSessionId(url);
            }
            URLConnection openConnection = url.openConnection();
            InputStream is = openConnection.getInputStream();
            try {
                byte[] content = IOUtil.readBytes((InputStream)is);
                list = MessageAttachmentUtils.getTextContent(url.toString(), splitPDFAndWordDocsInTempDir, content);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof CannotComputeCompletionDetailsException) {
                        throw new IOException(e.getMessage(), e);
                    }
                    throw new IOException("Could not convert content to text: " + e.getMessage(), e);
                }
            }
            is.close();
        }
        return list;
    }

    private static List<MessageContent> getTextContent(String filePath, boolean splitPDFAndWordDocsInTempDir, byte[] fileBytes) throws Exception {
        if (filePath.endsWith(".pdf")) {
            if (splitPDFAndWordDocsInTempDir) {
                return MessageAttachmentUtils.createPdfSplitFolderMessage(filePath, fileBytes);
            }
            return PdfDocumentUtils.getPDFText(filePath, fileBytes);
        }
        if (filePath.endsWith(".docx")) {
            if (splitPDFAndWordDocsInTempDir) {
                return MessageAttachmentUtils.createWordSplitFolderMessage(filePath, fileBytes);
            }
            return OfficeDocumentUtils.getDocxText(filePath, fileBytes);
        }
        if (filePath.endsWith(".pptx")) {
            return OfficeDocumentUtils.getPPTxText(filePath, fileBytes);
        }
        InputStreamReader reader = EncodingDetector.getInstance().createReader((InputStream)new ByteArrayInputStream(fileBytes), URLUtil.getDescription((String)filePath), null, "UTF-8", new ArrayList());
        if (reader == null) {
            throw new IOException("Cannot retrieve content for attached path: " + URLUtil.clearUserInfo((String)filePath));
        }
        ArrayList<MessageContent> messageContents = new ArrayList<MessageContent>(1);
        messageContents.add((MessageContent)new MessageTextContent(MessageAttachmentUtils.addFileURLMarkers(filePath, IOUtil.read((Reader)reader).toString())));
        return messageContents;
    }

    private static List<MessageContent> createPdfSplitFolderMessage(String pdfFilePath, byte[] pdfBytes) throws Exception {
        File splitFolder = PdfSplitFolderManager.getOrCreateSplitFolder(pdfFilePath, pdfBytes);
        ArrayList<MessageContent> messageContents = new ArrayList<MessageContent>(1);
        String message = MessageAttachmentUtils.getSplitWordPDFPrompt(pdfFilePath, splitFolder);
        messageContents.add((MessageContent)new MessageTextContent(message));
        return messageContents;
    }

    private static List<MessageContent> createWordSplitFolderMessage(String wordFilePath, byte[] wordBytes) throws Exception {
        File splitFolder = WordSplitFolderManager.getOrCreateSplitFolder(wordFilePath, wordBytes);
        ArrayList<MessageContent> messageContents = new ArrayList<MessageContent>(1);
        String message = MessageAttachmentUtils.getSplitWordPDFPrompt(wordFilePath, splitFolder);
        messageContents.add((MessageContent)new MessageTextContent(message));
        return messageContents;
    }

    private static String getSplitWordPDFPrompt(String filePath, File splitFolder) {
        StringBuilder message = new StringBuilder();
        message.append("\n--Inline attached document: \"").append(URLUtil.clearUserInfo((String)filePath)).append("\"\n");
        message.append("--split-folder-info-start--\n\n");
        message.append("The document has been split into manageable sections in a temporary folder for easier processing. Consider this temporary folder read-only. You can use the contents from the temporary folder to create content in the project folder.\n\n");
        message.append("**Split Folder Location:** `").append(splitFolder.getAbsolutePath()).append("`\n\n");
        message.append("**Instructions:**\n");
        message.append("1. Read the table of contents file: `").append(splitFolder.getAbsolutePath()).append("/").append("table_of_contents.md").append("`\n");
        message.append("2. Use the `list_dir` tool to explore the folder structure\n");
        message.append("3. Read individual section files from the split folder as needed. If instructed to convert them, direct the sub-agents that the content and structure (including image references) in the Markdown section files must be preserved and converted to similar structured in the target format.\n");
        message.append("4. Images are available in the `images/` directory - copy them to your documentation project as needed using the '" + new CopyMoveRenamePathFunctionSignature().getName() + "' tool\n\n");
        message.append("5. Use `invoke_ai_agent` to process different sections with specialized sub-agents\n");
        return message.toString();
    }

    public static String addFileURLMarkers(String url, String text) {
        if (url != null && !url.isEmpty()) {
            String attachURL;
            Object textWithMarkers = "";
            URL clearedUserInfo = URLUtil.clearUserInfo((String)url);
            String string = attachURL = clearedUserInfo != null ? clearedUserInfo.toExternalForm() : url;
            if (attachURL != null) {
                textWithMarkers = (String)textWithMarkers + "\n--Inline attached content URL: \"" + attachURL + "\"\n";
            }
            textWithMarkers = (String)textWithMarkers + "--inline-attached-content-start--\n";
            text = textWithMarkers = (String)textWithMarkers + "\n" + (String)text + "\n--inline-attached-content-end--\n";
        }
        return text;
    }

    public static String computeAttachmentEditorVariableText(URL url) {
        return ATTACH_EDITOR_VARIABLE_START + url.toExternalForm() + ")}";
    }

    public static Set<String> extractToolNames(AIActionDetails actionDetails) {
        if (actionDetails == null || actionDetails.getParameters() == null) {
            return null;
        }
        List functionRefs = actionDetails.getParameters().getFunctionRefs();
        if (functionRefs == null || functionRefs.isEmpty()) {
            return null;
        }
        HashSet<String> toolNames = new HashSet<String>(functionRefs.size());
        for (ChatFunctionRef ref : functionRefs) {
            if (ref == null || ref.getRef() == null) continue;
            toolNames.add(ref.getRef());
        }
        return toolNames.isEmpty() ? null : toolNames;
    }

    public static final class ImageDetails {
        public final Pair<Integer, Integer> resolution;
        public final String base64Representation;

        public ImageDetails(Pair<Integer, Integer> resolution, String base64Representation) {
            this.resolution = resolution;
            this.base64Representation = base64Representation;
        }
    }
}

