/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.attach.ExtensionAttachmentFilter;
import com.oxygenxml.positron.core.util.attach.ImageAttachmentsFilter;
import com.oxygenxml.positron.core.util.attach.ImageReaderAttachmentFilter;
import com.oxygenxml.positron.core.util.attach.InvalidAttachmentException;
import java.net.URL;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.util.UtilAccess;

public class ImageAttachmentsFilterImpl
implements ImageAttachmentsFilter {
    private ExtensionAttachmentFilter extensionAttachmentsFilter = new ExtensionAttachmentFilter();
    private ImageReaderAttachmentFilter readerAttachmentsFilter = new ImageReaderAttachmentFilter();

    @Override
    public void accept(URL resource) throws InvalidAttachmentException {
        if (resource != null) {
            UtilAccess utilAccess = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess();
            String extension = utilAccess.getExtension(resource);
            if (extension == null || extension.isEmpty() || ImageAttachmentsFilterImpl.isUnknownResource(resource, utilAccess)) {
                this.readerAttachmentsFilter.accept(resource);
            } else {
                this.extensionAttachmentsFilter.accept(resource);
            }
        } else {
            throw new InvalidAttachmentException(Translator.getInstance().getTranslation("Invalid_Attachment_Message"));
        }
    }

    private static boolean isUnknownResource(URL resource, UtilAccess utilAccess) {
        return !utilAccess.isSupportedImageURL(resource) && !utilAccess.isUnhandledBinaryResourceURL(resource) && utilAccess.getContentType(resource.toString()) == null;
    }
}

