/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util.attach;

import com.oxygenxml.positron.core.util.SecurityUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentSplitFolderUtils {
    private static final Logger log = LoggerFactory.getLogger(DocumentSplitFolderUtils.class);
    public static final String IMAGES_DIR = "images";
    public static final String TOC_FILE = "table_of_contents.md";
    public static final String METADATA_FILE = ".metadata";

    private DocumentSplitFolderUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean isFolderValid(File splitFolder, byte[] documentBytes) {
        File metadataFile = new File(splitFolder, METADATA_FILE);
        if (!metadataFile.exists()) {
            return false;
        }
        try {
            String storedMetadata = new String(Files.readAllBytes(metadataFile.toPath()), StandardCharsets.UTF_8);
            String currentHash = SecurityUtils.hash(documentBytes);
            String currentMetadata = "hash=" + currentHash;
            return storedMetadata.equals(currentMetadata);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.warn("Failed to validate folder metadata", (Throwable)e);
            return false;
        }
    }

    public static void saveMetadata(File splitFolder, byte[] documentBytes) throws IOException, NoSuchAlgorithmException {
        File metadataFile = new File(splitFolder, METADATA_FILE);
        metadataFile.delete();
        metadataFile.deleteOnExit();
        String hash = SecurityUtils.hash(documentBytes);
        String metadata = "hash=" + hash;
        Files.write(metadataFile.toPath(), metadata.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static String sanitizeFilename(String name) {
        if (name == null || name.isEmpty()) {
            return "untitled";
        }
        String sanitized = name.replaceAll("[^a-zA-Z0-9_\\-]", "_").toLowerCase();
        if (sanitized.length() > 50) {
            sanitized = sanitized.substring(0, 50);
        }
        if (sanitized.isEmpty()) {
            sanitized = "untitled";
        }
        return sanitized;
    }
}

