/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.utilities.functions.XMLRefactoringHelper;
import com.oxygenxml.positron.utilities.functions.XMLRefactoringHelperProvider;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class XMLRefactoringHelperProviderInstaller {
    private static final Logger log = LoggerFactory.getLogger(XMLRefactoringHelperProviderInstaller.class);

    public static void installXMLRefactoringHelperProvider() {
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw == null) {
            return;
        }
        try {
            Method xmlRefactorAccessMeth = pw.getClass().getMethod("getXMLRefactorUtilAccess", new Class[0]);
            final Object xmlRefactorAccess = xmlRefactorAccessMeth.invoke((Object)pw, new Object[0]);
            XMLRefactoringHelperProvider.setXMLRefactoringHelper((XMLRefactoringHelper)new XMLRefactoringHelper(){

                public String getXMLRefactorOperationParams(String operationId) {
                    try {
                        Method listParams = xmlRefactorAccess.getClass().getMethod("listOperationParameters", String.class);
                        return (String)listParams.invoke(xmlRefactorAccess, operationId);
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        return null;
                    }
                }

                public String getAllXMLRefactorOperationIDsAndDescriptions() {
                    try {
                        Method listOps = xmlRefactorAccess.getClass().getMethod("listAllAvailableOperations", new Class[0]);
                        return (String)listOps.invoke(xmlRefactorAccess, new Object[0]);
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        return null;
                    }
                }

                public void invokeXMLRefactorOperation(Iterator<URL> resourcesIterator, Function<URL, String> contentProvider, BiConsumer<URL, String> contentSaver, String operationID, Map<String, String> parameters) throws IOException {
                    try {
                        Class<?> problemsCollectorClass = Class.forName("ro.sync.exml.workspace.api.util.refactor.XMLRefactorProblemCollector");
                        ArrayList<DocumentPositionedInfo> problemsList = new ArrayList<DocumentPositionedInfo>();
                        Object problemsCollector = XMLRefactoringHelperProviderInstaller.createProblemsCollector(problemsCollectorClass, problemsList);
                        boolean[] contentSaved = new boolean[1];
                        Method invoker = xmlRefactorAccess.getClass().getMethod("refactorXMLResources", Iterator.class, Function.class, BiConsumer.class, String.class, Map.class, problemsCollectorClass);
                        invoker.invoke(xmlRefactorAccess, resourcesIterator, contentProvider, (t, u) -> {
                            contentSaver.accept((URL)t, (String)u);
                            contentSaved[0] = true;
                        }, operationID, parameters, problemsCollector);
                        XMLRefactoringHelperProviderInstaller.throwEncounteredProblems(problemsList, contentSaved);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        throw new IOException(e.getMessage(), e);
                    }
                }

                public void invokeXMLRefactorOperation(Iterator<URL> resourcesIterator, Function<URL, String> contentProvider, BiConsumer<URL, String> contentSaver, String xsltScript) throws IOException {
                    try {
                        Class<?> problemsCollectorClass = Class.forName("ro.sync.exml.workspace.api.util.refactor.XMLRefactorProblemCollector");
                        ArrayList<DocumentPositionedInfo> problemsList = new ArrayList<DocumentPositionedInfo>();
                        Object problemsCollector = XMLRefactoringHelperProviderInstaller.createProblemsCollector(problemsCollectorClass, problemsList);
                        boolean[] contentSaved = new boolean[1];
                        Method invoker = xmlRefactorAccess.getClass().getMethod("refactorXMLResources", Iterator.class, Function.class, BiConsumer.class, String.class, problemsCollectorClass);
                        invoker.invoke(xmlRefactorAccess, resourcesIterator, contentProvider, (t, u) -> {
                            contentSaver.accept((URL)t, (String)u);
                            contentSaved[0] = true;
                        }, xsltScript, problemsCollector);
                        XMLRefactoringHelperProviderInstaller.throwEncounteredProblems(problemsList, contentSaved);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                        throw new IOException(e.getMessage(), e);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void throwEncounteredProblems(List<DocumentPositionedInfo> problemsList, boolean[] contentSaved) throws IOException {
        if (!problemsList.isEmpty()) {
            log.error("Problems " + problemsList);
            if (!contentSaved[0]) {
                StringBuilder allErrors = new StringBuilder();
                for (DocumentPositionedInfo problem : problemsList) {
                    allErrors.append(problem.getMessage()).append("\n");
                }
                throw new IOException(allErrors.toString());
            }
        }
    }

    private static Object createProblemsCollector(Class<?> problemsCollectorClass, final List<DocumentPositionedInfo> problemsList) {
        return Proxy.newProxyInstance(XMLRefactoringHelperProviderInstaller.class.getClassLoader(), new Class[]{problemsCollectorClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                DocumentPositionedInfo[] problems = (DocumentPositionedInfo[])args[0];
                problemsList.addAll(Arrays.asList(problems));
                return null;
            }
        });
    }
}

