/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;

public class UserNotifierHelper {
    private static final Logger log = LoggerFactory.getLogger(UserNotifierHelper.class);
    private static final int[] NOTIFICATION_THRESHOLDS = new int[]{80, 95};
    public static final int NO_NOTIFICATION_STATUS = 0;

    private UserNotifierHelper() {
        throw new UnsupportedOperationException("Instantiation of this class is not allowed!");
    }

    public static int getCreditsUsageNotificationStatus(int totalCredits, int usedCredits, String previousStatus) {
        int previousStatusValue = 0;
        try {
            previousStatusValue = NumberParserUtil.parseInt((String)previousStatus);
        }
        catch (NumberFormatException e) {
            log.debug((Throwable)e);
        }
        int usedCreditsRatio = usedCredits * 100 / totalCredits;
        int toReturn = 0;
        if (previousStatusValue == 0 || usedCreditsRatio >= NOTIFICATION_THRESHOLDS[0]) {
            int lastThresholdIndex = NOTIFICATION_THRESHOLDS.length - 1;
            if (usedCreditsRatio >= NOTIFICATION_THRESHOLDS[lastThresholdIndex]) {
                toReturn = NOTIFICATION_THRESHOLDS[lastThresholdIndex];
            } else {
                for (int i = 0; i < lastThresholdIndex; ++i) {
                    if (usedCreditsRatio < NOTIFICATION_THRESHOLDS[i] || usedCreditsRatio >= NOTIFICATION_THRESHOLDS[i + 1]) continue;
                    toReturn = NOTIFICATION_THRESHOLDS[i];
                    break;
                }
            }
        }
        return toReturn;
    }
}

