/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;

public class TranslateActionsUtil {
    public static final String CATEGORY = "category.";
    public static final String DESCRIPTION_KEY = ".description";
    public static final String SHORTDESC_KEY = ".short.description";
    public static final String TITLE_KEY = ".title";

    public static void translate(AIActionDetails details) {
        Translator translationsProvider = Translator.getInstance();
        if (translationsProvider != null && details.getComputedType() != ActionType.PSEUDO && details.getId() != null && details.isVisibleInUI()) {
            if (details.getTitle() != null && translationsProvider.hasTranslation(details.getId() + TITLE_KEY)) {
                details.setTitle(translationsProvider.getTranslation(details.getId() + TITLE_KEY));
            }
            if (details.hasShortDescription() && translationsProvider.hasTranslation(details.getId() + SHORTDESC_KEY)) {
                details.setShortDescription(translationsProvider.getTranslation(details.getId() + SHORTDESC_KEY));
            }
            if (details.getDescription() != null && translationsProvider.hasTranslation(details.getId() + DESCRIPTION_KEY)) {
                details.setDescription(translationsProvider.getTranslation(details.getId() + DESCRIPTION_KEY));
            }
            if (details.getCategoryId() != null && translationsProvider.hasTranslation(CATEGORY + details.getCategoryId())) {
                details.setCategoryId(translationsProvider.getTranslation(CATEGORY + details.getCategoryId()));
            }
        }
    }
}

