/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.utilities.functions.parameters.ContentParams;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.xerces.util.XMLChar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.contenttypes.ContentTypeChecker;
import ro.sync.basic.xml.XmlFilteringUtil;
import ro.sync.document.TextUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.util.UtilAccess;

public class TextUtils {
    private static final String PI_END = "?>";
    private static final String PI_START = "<?";
    private static final String COMMENT_END = "-->";
    private static final String COMMENT_START = "<!--";
    private static final String CDATA_END_MARKER = "]]>";
    private static final String CDATA_START_MARKER = "<![CDATA[";
    private static final String MARKDOWN_CODEBLOCK_MARKER = "markdown";
    private static final Logger logger = LoggerFactory.getLogger((String)TextUtils.class.getName());
    private static final String CODEBLOCK_MD_SYNTAX = "```";
    private static final Pattern HEADER_PATTERN = Pattern.compile("^(\\s*)#");
    private static final Pattern OL_PATTERN = Pattern.compile("^(\\s*)(\\d*)(\\s*)\\.");
    private static final Pattern UL_PATTERN = Pattern.compile("^(\\s*)\\-");
    private static final Pattern BLOCK_QUOTE = Pattern.compile("^(\\s*)\\>");
    private static final Pattern BLOCK_SPACES_QUOTE = Pattern.compile("^ {4}");
    private static final List<String> POSSIBLE_MARKDOWN_SYMBOLS = Arrays.asList("`", "](", "![");
    private static final List<Pattern> POSSIBLE_MARKDOWN_PATTERNS = Arrays.asList(HEADER_PATTERN, OL_PATTERN, UL_PATTERN, BLOCK_QUOTE, BLOCK_SPACES_QUOTE);
    private static final Map<String, String> THINKING_TAG_MAPPINGS = new HashMap<String, String>();
    private static final int MAX_READ_CURRENT_FILE_CHARS = 51200;

    private TextUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String filterMessageStatusText(String message) {
        if (message == null) {
            message = "";
        }
        String text = TextUtil.getSomeTextConsideringWordBounds((String)message, (int)50);
        return TextUtil.normalizeAndCollapseWhitespace((String)text);
    }

    public static boolean isNullOrBlank(String text) {
        return text == null || text.isBlank();
    }

    public static String extractInsertionContentFromResponseForURL(String content, String url) {
        String contentType = TextUtils.getContentType(url);
        return TextUtils.extractInsertionContentFromResponse(content, contentType);
    }

    public static String getContentType(String url) {
        UtilAccess utilAccess;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        String contentType = null;
        if (pw != null && (utilAccess = pw.getUtilAccess()) != null) {
            contentType = utilAccess.getContentType(url);
        }
        return contentType;
    }

    public static String extractInsertionContentFromResponseForInserter(String content, ContentInserter contentInserter) {
        Optional optionalCT = Optional.ofNullable(contentInserter).flatMap(DocumentDetailsProvider::getContentType);
        String contentType = null;
        if (optionalCT.isPresent()) {
            contentType = (String)optionalCT.get();
        }
        return TextUtils.extractInsertionContentFromResponse(content, contentType);
    }

    public static String extractInsertionContentFromResponseForCurrentEditor(String content) {
        WSEditor currentEditor;
        String contentType = null;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null && (currentEditor = pw.getCurrentEditorAccess(0)) != null) {
            contentType = currentEditor.getContentType();
        }
        return TextUtils.extractInsertionContentFromResponse(content, contentType);
    }

    public static String extractInsertionContentFromResponse(String content, String editorContentType) {
        if (content != null) {
            content = TextUtils.removeThinkingInfo(content);
            content = TextUtils.unwrapMarkdownCodeBlocks(content, editorContentType);
            content = TextUtils.handleInvalidCharacters(content, editorContentType);
        }
        return content;
    }

    private static String unwrapMarkdownCodeBlocks(String originalContent, String editorContentType) {
        int lastMarkIndex;
        String extractedCode = "";
        boolean isMarkdownEditor = "text/markdown".equals(editorContentType);
        if (originalContent != null && (lastMarkIndex = originalContent.lastIndexOf(CODEBLOCK_MD_SYNTAX)) != -1) {
            int firstMarkIndex = -1;
            firstMarkIndex = isMarkdownEditor ? originalContent.lastIndexOf("```markdown", lastMarkIndex - CODEBLOCK_MD_SYNTAX.length()) : originalContent.lastIndexOf(CODEBLOCK_MD_SYNTAX, lastMarkIndex - CODEBLOCK_MD_SYNTAX.length());
            if (firstMarkIndex != -1) {
                int firstMarkEOLIndex = originalContent.indexOf(10, firstMarkIndex);
                firstMarkEOLIndex = firstMarkEOLIndex == -1 ? firstMarkIndex + CODEBLOCK_MD_SYNTAX.length() : ++firstMarkEOLIndex;
                if (firstMarkEOLIndex != -1 && firstMarkEOLIndex < lastMarkIndex) {
                    extractedCode = originalContent.substring(firstMarkEOLIndex, lastMarkIndex);
                }
            }
        }
        return extractedCode.length() == 0 ? originalContent : extractedCode;
    }

    private static String removeThinkingInfo(String content) {
        for (Map.Entry<String, String> tags : THINKING_TAG_MAPPINGS.entrySet()) {
            int tEndIndex;
            int tIndex = ((String)content).indexOf(tags.getKey());
            if (tIndex == -1 || (tEndIndex = ((String)content).indexOf(tags.getValue())) == -1 || tEndIndex <= tIndex) continue;
            content = ((String)content).substring(0, tIndex) + ((String)content).substring(tEndIndex + tags.getValue().length());
            content = ((String)content).trim();
        }
        return content;
    }

    private static boolean isSplittableChar(char ch, char[] nonSplittableChars) {
        if (nonSplittableChars == null) {
            return true;
        }
        for (int i = 0; i < nonSplittableChars.length; ++i) {
            if (ch != nonSplittableChars[i]) continue;
            return false;
        }
        return true;
    }

    public static String getSplittedText(String text, int maxColumnsNumber, char[] nonSplittableChars, boolean trimText) {
        if (text == null) {
            return null;
        }
        int current = 0;
        int lastSpaceOrNonAlphaIndex = -1;
        int lineIndex = 0;
        char lastSpaceOrNonAlpaha = '\u0000';
        if (trimText) {
            text = text.trim();
        }
        int len = text.length();
        StringBuilder buffer = new StringBuilder();
        while (current < len) {
            char ch = text.charAt(current);
            if (logger.isDebugEnabled()) {
                logger.debug("Char: {}", (Object)Character.valueOf(ch));
            }
            if (Character.isWhitespace(ch) || !Character.isLetterOrDigit(ch) && TextUtils.isSplittableChar(ch, nonSplittableChars)) {
                lastSpaceOrNonAlphaIndex = lineIndex;
                lastSpaceOrNonAlpaha = ch;
                if (logger.isDebugEnabled()) {
                    logger.debug("Storing the space index: {}", (Object)Character.valueOf(lastSpaceOrNonAlpaha));
                }
            }
            if (ch == '\n') {
                if (lineIndex > 0) {
                    lineIndex = -1;
                    lastSpaceOrNonAlphaIndex = -1;
                    if (current + 1 < len && text.charAt(current + 1) == '\r') {
                        ++current;
                    }
                    buffer.append(ch);
                }
            } else if (ch == '\r') {
                if (lineIndex > 0) {
                    lineIndex = -1;
                    lastSpaceOrNonAlphaIndex = -1;
                    if (current + 1 < len && text.charAt(current + 1) == '\n') {
                        ++current;
                    }
                    buffer.append('\n');
                }
            } else if (lineIndex == maxColumnsNumber - 1) {
                if (lastSpaceOrNonAlphaIndex == lineIndex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Last space at the end of a line.");
                    }
                    if (!Character.isWhitespace(lastSpaceOrNonAlpaha)) {
                        buffer.append(ch);
                    }
                    lineIndex = -1;
                    lastSpaceOrNonAlphaIndex = -1;
                    buffer.append('\n');
                } else if (lastSpaceOrNonAlphaIndex != -1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("The last space index: {}", (Object)lastSpaceOrNonAlphaIndex);
                    }
                    lineIndex = maxColumnsNumber - lastSpaceOrNonAlphaIndex - 1;
                    if (logger.isDebugEnabled()) {
                        logger.debug("The line index: {}", (Object)lineIndex);
                        logger.debug("The char at line index: {}", (Object)Character.valueOf(buffer.charAt(buffer.length() - lineIndex)));
                    }
                    lastSpaceOrNonAlphaIndex = -1;
                    if (Character.isWhitespace(lastSpaceOrNonAlpaha)) {
                        buffer.setCharAt(buffer.length() - lineIndex, '\n');
                    } else {
                        buffer.insert(buffer.length() - lineIndex, '\n');
                    }
                    buffer.append(ch);
                    --lineIndex;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No space in line.");
                    }
                    lineIndex = -1;
                    lastSpaceOrNonAlphaIndex = -1;
                    buffer.append(ch);
                    buffer.append('\n');
                }
            } else {
                buffer.append(ch);
            }
            ++lineIndex;
            if (logger.isDebugEnabled()) {
                logger.debug("LineIndex: {} Buf: {}", (Object)lineIndex, (Object)buffer);
            }
            ++current;
        }
        String lineSep = System.getProperty("line.separator");
        if (lineSep != null) {
            int sepIndex = buffer.indexOf("\n");
            while (sepIndex != -1) {
                buffer.replace(sepIndex, sepIndex + 1, lineSep);
                if (sepIndex + lineSep.length() >= buffer.length()) break;
                sepIndex = buffer.indexOf("\n", sepIndex + lineSep.length());
            }
        }
        return buffer.toString();
    }

    public static String removeMarkup(String text) {
        return text.replaceAll("\\<.*?\\>", "");
    }

    public static String getDetectedContentType(String text) {
        String detectedCT = null;
        String trimmedText = text.trim();
        if (trimmedText.startsWith("<")) {
            detectedCT = "text/html";
        } else if (trimmedText.startsWith("{") || trimmedText.startsWith("[")) {
            detectedCT = "text/json";
        } else {
            boolean possibleMD = false;
            if (POSSIBLE_MARKDOWN_SYMBOLS.stream().anyMatch(text::contains)) {
                possibleMD = true;
            } else {
                String[] lines;
                for (String line : lines = text.split("\n")) {
                    if (!POSSIBLE_MARKDOWN_PATTERNS.stream().anyMatch(pattern -> pattern.matcher(line).find())) continue;
                    possibleMD = true;
                    break;
                }
            }
            if (possibleMD) {
                detectedCT = "text/markdown";
            }
        }
        return detectedCT;
    }

    public static String addLineNumbering(String content, int startLine, LineRangeResult rangeResult) {
        if (content == null) {
            return null;
        }
        int lineCounter = startLine;
        StringBuilder contentWithLines = new StringBuilder(content.length());
        StringBuilder currentLine = new StringBuilder();
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            if (ch == '\n') {
                contentWithLines.append(lineCounter).append("\t").append(currentLine.toString()).append("\n");
                ++lineCounter;
                currentLine.setLength(0);
                continue;
            }
            currentLine.append(ch);
        }
        if (currentLine.length() > 0) {
            contentWithLines.append(lineCounter).append("\t").append(currentLine.toString());
        }
        if (rangeResult != null) {
            contentWithLines.insert(0, "#Line ranges: " + rangeResult.startLine + ":" + rangeResult.endLine + " of total: " + rangeResult.totalLines + "#\n");
        }
        return contentWithLines.toString();
    }

    public static String changeContentToFitLineRanges(ContentParams params, String content) {
        if (content != null) {
            int start = 1;
            int end = 0;
            LineRangeResult lineRanges = null;
            boolean largeFile = false;
            if (params != null) {
                boolean readEntireFile = params.read_entire_file;
                boolean bl = largeFile = readEntireFile && ((String)content).length() > 51200;
                if (largeFile) {
                    readEntireFile = false;
                    start = 1;
                    end = 200;
                } else if (readEntireFile) {
                    start = 1;
                    end = 0;
                } else {
                    if (params.start_line > 0) {
                        start = params.start_line;
                    }
                    end = params.end_line;
                }
                lineRanges = TextUtils.extractLineRange((String)content, start, end);
                content = lineRanges.content;
            }
            content = TextUtils.addLineNumbering((String)content, start, lineRanges);
            if (largeFile) {
                content = "#Document too large to be read entirely, returning a limited number of lines#\n" + (String)content;
            }
        }
        return content;
    }

    private static LineRangeResult extractLineRange(String content, int startLineOneIndexed, int endLineOneIndexed) {
        int totalLines = TextUtils.computeTotalLinesOfText(content);
        if (content == null || startLineOneIndexed < 1 || endLineOneIndexed < startLineOneIndexed) {
            String resultContent = content != null ? content : "";
            return new LineRangeResult(resultContent, content != null ? 1 : 0, content != null ? totalLines : 0, totalLines);
        }
        int length = content.length();
        if (length == 0) {
            return new LineRangeResult("", 0, 0, totalLines);
        }
        int startPos = TextUtils.findCurrentLineStart(content, startLineOneIndexed);
        if (startPos == -1) {
            return new LineRangeResult("", startLineOneIndexed, endLineOneIndexed, totalLines);
        }
        int endPos = TextUtils.computeEndPositionForLineRangeExtraction(content, startLineOneIndexed, endLineOneIndexed, startPos);
        return new LineRangeResult(content.substring(startPos, endPos), startLineOneIndexed, Math.min(endLineOneIndexed, totalLines), totalLines);
    }

    private static int computeEndPositionForLineRangeExtraction(String content, int startLineOneIndexed, int endLineOneIndexed, int startPos) {
        int currentLine = startLineOneIndexed;
        int endPos = startPos;
        int length = content.length();
        for (int i = startPos; i < length; ++i) {
            char ch = content.charAt(i);
            if (ch != '\n') continue;
            if (currentLine == endLineOneIndexed) {
                endPos = i + 1;
                break;
            }
            ++currentLine;
        }
        if (endPos == startPos || currentLine <= endLineOneIndexed && endPos == startPos) {
            endPos = length;
        }
        return endPos;
    }

    private static int findCurrentLineStart(String content, int startLineOneIndexed) {
        int length = content.length();
        int cl = 1;
        int startPos = -1;
        for (int i = 0; i < length; ++i) {
            if (cl == startLineOneIndexed) {
                startPos = i;
                break;
            }
            char ch = content.charAt(i);
            if (ch != '\n') continue;
            ++cl;
        }
        return startPos;
    }

    private static int computeTotalLinesOfText(String content) {
        int totalLines = 0;
        if (content != null) {
            int length = content.length();
            if (length == 0) {
                totalLines = 0;
            } else {
                totalLines = 1;
                for (int i = 0; i < length; ++i) {
                    if (content.charAt(i) != '\n') continue;
                    ++totalLines;
                }
            }
        }
        return totalLines;
    }

    public static String getContentAroundCaretInternal(Document document, int offset, int maxNumberOfChars, boolean includeCaret) throws BadLocationException {
        int caretPositionInContent;
        int documentSize = document.getLength();
        int halfWindow = maxNumberOfChars / 2;
        int startOffset = documentSize <= maxNumberOfChars ? 0 : (offset <= halfWindow ? 0 : (offset + halfWindow >= documentSize ? documentSize - maxNumberOfChars : offset - halfWindow));
        int length = Math.min(maxNumberOfChars, documentSize - startOffset);
        String content = document.getText(startOffset, length);
        if (includeCaret && (caretPositionInContent = offset - startOffset) >= 0 && caretPositionInContent <= content.length()) {
            content = new StringBuilder(content).insert(caretPositionInContent, "[CARET]").toString();
        }
        return content;
    }

    public static String trimMatchingPrefix(String suggestion, String currentLineText) {
        if (suggestion != null && currentLineText != null && !currentLineText.isBlank()) {
            String trimmedSuggestion = suggestion.trim();
            String trimmedCurrentLine = currentLineText.trim();
            for (int i = 0; i < trimmedCurrentLine.length(); ++i) {
                String suffix = trimmedCurrentLine.substring(i);
                if (!trimmedSuggestion.startsWith(suffix)) continue;
                String result = trimmedSuggestion.substring(suffix.length());
                return result;
            }
        }
        return suggestion;
    }

    public static String handleInvalidCharacters(String content, String editorContentType) {
        if (content != null && (ContentTypeChecker.isXMLContentType((String)editorContentType) || content.startsWith("<")) && ((content = XmlFilteringUtil.filterInvalidXMLChars((CharSequence)content, error -> {}).toString()).contains("&") || content.contains("< "))) {
            StringBuilder result = new StringBuilder();
            int length = content.length();
            int i = 0;
            while (i < length) {
                int commentEnd;
                if (i <= length - COMMENT_START.length() && content.substring(i, i + COMMENT_START.length()).equals(COMMENT_START)) {
                    commentEnd = content.indexOf(COMMENT_END, i + COMMENT_START.length());
                    if (commentEnd != -1) {
                        result.append(content.substring(i, commentEnd + COMMENT_END.length()));
                        i = commentEnd + COMMENT_END.length();
                        continue;
                    }
                    result.append(content.substring(i));
                    break;
                }
                if (i <= length - CDATA_START_MARKER.length() && content.substring(i, i + CDATA_START_MARKER.length()).equals(CDATA_START_MARKER)) {
                    int cdataEnd = content.indexOf(CDATA_END_MARKER, i + CDATA_START_MARKER.length());
                    if (cdataEnd != -1) {
                        result.append(content.substring(i, cdataEnd + CDATA_END_MARKER.length()));
                        i = cdataEnd + CDATA_END_MARKER.length();
                        continue;
                    }
                    result.append(content.substring(i));
                    break;
                }
                if (i <= length - PI_START.length() && content.substring(i, i + PI_START.length()).equals(PI_START)) {
                    commentEnd = content.indexOf(PI_END, i + PI_START.length());
                    if (commentEnd != -1) {
                        result.append(content.substring(i, commentEnd + PI_END.length()));
                        i = commentEnd + PI_END.length();
                        continue;
                    }
                    result.append(content.substring(i));
                    break;
                }
                char ch = content.charAt(i);
                if (ch == '&') {
                    result.append(TextUtils.isEntityReference(content, i) ? Character.valueOf(ch) : "&amp;");
                    ++i;
                    continue;
                }
                if (i < length - 1 && ch == '<' && content.charAt(i + 1) == ' ') {
                    result.append("&lt;");
                    result.append(" ");
                    i += 2;
                    continue;
                }
                result.append(ch);
                ++i;
            }
            content = result.toString();
        }
        return content;
    }

    private static boolean isEntityReference(String content, int ampersandPos) {
        int length = content.length();
        int pos = ampersandPos + 1;
        boolean isEntityRef = false;
        for (int i = pos; i < length; ++i) {
            char ch = content.charAt(i);
            if (XMLChar.isNameStart((int)ch) || XMLChar.isName((int)ch) || ch == '#') continue;
            if (ch == ';') {
                isEntityRef = true;
                break;
            }
            isEntityRef = false;
            break;
        }
        return isEntityRef;
    }

    static {
        THINKING_TAG_MAPPINGS.put("<think>", "</think>");
        THINKING_TAG_MAPPINGS.put("<thinking>", "</thinking>");
    }

    private static class LineRangeResult {
        private final String content;
        private final int startLine;
        private final int endLine;
        private final int totalLines;

        private LineRangeResult(String content, int startLine, int endLine, int totalLines) {
            this.content = content;
            this.startLine = startLine;
            this.endLine = endLine;
            this.totalLines = totalLines;
        }
    }
}

