/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.util.HrefInfoResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.css.StaticContent;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.css.URIContent;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.HrefInfo;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

public class StandaloneHrefInfoProvider
implements HrefInfoResolver {
    private static final Logger log = LoggerFactory.getLogger(StandaloneHrefInfoProvider.class);
    protected static final String[] FALLBACK_IMAGE_ATTR_NAMES = new String[]{"src", "url", "fileref", "href"};

    @Override
    public HrefInfo getHrefInformation(AuthorNode node, Function<AuthorNode, Styles> stylesProvider) {
        HrefInfo hi = DITAAccess.getHrefInformation((AuthorNode)node);
        if (hi == null && node instanceof AuthorElement) {
            AuthorElement elem = (AuthorElement)node;
            for (int i = 0; i < FALLBACK_IMAGE_ATTR_NAMES.length; ++i) {
                AttrValue refAttr = elem.getAttribute(FALLBACK_IMAGE_ATTR_NAMES[i]);
                if (refAttr == null) continue;
                URL refURL = StandaloneHrefInfoProvider.getRefURLFromStyles(stylesProvider, elem);
                String refValue = refAttr.getValue();
                try {
                    if (refURL == null) {
                        refURL = new URL(elem.getXMLBaseURL(), refValue);
                    }
                    hi = new HrefInfo(refURL, refValue, false, false);
                    break;
                }
                catch (MalformedURLException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return hi;
    }

    private static URL getRefURLFromStyles(Function<AuthorNode, Styles> stylesProvider, AuthorElement elem) {
        StaticContent[] content;
        Styles styles;
        URL refURL = null;
        if (stylesProvider != null && (styles = stylesProvider.apply((AuthorNode)elem)) != null && (content = styles.getMixedContent()) != null && content.length == 1 && content[0] instanceof URIContent) {
            try {
                refURL = ((URIContent)content[0]).getCatalogExpandedURL();
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e);
            }
        }
        return refURL;
    }
}

