/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;

public class SelectionUtil {
    public static String getCaretSelectioInfo(WSTextBasedEditorPage textEditorPage) {
        if (textEditorPage != null && SelectionUtil.hasLineColumnInfo(textEditorPage)) {
            if (textEditorPage.hasSelection()) {
                int selStart = textEditorPage.getSelectionStart();
                int startLine = SelectionUtil.getLineOfOffset(textEditorPage, selStart);
                int startColumn = SelectionUtil.getColumnOfOffset(textEditorPage, selStart);
                int selEnd = textEditorPage.getSelectionEnd();
                int endLine = SelectionUtil.getLineOfOffset(textEditorPage, selEnd);
                int endColumn = SelectionUtil.getColumnOfOffset(textEditorPage, selEnd);
                return "Editing context selection line:column range start " + startLine + ":" + startColumn + " end " + endLine + ":" + endColumn;
            }
            int caretOffset = textEditorPage.getCaretOffset();
            int line = SelectionUtil.getLineOfOffset(textEditorPage, caretOffset);
            int column = SelectionUtil.getColumnOfOffset(textEditorPage, caretOffset);
            return "Editing context caret line:column " + line + ":" + column;
        }
        return null;
    }

    private static boolean hasLineColumnInfo(WSTextBasedEditorPage editorPage) {
        try {
            return editorPage.getClass().getMethod("getLineOfOffset", Integer.TYPE) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int getLineOfOffset(WSTextBasedEditorPage editorPage, int offset) {
        try {
            return (Integer)editorPage.getClass().getMethod("getLineOfOffset", Integer.TYPE).invoke((Object)editorPage, offset);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int getColumnOfOffset(WSTextBasedEditorPage editorPage, int offset) {
        try {
            return (Integer)editorPage.getClass().getMethod("getColumnOfOffset", Integer.TYPE).invoke((Object)editorPage, offset);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

