/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class OxygenUtils {
    private static final Logger log = LoggerFactory.getLogger(OxygenUtils.class);
    private static final int MAJOR_VERSION_INDEX = 0;
    private static final int MINOR_VERSION_INDEX = 1;

    private OxygenUtils() {
    }

    public static int getCurrentMajorVersion() {
        return OxygenUtils.getVersionComponent(0);
    }

    public static int getCurrentMinorVersion() {
        return OxygenUtils.getVersionComponent(1);
    }

    private static int getVersionComponent(int componentIndex) {
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null && pw.getVersion() != null) {
            String version = pw.getVersion();
            try {
                String[] versionNumbers = version.split("\\.");
                if (componentIndex >= 0 && componentIndex < versionNumbers.length) {
                    return NumberParserUtil.parseInt((String)versionNumbers[componentIndex]);
                }
                log.error("Invalid version component index {} for version {}", (Object)componentIndex, (Object)version);
            }
            catch (NumberFormatException ex) {
                log.error("Could not extract current Oxygen version from " + version);
            }
        } else {
            log.error("No plugin workspace version info exists for " + pw);
        }
        return 0;
    }
}

