/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.plugin.Translator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.encoding.EncodingDetectorInterface;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.xml.encoding.EncodingDetector;

public class MCPUtil {
    public static boolean isRunningAsMCPServer() {
        return "true".equals(System.getenv("OXYGEN_RUN_AS_MCP_SERVER"));
    }

    public static boolean handleSaveContent(URL targetURL, String content) throws IOException {
        PluginWorkspace pluginWorkspace;
        if (MCPUtil.isPreviewChanges() && (pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace()) instanceof StandalonePluginWorkspace) {
            StandalonePluginWorkspace spw = (StandalonePluginWorkspace)pluginWorkspace;
            URL tempUrl = MCPUtil.saveToTempURL(targetURL, content);
            boolean changesAppliedDuringPreview = spw.openMergeApplication(Translator.getInstance().getTranslation("Changes"), null, true, Translator.getInstance().getTranslation("Current_diff"), targetURL, true, false, Translator.getInstance().getTranslation("Proposed_changes"), tempUrl, false, false, targetURL);
            if (!changesAppliedDuringPreview) {
                throw new IOException("Save changes preview canceled by end user.");
            }
        }
        return false;
    }

    public static String enrichSaveToolDescription(String description) {
        if (MCPUtil.isPreviewChanges()) {
            description = (String)description + "\nThis tool shows in the Oxygen XML application a GUI Preview changes dialog to the end user.\nThe end user can choose to apply all proposed changes or only part of the changes or to cancel the save operation.";
        }
        return description;
    }

    private static boolean isPreviewChanges() {
        return MCPUtil.isRunningAsMCPServer() && "true".equals(System.getenv("OXYGEN_MCP_SERVER_GUI_PREVIEW_FILE_CHANGES"));
    }

    private static URL saveToTempURL(URL targetURL, String content) throws IOException {
        File proposedTemp = File.createTempFile(URLUtil.removeExtension((String)URLUtil.extractFileName((URL)targetURL)), "." + URLUtil.getExtension((String)targetURL.toString()));
        proposedTemp.deleteOnExit();
        URL proposedChangesURL = URLUtil.correct((File)proposedTemp);
        EncodingDetectorInterface encodingDetector = EncodingDetector.getInstance();
        String javaEncoding = encodingDetector.getJavaEncoding((Reader)new StringReader(content), false, new ArrayList());
        OutputStream outputStreamFromURL = URLUtil.openOutputStream((URL)proposedChangesURL);
        try (OutputStreamWriter writerWithEncoding = new OutputStreamWriter(outputStreamFromURL, javaEncoding != null ? javaEncoding : StandardCharsets.UTF_8.name());){
            writerWithEncoding.write(content);
        }
        return proposedChangesURL;
    }
}

