/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonHelper.class);
    private final ObjectMapper mapper = AIRequestUtil.defaultObjectMapper();

    private JsonHelper() {
    }

    public static JsonHelper getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public String toJSON(Object value) {
        String toReturn = null;
        try {
            toReturn = this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return toReturn;
    }

    public <T> T toObject(String json, JavaType valueType) {
        Object toReturn = null;
        if (json != null && !json.isEmpty()) {
            try {
                toReturn = this.mapper.readValue(json, valueType);
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return (T)toReturn;
    }

    public <C extends Collection<?>, E> CollectionType constructCollectionType(Class<C> collectionType, Class<E> elementType) {
        return this.mapper.getTypeFactory().constructCollectionType(collectionType, elementType);
    }

    private static final class SingletonHelper {
        static final JsonHelper INSTANCE = new JsonHelper();

        private SingletonHelper() {
        }
    }
}

