/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.core.AIActionsProvider;
import com.oxygenxml.positron.core.AICompletionDetailsProviderFactory;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.util.AIApplicationInstaller;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelper;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;

public class InvokeActionHelperImpl
implements InvokeActionHelper {
    private static final Logger log = LoggerFactory.getLogger(InvokeActionHelperImpl.class);
    private AICompletionDetailsProviderFactory aiCompletionDetailsProviderFactory;
    private AIActionsProvider aiActionsProvider;
    private final ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();

    public String invokeAction(String actionID, String extraContext, String content, Map<String, Object> initialParams) throws IOException {
        try {
            return AIApplicationInstaller.invokeAI(this.aiCompletionDetailsProviderFactory, this.aiActionsProvider, this.computeInvocationParams(actionID, extraContext, content, initialParams));
        }
        catch (IOException e) {
            throw e;
        }
        catch (CannotComputeCompletionDetailsException | InvalidMessageException | CloneNotSupportedException | StoppedByUserException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private Object[] computeInvocationParams(String actionID, String extraPromptContext, String content, Map<String, Object> initialParams) throws JsonProcessingException {
        String messagesJSON = "[{\n    \"role\": \"user\",\n    \"content\": " + this.objectMapper.writeValueAsString((Object)content) + "\n  }]";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (initialParams != null) {
            params.putAll(initialParams);
        }
        if (extraPromptContext != null) {
            params.put("extraContextInfo", extraPromptContext);
        }
        return new Object[]{actionID, messagesJSON, params};
    }

    public Flow.Publisher<String> invokeActionIncremental(String actionID, String extraPromptContext, String content, Map<String, Object> params) throws IOException {
        try {
            Flowable<CompletionChunk> invokeAIIncremental = AIApplicationInstaller.invokeAIIncremental(this.aiCompletionDetailsProviderFactory, this.aiActionsProvider, this.computeInvocationParams(actionID, extraPromptContext, content, params));
            return FlowAdapters.toFlowPublisher((Publisher)invokeAIIncremental.mapOptional(chunk -> Optional.ofNullable(CompletionResponseUtil.getCompletion((CompletionResponse)chunk))));
        }
        catch (IOException e) {
            throw e;
        }
        catch (CannotComputeCompletionDetailsException | InvalidMessageException | CloneNotSupportedException | StoppedByUserException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String invokeAction(String actionID, List<Message> messages, Map<String, String> parameters) throws IOException {
        try {
            return AIApplicationInstaller.invokeAI(this.aiCompletionDetailsProviderFactory, this.aiActionsProvider, new Object[]{actionID, this.objectMapper.writeValueAsString(messages), parameters});
        }
        catch (CannotComputeCompletionDetailsException | InvalidMessageException | IOException | CloneNotSupportedException | StoppedByUserException e) {
            throw new IOException(e);
        }
    }

    public String getAllActionsIDsAndDescriptions(Map<String, Object> applicationParams) {
        String toReturn;
        block2: {
            toReturn = null;
            try {
                List<AIActionDetails> actions = this.aiCompletionDetailsProviderFactory.getAIActionDetails(applicationParams);
                toReturn = this.serializeActionDetails(actions);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return toReturn;
    }

    private String serializeActionDetails(List<AIActionDetails> actions) throws JsonProcessingException {
        LinkedHashMap<String, Object> actionIdsToDescriptions = new LinkedHashMap<String, Object>();
        String serialized = null;
        if (actions != null) {
            for (AIActionDetails aiActionDetails : actions) {
                if (!aiActionDetails.canBeInvokedByTools() || aiActionDetails.getId() == null || aiActionDetails.getTitle() == null || aiActionDetails.getDescription() == null) continue;
                Object description = aiActionDetails.getTitle();
                description = (String)description + " - " + aiActionDetails.getDescription();
                actionIdsToDescriptions.put(aiActionDetails.getId(), description);
            }
            serialized = AIRequestUtil.defaultObjectMapper().writeValueAsString(actionIdsToDescriptions);
        }
        return serialized;
    }

    public String getActionName(String actionID, Map<String, Object> params) {
        Optional<String> toRet = null;
        try {
            List<AIActionDetails> agents;
            List<AIActionDetails> actions = this.aiCompletionDetailsProviderFactory.getAIActionDetails(params);
            if (actions != null) {
                toRet = actions.stream().filter(action -> actionID.equals(action.getId())).findFirst().map(AIActionDetails::getTitle);
            }
            if ((toRet == null || toRet.isEmpty()) && (agents = this.aiCompletionDetailsProviderFactory.getAIAgentDetails(params)) != null) {
                toRet = agents.stream().filter(agent -> actionID.equals(agent.getId())).findFirst().map(AIActionDetails::getTitle);
            }
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
        }
        return toRet != null && toRet.isPresent() ? (String)toRet.get() : actionID;
    }

    public String invokeAgent(String agentId, String extraPromptContext, String content, Map<String, Object> params) throws IOException {
        return this.invokeAction(agentId, extraPromptContext, content, params);
    }

    public String getAllAgentIDsAndDescriptions(Map<String, Object> applicationParams) {
        String toReturn;
        block2: {
            toReturn = null;
            try {
                List<AIActionDetails> actions = this.aiCompletionDetailsProviderFactory.getAIAgentDetails(applicationParams);
                toReturn = this.serializeActionDetails(actions);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return toReturn;
    }

    public InvokeActionHelperImpl(AICompletionDetailsProviderFactory aiCompletionDetailsProviderFactory, AIActionsProvider aiActionsProvider) {
        this.aiCompletionDetailsProviderFactory = aiCompletionDetailsProviderFactory;
        this.aiActionsProvider = aiActionsProvider;
    }
}

