/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.AuthorContextInfo;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AuthorDocumentModel;
import com.oxygenxml.positron.core.util.AuthorDocumentModelCreator;
import com.oxygenxml.positron.core.util.HrefInfoResolver;
import com.oxygenxml.positron.core.util.StandaloneHrefInfoProvider;
import com.oxygenxml.positron.core.util.attach.ImageAttachmentsFilter;
import com.oxygenxml.positron.core.util.attach.InvalidAttachmentException;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;
import com.oxygenxml.positron.utilities.json.AdditionalInfo;
import com.oxygenxml.positron.utilities.json.InputContext;
import com.oxygenxml.positron.utilities.json.InputType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.HrefInfo;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class ContextExtractorUtil {
    private static final Logger log = LoggerFactory.getLogger(ContextExtractorUtil.class);
    private static final List<String> IMAGE_ELEMENT_NAMES = Arrays.asList("image", "img", "imagedata", "graphic", "imageinfo");
    private static final Pattern IMAGE_ELEMENT_PATTERN;
    private static final Pattern IMAGE_REF_ATTR_PATTERN;
    private static final String ATTACHMENT_VAR_TEMPLATE = "${attach(%s)}";
    private static final Translator I18N;

    private ContextExtractorUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static ContextInfo computeContext(AIActionDetails details, DocumentContentInteractor documentContentInteractor, ImageAttachmentsFilter attachmentsFilter, AuthorDocumentModelCreator authorDocumentControllerCreator, HrefInfoResolver hrefInfoResolver) throws CannotComputeCompletionDetailsException, BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo contextInfo = null;
        if (documentContentInteractor != null) {
            contextInfo = ContextExtractorUtil.getTextToProcessInternal(details, documentContentInteractor, attachmentsFilter, authorDocumentControllerCreator, hrefInfoResolver);
            ContextExtractorUtil.handleActionsThatRequireSelection(details, contextInfo);
        } else if (ActionType.SHOW_RESPONSE == details.getComputedType() && details.getInputType() == null) {
            contextInfo = ContextInfo.EMPTY_CONTEXT_INFO;
        } else {
            throw new CannotComputeCompletionDetailsException("Action only available when a document is open. Please open a document to use this feature.");
        }
        return contextInfo;
    }

    private static void handleActionsThatRequireSelection(AIActionDetails details, ContextInfo contextInfo) throws CannotComputeCompletionDetailsException {
        boolean isActionThatRequiresSelection = ContextExtractorUtil.isActionThatRequiresSelection(details);
        if (contextInfo.isEmpty() && isActionThatRequiresSelection) {
            throw new CannotComputeCompletionDetailsException("There is no selection in the editor. Please select text before invoking the action.");
        }
    }

    private static boolean isActionThatRequiresSelection(AIActionDetails details) {
        String actionId = details.getId();
        return details.getComputedType() != ActionType.CHAT_MODE && !"pseudoaction.copilot.rewrite.content.based.on.instructions".equals(actionId) && !"pseudoaction.ai.autocompletion.xslt".equals(actionId) && details.getComputedType() != ActionType.INSERT_SCHEMA_AWARE && details.getInputContext() != InputContext.NONE;
    }

    private static ContextInfo getTextToProcessInternal(AIActionDetails details, DocumentContentInteractor prefixExtractor, ImageAttachmentsFilter attachmentsFilter, AuthorDocumentModelCreator authorDocumentControllerCreator, HrefInfoResolver hrefInfoResolver) throws CannotComputeCompletionDetailsException, BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo toReturn = null;
        boolean obtainEntireTextIncludingMarkup = details.getInputType() == null || details.getInputType() != InputType.PLAIN_TEXT;
        ActionType actionType = details.getComputedType();
        if (ActionType.GENERATE_CONTENT_FROM_CONTEXT == actionType) {
            toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, details.getInputContext(), true);
            if (toReturn.isEmpty()) {
                try {
                    String usableContent = prefixExtractor.computePromptTextFromCaret(prefixExtractor.getCaretOffset());
                    toReturn = new ContextInfo(usableContent, prefixExtractor.getCaretOffset(), prefixExtractor.getCaretOffset());
                }
                catch (BadLocationException usableContent) {}
            }
        } else if (ActionType.INSERT_SUGGESTION_FOR_LEFT_CONTENT == actionType) {
            try {
                int maxNoOfChars = 6000 - details.getContextLength();
                toReturn = new ContextInfo(prefixExtractor.computeUserInputFromDocument(prefixExtractor.getCaretOffset(), maxNoOfChars), prefixExtractor.getCaretOffset(), prefixExtractor.getCaretOffset());
            }
            catch (BadLocationException e) {
                throw new CannotComputeCompletionDetailsException(e.getMessage(), e);
            }
        } else if (ActionType.REPLACE_SELECTION_BASED_ON_IMAGE_ANALYSIS == actionType) {
            toReturn = ContextExtractorUtil.getSelectedImageContextInfo(InputContext.SELECTION, prefixExtractor, attachmentsFilter, obtainEntireTextIncludingMarkup, authorDocumentControllerCreator, hrefInfoResolver);
        } else if (ActionType.GENERATE_DOCUMENTATION_DRAFT == actionType) {
            toReturn = prefixExtractor.getEntireDocumentContent(obtainEntireTextIncludingMarkup);
        } else if (ActionType.UPDATE_ENTIRE_DOCUMENT_BASED_ON_IMAGES == actionType) {
            toReturn = ContextExtractorUtil.newContextWithImageAttachmentsAsEditorVariables(InputContext.DOCUMENT, prefixExtractor, attachmentsFilter, authorDocumentControllerCreator, hrefInfoResolver);
        } else if (details.getComputedType() == ActionType.CHAT_MODE || "pseudoaction.copilot.rewrite.content.based.on.instructions".equals(details.getId())) {
            toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, details.getInputContext(), true);
        } else if (ActionType.SHOW_RESPONSE == actionType || ActionType.INSERT_SCHEMA_AWARE == actionType || ActionType.REPLACE_SELECTION == actionType) {
            toReturn = ContextExtractorUtil.getInputContentFromActionDetails(details, prefixExtractor);
            if (toReturn == null) {
                boolean obtainMarkupWithImages;
                InputContext inputContext = details.getInputContext();
                if (inputContext == null && ActionType.INSERT_SCHEMA_AWARE == actionType) {
                    inputContext = InputContext.AUTO_SELECTION_DOCUMENT;
                }
                boolean bl = obtainMarkupWithImages = details.getInputType() != null && details.getInputType() == InputType.MARKUP_WITH_IMAGES;
                toReturn = obtainMarkupWithImages ? ContextExtractorUtil.newContextWithImageAttachmentsAsEditorVariables(inputContext, prefixExtractor, attachmentsFilter, authorDocumentControllerCreator, hrefInfoResolver) : prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, inputContext, true);
            }
        } else {
            toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, details.getInputContext(), true);
        }
        return toReturn;
    }

    private static ContextInfo getSelectedImageContextInfo(InputContext inputContext, DocumentContentInteractor contentExtractor, ImageAttachmentsFilter attachmentsFilter, boolean obtainEntireTextIncludingMarkup, AuthorDocumentModelCreator authorDocModelCreator, HrefInfoResolver hrefInfoResolver) throws BadLocationException, CannotComputeCompletionDetailsException, OperationCancelledByAiIgnoreException {
        ContextInfo contextInfo = contentExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, inputContext, true);
        ContextInfo imageInfo = null;
        String originalUsableContent = contextInfo.getUsableContent();
        if (originalUsableContent != null && !originalUsableContent.isEmpty()) {
            try {
                AuthorDocumentModel documentModel;
                AuthorNode[] imageNodes;
                List<URL> authorImageRefs = ContextExtractorUtil.getImageReferencesFromAuthorPage(contextInfo, hrefInfoResolver);
                if (authorImageRefs != null && !authorImageRefs.isEmpty()) {
                    imageInfo = ContextExtractorUtil.computeImageContextInfo(contentExtractor, attachmentsFilter, contextInfo, originalUsableContent, authorImageRefs.get(0));
                }
                if (imageInfo == null && (imageNodes = ContextExtractorUtil.findAllImageElements((documentModel = authorDocModelCreator.createDocumentModel(contentExtractor.getEditorLocation(), new StringReader(originalUsableContent))).getDocumentController())) != null && imageNodes.length > 0 && imageNodes[0] instanceof AuthorNode) {
                    URL referenceURL;
                    HrefInfo hrefInformation = hrefInfoResolver.getHrefInformation(imageNodes[0], null);
                    URL uRL = referenceURL = hrefInformation != null ? hrefInformation.getReferenceURL() : null;
                    if (referenceURL != null) {
                        imageInfo = ContextExtractorUtil.computeImageContextInfo(contentExtractor, attachmentsFilter, contextInfo, originalUsableContent, referenceURL);
                    }
                }
            }
            catch (InvalidAttachmentException | AuthorOperationException e) {
                throw new CannotComputeCompletionDetailsException(e.getMessage(), (Exception)e);
            }
            catch (IOException e) {
                throw new CannotComputeCompletionDetailsException(I18N.getTranslation("Action_works_only_with_selected_image"), e);
            }
        }
        if (imageInfo == null) {
            throw new CannotComputeCompletionDetailsException(I18N.getTranslation("Action_works_only_with_selected_image"));
        }
        return imageInfo;
    }

    private static ContextInfo computeImageContextInfo(DocumentContentInteractor contentExtractor, ImageAttachmentsFilter attachmentsFilter, ContextInfo contextInfo, String originalUsableContent, URL imageURL) throws InvalidAttachmentException, BadLocationException {
        attachmentsFilter.accept(imageURL);
        String usableContent = contentExtractor.computeUserInputFromDocument(contentExtractor.getCaretOffset(), 500) + originalUsableContent + String.format(ATTACHMENT_VAR_TEMPLATE, attachmentsFilter.cleanSensitiveInfo(imageURL).toExternalForm());
        return new ContextInfo(usableContent, contextInfo.getStartOffset(), contextInfo.getEndOffset());
    }

    private static List<URL> getImageReferencesFromAuthorPage(ContextInfo contextInfo, HrefInfoResolver hrefInfoResolver) throws BadLocationException {
        ArrayList<URL> imageRefs = null;
        if (contextInfo instanceof AuthorContextInfo) {
            imageRefs = new ArrayList<URL>();
            AuthorContextInfo authorInfo = (AuthorContextInfo)contextInfo;
            List<AuthorNode> nodesInSelection = authorInfo.getNodesInSelection();
            Function<AuthorNode, Styles> stylesProvider = authorInfo.getStylesProvider();
            if (nodesInSelection != null) {
                ArrayList<AuthorNode> allImages = new ArrayList<AuthorNode>();
                ContextExtractorUtil.gatherAllImages(nodesInSelection, allImages);
                for (AuthorNode authorNode : allImages) {
                    HrefInfo hrefInformation = hrefInfoResolver.getHrefInformation(authorNode, stylesProvider);
                    URL referenceURL = hrefInformation != null ? hrefInformation.getReferenceURL() : null;
                    if (referenceURL == null) continue;
                    imageRefs.add(referenceURL);
                }
            }
        }
        return imageRefs;
    }

    private static void gatherAllImages(List<AuthorNode> nodes, List<AuthorNode> allImages) {
        if (nodes != null) {
            for (AuthorNode authorNode : nodes) {
                if (authorNode instanceof AuthorParentNode) {
                    ContextExtractorUtil.gatherAllImages(((AuthorParentNode)authorNode).getContentNodes(), allImages);
                }
                if (!(authorNode instanceof AuthorElement) || !IMAGE_ELEMENT_NAMES.contains(((AuthorElement)authorNode).getLocalName())) continue;
                allImages.add(authorNode);
            }
        }
    }

    private static ContextInfo getInputContentFromActionDetails(AIActionDetails details, DocumentContentInteractor prefixExtractor) throws BadLocationException, OperationCancelledByAiIgnoreException {
        String inputContentTypes;
        ContextInfo toReturn = null;
        AdditionalInfo additionalInfo = details.getAdditionalInfo();
        if (additionalInfo != null && (inputContentTypes = (String)additionalInfo.getProperties().get("input_content")) != null && !inputContentTypes.isEmpty()) {
            String[] inputTypes = inputContentTypes.split(",");
            boolean includeMarkup = details.getInputType() == null || details.getInputType() != InputType.PLAIN_TEXT;
            for (String inputType : inputTypes) {
                toReturn = ContextExtractorUtil.getInputContentFromInputType(prefixExtractor, includeMarkup, inputType);
                if (toReturn == null) continue;
                return toReturn;
            }
        }
        return toReturn;
    }

    private static ContextInfo getInputContentFromInputType(DocumentContentInteractor prefixExtractor, boolean obtainEntireTextIncludingMarkup, String inputType) throws BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo toReturn = null;
        if ("selection".equals(inputType.strip())) {
            if (prefixExtractor.hasSelection()) {
                toReturn = prefixExtractor.getCurrentContextInfo(obtainEntireTextIncludingMarkup, InputContext.SELECTION, true);
            }
        } else if ("node".equals(inputType.strip())) {
            toReturn = prefixExtractor.getCurrentNodeContent(obtainEntireTextIncludingMarkup);
        } else if ("document".equals(inputType.strip())) {
            toReturn = prefixExtractor.getEntireDocumentContent(obtainEntireTextIncludingMarkup);
        } else {
            log.error("Unknown input type: '{}' ", (Object)inputType);
        }
        return toReturn;
    }

    public static ContextInfo newContextWithImageAttachmentsAsEditorVariables(InputContext inputContext, DocumentContentInteractor contentExtractor, ImageAttachmentsFilter attachmentsFilter, AuthorDocumentModelCreator authorDocumentModelCreator, HrefInfoResolver hrefInfoResolver) throws BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo contextInfo;
        block5: {
            contextInfo = inputContext == InputContext.DOCUMENT ? contentExtractor.getEntireDocumentContent(true) : contentExtractor.getCurrentContextInfo(true, inputContext, true);
            String usableContent = contextInfo.getUsableContent();
            if (log.isDebugEnabled()) {
                log.debug("Initial context with referenced images " + contextInfo);
            }
            if (usableContent != null && !usableContent.isEmpty()) {
                List<URL> imageRefURLs = ContextExtractorUtil.getImageReferencesFromAuthorPage(contextInfo, hrefInfoResolver);
                try {
                    URL editorLocationURL = contentExtractor.getEditorLocation();
                    String updatedContent = ContextExtractorUtil.processImagesWithRegex(usableContent, imageRefURLs, editorLocationURL, attachmentsFilter);
                    contextInfo = new ContextInfo(updatedContent, contextInfo.getStartOffset(), contextInfo.getEndOffset());
                }
                catch (InvalidAttachmentException e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)e, (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Final context with referenced images expanded as attachments " + contextInfo);
        }
        return contextInfo;
    }

    static String processImagesWithRegex(String usableContent, List<URL> imageRefURLs, URL editorLocation, ImageAttachmentsFilter attachmentsFilter) throws InvalidAttachmentException {
        Matcher matcher = IMAGE_ELEMENT_PATTERN.matcher(usableContent);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        int imageIndex = 0;
        while (matcher.find()) {
            result.append(usableContent, lastEnd, matcher.start());
            String match = matcher.group(0);
            URL referenceURL = null;
            if (imageRefURLs != null && imageIndex < imageRefURLs.size()) {
                referenceURL = imageRefURLs.get(imageIndex);
            }
            if (referenceURL == null) {
                referenceURL = ContextExtractorUtil.extractURLFromAttributes(match, editorLocation);
            }
            if (referenceURL != null) {
                attachmentsFilter.accept(referenceURL);
                String attachmentVar = String.format(ATTACHMENT_VAR_TEMPLATE, attachmentsFilter.cleanSensitiveInfo(referenceURL).toExternalForm());
                result.append(match);
                result.append(attachmentVar);
                ++imageIndex;
            } else {
                result.append(match);
            }
            lastEnd = matcher.end();
        }
        result.append(usableContent, lastEnd, usableContent.length());
        return result.toString();
    }

    static URL extractURLFromAttributes(String elementString, URL baseURL) {
        Matcher attrMatcher = IMAGE_REF_ATTR_PATTERN.matcher(elementString);
        URL url = null;
        if (attrMatcher.find()) {
            String attrName = attrMatcher.group(1);
            String urlValue = attrMatcher.group(3);
            if (urlValue != null && !urlValue.isEmpty()) {
                try {
                    url = "keyref".equalsIgnoreCase(attrName) && baseURL != null ? DITAAccess.resolveKeyRef((URL)baseURL, (String)urlValue, (boolean)false) : (baseURL != null ? new URL(baseURL, urlValue) : new URL(urlValue));
                }
                catch (MalformedURLException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return url;
    }

    private static AuthorNode[] findAllImageElements(AuthorDocumentController ctrl) throws AuthorOperationException {
        StringBuilder xpathBuilder = new StringBuilder("//*[local-name() = [");
        int size = IMAGE_ELEMENT_NAMES.size();
        for (int i = 0; i < size; ++i) {
            xpathBuilder.append("\"").append(IMAGE_ELEMENT_NAMES.get(i)).append("\"");
            if (i >= size - 1) continue;
            xpathBuilder.append(",");
        }
        xpathBuilder.append("]]");
        return ctrl.findNodesByXPath(xpathBuilder.toString(), true, true, true);
    }

    public static String getContentOrAccessDeniedMessage(String editorLocation, Supplier<String> contentSupplier, boolean isCurrentEditedDocument) {
        return ContextExtractorUtil.getContentOrAccessDeniedMessage(editorLocation, contentSupplier, isCurrentEditedDocument, FunctionsAndRAGHelperProvider.getProjectRAGHelper());
    }

    public static String getContentOrAccessDeniedMessage(String editorLocation, Supplier<String> contentSupplier, boolean isCurrentEditedDocument, FunctionsAndRAGHelper projectHelper) {
        String toRet = null;
        try {
            if (editorLocation != null) {
                projectHelper.checkDocumentAccessPermissions(editorLocation, isCurrentEditedDocument, false);
            }
            toRet = contentSupplier.get();
        }
        catch (AccessDeniedException e) {
            toRet = e.getMessage();
        }
        return toRet;
    }

    public static String readDocumentContent(URL docURL) throws IOException {
        Reader reader;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null && pw.getUtilAccess() != null && (reader = pw.getUtilAccess().createReader(docURL, StandardCharsets.UTF_8.name())) != null) {
            return IOUtil.read((Reader)reader).toString();
        }
        return IOUtil.readURL((URL)docURL, (String)"UTF-8");
    }

    static {
        StringBuilder patternBuilder = new StringBuilder("<(?:(?:[^:>\\s]+:)?(");
        for (int i = 0; i < IMAGE_ELEMENT_NAMES.size(); ++i) {
            patternBuilder.append(Pattern.quote(IMAGE_ELEMENT_NAMES.get(i)));
            if (i >= IMAGE_ELEMENT_NAMES.size() - 1) continue;
            patternBuilder.append("|");
        }
        patternBuilder.append("))(?:(?:\\s+[^>]*?)?(?:/>|>))");
        IMAGE_ELEMENT_PATTERN = Pattern.compile(patternBuilder.toString(), 2);
        StringBuilder attrPatternBuilder = new StringBuilder("\\s+(");
        String[] fallbackAttrs = StandaloneHrefInfoProvider.FALLBACK_IMAGE_ATTR_NAMES;
        for (int i = 0; i < fallbackAttrs.length; ++i) {
            attrPatternBuilder.append(Pattern.quote(fallbackAttrs[i]));
            if (i >= fallbackAttrs.length - 1) continue;
            attrPatternBuilder.append("|");
        }
        attrPatternBuilder.append("|").append(Pattern.quote("keyref"));
        attrPatternBuilder.append(")\\s*=\\s*([\"'])(.*?)\\2");
        IMAGE_REF_ATTR_PATTERN = Pattern.compile(attrPatternBuilder.toString(), 2);
        I18N = Translator.getInstance();
    }
}

