/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.core.interactions.AuthorStylesProvider;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import ro.sync.ecss.css.CounterContent;
import ro.sync.ecss.css.LabelContent;
import ro.sync.ecss.css.StaticContent;
import ro.sync.ecss.css.StringContent;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.api.node.AuthorReferenceNode;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.PseudoElementDescriptor;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public class AuthorTextUtil {
    private AuthorDocumentController controller;
    private AuthorStylesProvider stylesProvider;

    public AuthorTextUtil(AuthorDocumentController controller, AuthorStylesProvider stylesProvider) {
        this.controller = controller;
        this.stylesProvider = stylesProvider;
    }

    public String getTextWithNewlinesBetweenBlocks(int startOffset, int endOffset) throws BadLocationException {
        StringBuilder sb = new StringBuilder();
        Segment seg = new Segment();
        for (int offset = startOffset; offset <= endOffset; ++offset) {
            this.controller.getChars(offset, 1, seg);
            char character = seg.charAt(0);
            if (character == '\u0000') {
                int offsetToSkipTo = this.treatSentinelWhenCollectingText(sb, offset);
                if (offsetToSkipTo == -1) continue;
                offset = offsetToSkipTo;
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    private int treatSentinelWhenCollectingText(StringBuilder sb, int offset) throws BadLocationException {
        int skipOffset = -1;
        OffsetInformation offsetInfo = this.controller.getContentInformationAtOffset(offset);
        if (offsetInfo.getPositionType() == 1) {
            AuthorNode nodeForStartSentinel = this.controller.getNodeAtOffset(offset + 1);
            if (nodeForStartSentinel != null) {
                if (this.isIgnored(nodeForStartSentinel)) {
                    skipOffset = nodeForStartSentinel.getEndOffset();
                } else if (nodeForStartSentinel.getType() == 0) {
                    this.treatNodeMixedContent(sb, nodeForStartSentinel);
                }
            }
        } else if (offsetInfo.getPositionType() == 2) {
            boolean textEndsWithNewline;
            AuthorNode nodeAtOffset = this.controller.getNodeAtOffset(offset);
            boolean isNonReferenceBlockElement = nodeAtOffset.getType() != 7 && !this.isInline(nodeAtOffset);
            boolean blockElemHasReferenceParent = nodeAtOffset.getParent() != null && nodeAtOffset.getParent().getType() == 7;
            boolean bl = textEndsWithNewline = sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n';
            if (isNonReferenceBlockElement && !blockElemHasReferenceParent && !textEndsWithNewline) {
                sb.append("\n");
            }
        }
        return skipOffset;
    }

    private void treatNodeMixedContent(StringBuilder sb, AuthorNode node) {
        Styles styles = this.stylesProvider.getStyles(node);
        if (styles.isListItem()) {
            sb.append(AuthorTextUtil.getCounterSymbol(styles.getListStyleType()));
        }
        if (node instanceof AuthorParentNode) {
            this.addBeforeStaticText(sb, node);
        }
        StaticContent[] mixedContent = styles.getMixedContent();
        boolean isLink = styles.getLinkURL() != null;
        boolean isEmpty = node.getStartOffset() == node.getEndOffset() - 1;
        for (int i = 0; i < mixedContent.length; ++i) {
            StaticContent staticContent = mixedContent[i];
            if (staticContent.getType() == 5) {
                boolean isNextSiblingAFormControl;
                LabelContent labelContent = (LabelContent)staticContent;
                String labelText = (String)labelContent.getProperties().get("text");
                if (labelText == null) continue;
                boolean bl = isNextSiblingAFormControl = i + 1 < mixedContent.length && mixedContent[i + 1].getType() == 4;
                if (isNextSiblingAFormControl) continue;
                sb.append(labelText);
                continue;
            }
            if (!isLink || !isEmpty || staticContent.getType() != 0) continue;
            StringContent stringContent = (StringContent)staticContent;
            sb.append(stringContent.getValue());
        }
    }

    private void addBeforeStaticText(StringBuilder sb, AuthorNode node) {
        Map<PseudoElementDescriptor, Styles> pseudoElementStyles = this.stylesProvider.getPseudoElementStyles((AuthorParentNode)node);
        if (pseudoElementStyles != null) {
            for (Map.Entry<PseudoElementDescriptor, Styles> entry : pseudoElementStyles.entrySet()) {
                PseudoElementDescriptor.PsuedoElementType type = entry.getKey().getType();
                if (type != PseudoElementDescriptor.PsuedoElementType.BEFORE && type != PseudoElementDescriptor.PsuedoElementType.MARKER || entry.getValue() == null) continue;
                AuthorTextUtil.computeBeforeAndMarkerStaticAncCounterText(sb, entry.getValue(), type);
            }
        }
    }

    private static void computeBeforeAndMarkerStaticAncCounterText(StringBuilder sb, Styles styles, PseudoElementDescriptor.PsuedoElementType type) {
        StaticContent[] mixedContent = styles.getMixedContent();
        if (mixedContent != null) {
            for (int i = 0; i < mixedContent.length; ++i) {
                StaticContent staticContent = mixedContent[i];
                if (type == PseudoElementDescriptor.PsuedoElementType.BEFORE && staticContent.getType() == 0) {
                    StringContent stringContent = (StringContent)staticContent;
                    sb.append(stringContent.getValue());
                    continue;
                }
                if (!(staticContent instanceof CounterContent)) continue;
                CounterContent counterContent = (CounterContent)staticContent;
                sb.append(AuthorTextUtil.getCounterSymbol(counterContent.getListStyleType()));
            }
        }
    }

    private static String getCounterSymbol(String listStyleType) {
        if ("none".equals(listStyleType)) {
            return "";
        }
        return "decimal".equals(listStyleType) ? " 1. " : " - ";
    }

    protected boolean isInline(AuthorNode node) {
        return this.stylesProvider.getStyles(node).isInline();
    }

    private boolean isIgnored(AuthorNode node) {
        Styles styles = this.stylesProvider.getStyles(node);
        return "none".equals(styles.getDisplay()) || styles.isFilteredOut();
    }

    public static boolean isSelectionOverUnresolvedConref(WSTextBasedEditorPage editorPage, int startOffset, int endOffset) throws BadLocationException {
        if (editorPage instanceof WSAuthorEditorPage) {
            WSAuthorEditorPage authorPage = (WSAuthorEditorPage)editorPage;
            AuthorNode commonParent = authorPage.getDocumentController().getCommonParentNode(authorPage.getDocumentController().getAuthorDocumentNode(), startOffset, endOffset);
            return AuthorTextUtil.selectionIsOverUnresolvedConref(commonParent, startOffset, endOffset);
        }
        return false;
    }

    private static boolean selectionIsOverUnresolvedConref(AuthorNode currentNode, int startOffset, int endOffset) {
        if (currentNode instanceof AuthorReferenceNode) {
            if (currentNode.getStartOffset() >= startOffset && currentNode.getEndOffset() <= endOffset && "#error".equals(currentNode.getName())) {
                return true;
            }
        } else if (currentNode instanceof AuthorParentNode) {
            AuthorParentNode parent = (AuthorParentNode)currentNode;
            List childNodes = parent.getContentNodes();
            for (AuthorNode authorNode : childNodes) {
                if (!AuthorTextUtil.selectionIsOverUnresolvedConref(authorNode, startOffset, endOffset)) continue;
                return true;
            }
        }
        return false;
    }
}

