/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.utilities.action.ActionsUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class AddonActionsUtil {
    private static final Logger log = LoggerFactory.getLogger(AddonActionsUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String EXCLUDE_ACTION_IDS_FILE = "excluded-action-ids.txt";

    public static List<URL> getExternalAIActionsDefinitionLocations() {
        List<URL> actionURLsList = new ArrayList<URL>();
        try {
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            Method getAIActionsProvider = pluginWorkspace.getClass().getMethod("getExternalAIActionsProvider", new Class[0]);
            Object aiActionsProvider = getAIActionsProvider.invoke((Object)pluginWorkspace, new Object[0]);
            Method getExternalActionLocations = aiActionsProvider.getClass().getMethod("getExternalAIActionsDefinitionLocations", new Class[0]);
            actionURLsList = (List)getExternalActionLocations.invoke(aiActionsProvider, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return actionURLsList;
    }

    private static Map<String, byte[]> getExternalResourcesMapping(Map<String, Object> context) {
        LinkedHashMap<String, byte[]> resourcesMap = new LinkedHashMap<String, byte[]>();
        try {
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            Method getConfigOptionsProvider = pluginWorkspace.getClass().getMethod("getConfigurationOptionsProvider", new Class[0]);
            Object configOptionsProvider = getConfigOptionsProvider.invoke((Object)pluginWorkspace, new Object[0]);
            Method getConfigResources = configOptionsProvider.getClass().getMethod("getConfigurationResources", String.class, Map.class);
            List resources = (List)getConfigResources.invoke(configOptionsProvider, "AIActions", context);
            if (resources != null) {
                AddonActionsUtil.gatherExternalResourceDefinitions(resources.iterator(), "", resourcesMap);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return resourcesMap;
    }

    private static void gatherExternalResourceDefinitions(Iterator configResourcesIter, String path, Map<String, byte[]> gatheredResourcesContent) throws Exception {
        while (configResourcesIter.hasNext()) {
            Object configResource = configResourcesIter.next();
            Class<?> clazz = configResource.getClass();
            Method isFolder = clazz.getMethod("isFolder", new Class[0]);
            isFolder.setAccessible(true);
            Method getName = clazz.getMethod("getName", new Class[0]);
            getName.setAccessible(true);
            String name = (String)getName.invoke(configResource, new Object[0]);
            if (((Boolean)isFolder.invoke(configResource, new Object[0])).booleanValue()) {
                Method listEntries = clazz.getMethod("listEntries", new Class[0]);
                listEntries.setAccessible(true);
                Iterator entries = (Iterator)listEntries.invoke(configResource, new Object[0]);
                if (entries == null) continue;
                AddonActionsUtil.gatherExternalResourceDefinitions(entries, path + name + "/", gatheredResourcesContent);
                continue;
            }
            if (!name.endsWith(".json") && !name.endsWith(".txt") && !name.endsWith(".md") && !name.endsWith(".markdown")) continue;
            Method getOs = clazz.getMethod("openStream", new Class[0]);
            getOs.setAccessible(true);
            InputStream is = (InputStream)getOs.invoke(configResource, new Object[0]);
            gatheredResourcesContent.put(path + name, IOUtil.readBytes((InputStream)is));
        }
    }

    private static List<String> getExternalAIActionIDsToExcludeFromPluginAPIs() {
        List<String> actionsToExcludeList = new ArrayList<String>();
        try {
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            Method getAIActionsProvider = pluginWorkspace.getClass().getMethod("getExternalAIActionsProvider", new Class[0]);
            Object aiActionsProvider = getAIActionsProvider.invoke((Object)pluginWorkspace, new Object[0]);
            Method getActionIDsToExclude = aiActionsProvider.getClass().getMethod("getActionIDsToExclude", new Class[0]);
            actionsToExcludeList = (List)getActionIDsToExclude.invoke(aiActionsProvider, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return actionsToExcludeList;
    }

    public static List<AIActionDetails> loadActionsUsingConfigOptionsProviderAPI(Map<String, Object> applicationContext) {
        ArrayList<AIActionDetails> actions = new ArrayList<AIActionDetails>();
        Map<String, byte[]> extraDefinitions = AddonActionsUtil.getExternalResourcesMapping(applicationContext);
        if (extraDefinitions != null && !extraDefinitions.isEmpty()) {
            JavaType type = OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{AIActionDetails.class});
            Set<Map.Entry<String, byte[]>> entrySet = extraDefinitions.entrySet();
            for (Map.Entry<String, byte[]> extraActionDefinition : entrySet) {
                Exception loadException = null;
                String path = extraActionDefinition.getKey();
                if (!path.endsWith(".json")) continue;
                ArrayList<AIActionDetails> newActions = new ArrayList<AIActionDetails>();
                try {
                    newActions.addAll((Collection)OBJECT_MAPPER.readValue(new String(extraActionDefinition.getValue(), "UTF-8"), type));
                }
                catch (Exception e) {
                    loadException = e;
                }
                if (loadException != null) {
                    try {
                        newActions.add((AIActionDetails)OBJECT_MAPPER.readValue(new String(extraActionDefinition.getValue(), "UTF-8"), AIActionDetails.class));
                    }
                    catch (Exception e) {
                        log.error(loadException.getMessage(), (Throwable)loadException);
                    }
                }
                ActionsUtil.expandPromptRef(newActions, (String)path, extraDefinitions);
                actions.addAll(newActions);
            }
        }
        return actions;
    }

    public static List<String> getExternalAIActionIDsToExclude(Map<String, Object> applicationContext) {
        List<String> extraActionsToExclude;
        ArrayList<String> actionIDs = new ArrayList<String>();
        Map<String, byte[]> extraDefinitions = AddonActionsUtil.getExternalResourcesMapping(applicationContext);
        if (extraDefinitions != null) {
            for (Map.Entry<String, byte[]> resourceDef : extraDefinitions.entrySet()) {
                String path = resourceDef.getKey();
                if ((path == null || !EXCLUDE_ACTION_IDS_FILE.equals(path)) && !path.endsWith("/excluded-action-ids.txt")) continue;
                try {
                    String[] excludedIDs = new String(resourceDef.getValue(), "UTF-8").split("\n");
                    if (excludedIDs == null) continue;
                    for (String excludedID : excludedIDs) {
                        if (excludedID.isEmpty()) continue;
                        actionIDs.add(excludedID);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((extraActionsToExclude = AddonActionsUtil.getExternalAIActionIDsToExcludeFromPluginAPIs()) != null) {
            actionIDs.addAll(extraActionsToExclude);
        }
        return actionIDs;
    }
}

