/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.google.common.collect.ImmutableSet;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;
import com.oxygenxml.positron.utilities.json.InputContext;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.application.ApplicationType;

public class ActionMatcherUtil {
    private static final String ACCEPT_ANY_STRING = ".*?";
    private static final Set<ActionType> ACTION_TYPES_FOR_NO_EDITOR_OPEN = ImmutableSet.of((Object)ActionType.CREATE_NEW_DOCUMENT_FROM_TEXT, (Object)ActionType.PROMPT_USER, (Object)ActionType.PSEUDO, (Object)ActionType.CHAT_MODE);
    private static ApplicationType appType;

    private static ApplicationType getApplicationType() {
        if (appType == null && PluginWorkspaceProvider.getPluginWorkspace() != null) {
            appType = PluginWorkspaceProvider.getPluginWorkspace().getApplicationType();
        }
        if (appType == null) {
            appType = ApplicationType.XML_EDITOR;
        }
        return appType;
    }

    public static boolean shouldAddAction(DocumentDetailsProvider docDetailsProvider, AIActionDetails actionDetails) {
        if (!ActionMatcherUtil.isActionAllowedInApplication(actionDetails.getProfile())) {
            return false;
        }
        String framework = actionDetails.getFramework();
        if (docDetailsProvider == null) {
            return ACTION_TYPES_FOR_NO_EDITOR_OPEN.contains(actionDetails.getComputedType()) || actionDetails.getInputContext() == InputContext.NONE && framework == null;
        }
        return ActionMatcherUtil.isNullOrEmpty(framework) || ActionMatcherUtil.isMatch(docDetailsProvider.getDocumentTypeName(), framework) || ActionMatcherUtil.isMatch(docDetailsProvider.getContentType(), framework);
    }

    public static boolean shouldAddAction(Optional<String> currentType, AIActionDetails currentActionDetails) {
        String curentFramework = null;
        String currentAllowedApplicationTypes = null;
        if (currentActionDetails != null) {
            curentFramework = currentActionDetails.getFramework();
            currentAllowedApplicationTypes = currentActionDetails.getProfile();
        }
        return ActionMatcherUtil.isActionAllowedInApplication(currentAllowedApplicationTypes) && ActionMatcherUtil.isMatch(currentType, curentFramework);
    }

    private static boolean isActionAllowedInApplication(String currentAllowedApplicationTypes) {
        return ActionMatcherUtil.matches(ActionMatcherUtil.getApplicationType().name(), currentAllowedApplicationTypes);
    }

    private static boolean isMatch(Optional<String> currentType, String actionFramework) {
        return currentType.isPresent() && ActionMatcherUtil.matches(currentType.get(), actionFramework);
    }

    private static boolean matches(String typeName, String pattern) {
        if (ActionMatcherUtil.isNullOrEmpty(pattern)) {
            return true;
        }
        if (typeName == null) {
            return false;
        }
        String regex = ActionMatcherUtil.createRegexFromPattern(pattern);
        Pattern compiledPattern = Pattern.compile(regex, 2);
        return compiledPattern.matcher(typeName).matches();
    }

    private static String createRegexFromPattern(String pattern) {
        return Arrays.stream(pattern.split(",")).map(String::trim).filter(t -> !t.isEmpty()).map(framework -> framework.replaceAll("\\*", ACCEPT_ANY_STRING)).collect(Collectors.joining("|"));
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.isBlank();
    }
}

