/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.credits.CreditsConverterUtil;
import com.oxygenxml.positron.utilities.json.Engine;
import com.oxygenxml.positron.utilities.models.CompletedModelDTO;
import com.oxygenxml.positron.utilities.models.ModelDTO;
import com.oxygenxml.positron.utilities.models.ModelLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public final class AIModelsUtil {
    private static final Logger log = LoggerFactory.getLogger(AIModelsUtil.class);
    private static final Translator TRANSLATOR = Translator.getInstance();

    private AIModelsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String getUILabelForModelID(String modelID) {
        return ModelLoader.getInstance().getModelNameToUI(modelID);
    }

    public static String getUILabelForModelSnapshotID(String snapshotModel) {
        return AIModelsUtil.getUILabelForModelID(AIModelsUtil.getModelShortName(snapshotModel));
    }

    public static String getAIModelFromOptions(String optionTag) {
        String currentModel;
        WSOptionsStorage options = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String returnedModel = currentModel = options.getOption(optionTag, null);
        boolean isSupportedModel = AIModelsUtil.getAllSupportedModelsForUI().stream().filter(t -> t.equalsIgnoreCase(currentModel)).findAny().isPresent();
        if (!isSupportedModel) {
            returnedModel = AIModelsUtil.getModelShortName(currentModel);
        }
        return returnedModel;
    }

    private static String getModelShortName(String currentModel) {
        String returnedModel = null;
        ModelLoader modelLoader = ModelLoader.getInstance();
        if (!TextUtils.isNullOrBlank(currentModel)) {
            ModelDTO modelDTOWithoutSnapshot = modelLoader.getBestMatchingModelDTO(currentModel);
            returnedModel = modelDTOWithoutSnapshot == null ? currentModel : modelDTOWithoutSnapshot.getModelID();
        }
        return returnedModel;
    }

    public static Map<String, List<ModelDescriptor>> getGroupedModelsForUI(List<ModelDTO> models, Engine defaultEngine, boolean includeDefault) {
        LinkedHashMap<String, List<ModelDescriptor>> groupedModels = new LinkedHashMap<String, List<ModelDescriptor>>();
        if (includeDefault) {
            groupedModels.put("<Default>", Arrays.asList(AIModelsUtil.createDefaultModelDescriptor(defaultEngine, true)));
        }
        String currentLanguage = AIModelsUtil.getCurrentLanguageCode();
        for (ModelDTO modelDTO : models) {
            if (!modelDTO.getShouldBeShownInUI().booleanValue() || modelDTO.getIsEnterpriseOnly() != null && modelDTO.getIsEnterpriseOnly().booleanValue()) continue;
            String modelId = modelDTO.getModelID();
            String label = AIModelsUtil.getUILabelForModelID(modelId);
            String description = AIModelsUtil.getDescriptionForModel(modelDTO, currentLanguage, true);
            groupedModels.computeIfAbsent(ModelLoader.getLabelForServiceId((String)modelDTO.getAiServiceID()), k -> new ArrayList()).add(new ModelDescriptor(modelId, label, description, modelDTO.getMaxTotalTokens(), modelDTO.getMaxOutputTokens(), modelDTO.isReasoningModel()));
        }
        return groupedModels;
    }

    private static String getDescriptionForModel(ModelDTO modelDTO, String languageCode, boolean includeCredits) {
        CompletedModelDTO completedModel;
        Map translations;
        if (modelDTO instanceof CompletedModelDTO && (translations = (completedModel = (CompletedModelDTO)modelDTO).getTranslatedDescriptions()) != null && !translations.isEmpty()) {
            String translatedDescription = (String)translations.get(languageCode);
            if (translatedDescription == null && !"en".equals(languageCode)) {
                translatedDescription = (String)translations.get("en");
                log.debug("Translation for language '{}' not found for model '{}', falling back to English", (Object)languageCode, (Object)modelDTO.getModelID());
            }
            if (translatedDescription != null) {
                log.debug("Using server-provided translation for model '{}' in language '{}'", (Object)modelDTO.getModelID(), (Object)languageCode);
                if (includeCredits) {
                    return translatedDescription + "\n\n" + AIModelsUtil.getCreditsInfo(modelDTO);
                }
                return translatedDescription;
            }
        }
        log.debug("Using local translation lookup for model '{}'", (Object)modelDTO.getModelID());
        return AIModelsUtil.getModelExplanation(modelDTO.getModelID(), includeCredits);
    }

    private static String getCurrentLanguageCode() {
        try {
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            if (language != null && !language.isEmpty()) {
                log.debug("Using language code '{}' from system locale '{}'", (Object)language, (Object)locale);
                return language;
            }
        }
        catch (Exception e) {
            log.warn("Failed to get current locale, defaulting to 'en'", (Throwable)e);
        }
        return "en";
    }

    public static List<ModelDTO> filterModelsForUI(List<ModelDTO> models) {
        return models.stream().filter(modelDTO -> modelDTO.getShouldBeShownInUI() != false && (modelDTO.getIsEnterpriseOnly() == null || modelDTO.getIsEnterpriseOnly() == false)).collect(Collectors.toList());
    }

    private static List<String> getAllSupportedModelsForUI() {
        ModelLoader loader = ModelLoader.getInstance();
        ArrayList<String> supportedOptionsModels = new ArrayList<String>();
        List loadedModels = loader.getLoadedModels();
        List collectedModels = loadedModels.stream().filter(ModelDTO::getShouldBeShownInUI).map(ModelDTO::getModelID).collect(Collectors.toList());
        supportedOptionsModels.addAll(collectedModels);
        return supportedOptionsModels;
    }

    public static List<ModelDescriptor> getSupportedOpenAIConnectorModelsForUI(Engine defaultModel) {
        ArrayList<ModelDescriptor> supportedOptionsModels = new ArrayList<ModelDescriptor>();
        supportedOptionsModels.add(AIModelsUtil.createDefaultModelDescriptor(defaultModel, false));
        String currentLanguage = AIModelsUtil.getCurrentLanguageCode();
        List loadedModels = ModelLoader.getInstance().getLoadedModels();
        List collectedModels = loadedModels.stream().filter(ModelDTO::getShouldBeShownInUI).filter(m -> "openai".equals(m.getAiServiceID())).map(m -> new ModelDescriptor(m.getModelID(), AIModelsUtil.getUILabelForModelID(m.getModelID()), AIModelsUtil.getDescriptionForModel(m, currentLanguage, false), m.getMaxTotalTokens(), m.getMaxOutputTokens(), m.isReasoningModel())).collect(Collectors.toList());
        supportedOptionsModels.addAll(collectedModels);
        return supportedOptionsModels;
    }

    private static ModelDescriptor createDefaultModelDescriptor(Engine defaultEngine, boolean includeCreditsInfo) {
        ModelDTO defaultModelDTO = ModelLoader.getInstance().getModelDTOById(defaultEngine.getId());
        boolean isReasoning = defaultModelDTO != null && defaultModelDTO.isReasoningModel();
        Integer contextWindow = defaultModelDTO != null ? defaultModelDTO.getMaxTotalTokens() : null;
        Integer maxOutputTokens = defaultModelDTO != null ? defaultModelDTO.getMaxOutputTokens() : null;
        return new ModelDescriptor(defaultEngine.getId(), AIModelsUtil.getUILabelForModelID(defaultEngine.getId()) + " (" + Translator.getInstance().getTranslation("default") + ")", AIModelsUtil.getModelExplanation(defaultEngine.getId(), includeCreditsInfo) + "\n\n" + AIModelsUtil.getDefaultEngineExtraExplanation(defaultEngine), contextWindow, maxOutputTokens, isReasoning);
    }

    public static List<ModelDescriptor> getSupportedNonOpenAIConnectorModelsForUI(String aiProvider) {
        String currentLanguage = AIModelsUtil.getCurrentLanguageCode();
        List loadedModels = ModelLoader.getInstance().getLoadedModels();
        List collectedModels = loadedModels.stream().filter(ModelDTO::getShouldBeShownInUI).filter(m -> aiProvider.equals(m.getAiServiceID())).map(m -> new ModelDescriptor(m.getModelID(), AIModelsUtil.getUILabelForModelID(m.getModelID()), AIModelsUtil.getDescriptionForModel(m, currentLanguage, false), m.getMaxTotalTokens(), m.getMaxOutputTokens(), m.isReasoningModel())).collect(Collectors.toList());
        return new ArrayList<ModelDescriptor>(collectedModels);
    }

    private static Optional<String> getEngineExplanation(String modelToSearch, boolean includeCredits) {
        ModelLoader loader = ModelLoader.getInstance();
        Optional<Object> result = Optional.empty();
        ModelDTO model = loader.getModelDTOById(modelToSearch);
        if (model != null) {
            String baseDescription = TRANSLATOR.getTranslation(model.getModelDescription());
            String creditsInfo = includeCredits ? "\n\n" + AIModelsUtil.getCreditsInfo(model) : "";
            result = Optional.of(baseDescription + creditsInfo);
        }
        return result;
    }

    private static String getCreditsInfo(ModelDTO model) {
        String creditsTag = model.isReasoningModel() ? "Model_Credits_With_Reasoning" : "Model_Credits_Standard";
        return MessageFormat.format(TRANSLATOR.getTranslation(creditsTag), Float.valueOf(CreditsConverterUtil.getApproximateCreditsPerWord((float)model.getInputWeight())), Float.valueOf(CreditsConverterUtil.getApproximateCreditsPerWord((float)model.getOutputWeight())));
    }

    public static String getDefaultEngineExtraExplanation(Engine defaultEngine) {
        return MessageFormat.format(TRANSLATOR.getTranslation("Default_Model_Additional_Explanation"), defaultEngine.getId());
    }

    @NonNull
    public static String getModelExplanation(String model, boolean includeCredits) {
        return AIModelsUtil.getEngineExplanation(model, includeCredits).orElse(TRANSLATOR.getTranslation("Default_model_explanation"));
    }
}

