/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.ResponseJsonSchemaDTO;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.AIActionsProvider;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionDetailsProviderFactory;
import com.oxygenxml.positron.core.AICompletionResponse;
import com.oxygenxml.positron.core.AICompletionStreamResponse;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.PositronActionsProvider;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.util.AIAuthentication;
import com.oxygenxml.positron.core.util.IModelsProvider;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.Engine;
import com.oxygenxml.positron.utilities.json.Parameters;
import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.security.Sandbox;

public class AIApplicationInstaller {
    private static final Logger log = LoggerFactory.getLogger(AIApplicationInstaller.class);
    private static final String API_ACTION_ID = "pseudoaction.api.ai";
    private static final String INSTRUCTION_EXPAND_VARIABLE = "aiInstruction";
    private static final String INSTRUCTION_PREFIX = "\\\\n#########\\\\n\\\\n# OBJECTIVE #\\\\nYour main objective is to follow these instructions: \\n ";
    public static final String MODEL_PARAM = "model";
    private static final String TEMPERATURE = "temperature";
    private static final String RESPONSE_FORMAT_SCHEMA = "response_format_json_schema";

    private AIApplicationInstaller() {
        throw new IllegalStateException("Utility class");
    }

    public static void setAiAPIExecutor(StandalonePluginWorkspace pluginWorkspaceAccess, AICompletionDetailsProviderFactory aiCompletionDetailsProviderFactory, AIActionsProvider aiActionsProvider, ChatInteractor chatInteractor, IModelsProvider modelsProvider) {
        AIApplicationInstaller.setAiAPIExecutor(pluginWorkspaceAccess, aiCompletionDetailsProviderFactory, aiActionsProvider, null, chatInteractor, modelsProvider);
    }

    public static void setAiAPIExecutor(StandalonePluginWorkspace pluginWorkspaceAccess, final AICompletionDetailsProviderFactory aiCompletionDetailsProviderFactory, final AIActionsProvider aiActionsProvider, final AIAuthentication aiAuthentication, final ChatInteractor chatInteractor, final IModelsProvider modelsProvider) {
        try {
            Method getAIAccessProvider = pluginWorkspaceAccess.getClass().getMethod("getAIAccessProvider", new Class[0]);
            Object apiAccessProvider = getAIAccessProvider.invoke((Object)pluginWorkspaceAccess, new Object[0]);
            Class<?> aiAccessClass = Class.forName("ro.sync.exml.workspace.api.ai.AIAccess");
            Method setAPiAccess = apiAccessProvider.getClass().getMethod("setAIAccess", aiAccessClass);
            Object apiAccessInstance = Proxy.newProxyInstance(pluginWorkspaceAccess.getClass().getClassLoader(), new Class[]{aiAccessClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
                    String methodName = method.getName();
                    if ("invokeAIAction".equals(methodName)) {
                        String actionId = (String)args[0];
                        AIApplicationInstaller.handleAsyncInvokeAIAction(aiActionsProvider, actionId);
                        return null;
                    }
                    if ("invokeAIActionAndShowInChat".equals(methodName)) {
                        AIApplicationInstaller.invokeAIActionAndShowInChat(aiActionsProvider, args);
                        return null;
                    }
                    if ("invokeAI".equals(methodName)) {
                        try {
                            return Sandbox.runWithAllPerms((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                                @Override
                                public String run() throws Exception {
                                    return AIApplicationInstaller.invokeAI(aiCompletionDetailsProviderFactory, aiActionsProvider, args);
                                }
                            });
                        }
                        catch (PrivilegedActionException ex) {
                            Exception wrappedEx = ex.getException();
                            throw new IOException(wrappedEx.getMessage(), wrappedEx);
                        }
                    }
                    if ("invokeAIStreaming".equals(methodName)) {
                        try {
                            return Sandbox.runWithAllPerms((PrivilegedExceptionAction)new PrivilegedExceptionAction<Flow.Publisher<String>>(){

                                @Override
                                public Flow.Publisher<String> run() throws Exception {
                                    Flowable<CompletionChunk> invokeAIIncremental = AIApplicationInstaller.invokeAIIncremental(aiCompletionDetailsProviderFactory, aiActionsProvider, args);
                                    return FlowAdapters.toFlowPublisher((Publisher)invokeAIIncremental.mapOptional(chunk -> Optional.ofNullable(CompletionResponseUtil.getCompletion((CompletionResponse)chunk))));
                                }
                            });
                        }
                        catch (PrivilegedActionException ex) {
                            Exception wrappedEx = ex.getException();
                            throw new IOException(wrappedEx.getMessage(), wrappedEx);
                        }
                    }
                    if ("isRequiringAuthentication".equals(methodName)) {
                        if (aiAuthentication != null) {
                            return aiAuthentication.isRequiringAuthentication();
                        }
                        return null;
                    }
                    if ("getAuthenticationLocation".equals(methodName)) {
                        if (aiAuthentication != null) {
                            return aiAuthentication.getAuthenticationLocation();
                        }
                        return null;
                    }
                    if ("isAuthenticated".equals(methodName)) {
                        if (aiAuthentication != null) {
                            Map parameters = (Map)args[0];
                            return aiAuthentication.isAuthenticated(parameters);
                        }
                        return null;
                    }
                    if ("getSupportedModels".equals(methodName)) {
                        if (modelsProvider != null) {
                            return modelsProvider.getAvailableEngines();
                        }
                        throw new IOException("Models provider is not available");
                    }
                    if ("isRequestBeingProcessed".equals(methodName)) {
                        return chatInteractor != null && chatInteractor.isRequestBeingProcessed();
                    }
                    if ("setChatMode".equals(methodName)) {
                        chatInteractor.setSelectedChatMode((String)args[0]);
                        return null;
                    }
                    return null;
                }
            });
            setAPiAccess.invoke(apiAccessProvider, apiAccessInstance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void invokeAIActionAndShowInChat(AIActionsProvider aiActionsProvider, Object[] args) throws IOException {
        if (!(aiActionsProvider instanceof PositronActionsProvider)) throw new IOException("Could not retrieve action.");
        String actionID = (String)args[0];
        PositronAIActionBase action = ((PositronActionsProvider)((Object)aiActionsProvider)).getPositronAIAction(actionID);
        if (action == null) throw new IOException("Wrong action with ID " + actionID);
        try {
            action = action.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)e, (Throwable)e);
        }
        String userMessage = (String)args[1];
        action.setInitialText(userMessage);
        String imposedStartMessage = (String)args[2];
        action.setImposedChatStartMessage(imposedStartMessage);
        action.actionPerformed(null);
    }

    static Flowable<CompletionChunk> invokeAIIncremental(AICompletionDetailsProviderFactory aiCompletionDetailsProviderFactory, AIActionsProvider aiActionsProvider, Object[] args) throws CannotComputeCompletionDetailsException, StoppedByUserException, InvalidMessageException, CloneNotSupportedException, IOException {
        ExecutionParams execParams = AIApplicationInstaller.computeExecutionParams(aiActionsProvider, args);
        AICompletionDetailsProvider aiCompletionDetailsProvider = aiCompletionDetailsProviderFactory.retrieveCompletionDetailsProvider(execParams.actionDetails, execParams.initialParams);
        AICompletionStreamResponse response = aiCompletionDetailsProvider.executeActionIncremental(execParams.actionDetails, execParams.messages, execParams.actionExpandParams);
        return response.getResponseContent();
    }

    static String invokeAI(AICompletionDetailsProviderFactory aiCompletionDetailsProviderFactory, AIActionsProvider aiActionsProvider, Object[] args) throws CannotComputeCompletionDetailsException, StoppedByUserException, InvalidMessageException, CloneNotSupportedException, IOException {
        ExecutionParams execParams = AIApplicationInstaller.computeExecutionParams(aiActionsProvider, args);
        AICompletionDetailsProvider aiCompletionDetailsProvider = aiCompletionDetailsProviderFactory.retrieveCompletionDetailsProvider(execParams.actionDetails, execParams.initialParams);
        AICompletionResponse response = aiCompletionDetailsProvider.executeAction(execParams.actionDetails, execParams.messages, execParams.actionExpandParams);
        return response.getResponseContent();
    }

    private static ExecutionParams computeExecutionParams(AIActionsProvider aiActionsProvider, Object[] args) throws CannotComputeCompletionDetailsException, JsonProcessingException, IOException, CloneNotSupportedException {
        AIActionDetails actionDetails;
        HashMap<String, Object> parameters;
        if (!PositronOptionsUtil.isPositronEnabled()) {
            throw new CannotComputeCompletionDetailsException("AI Positron is not enabled.");
        }
        String actionId = (String)args[0];
        String serializedMessages = (String)args[1];
        if (serializedMessages == null) {
            throw new CannotComputeCompletionDetailsException("Messages array cannot be null");
        }
        ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();
        List<Object> messages = new ArrayList<Message>((Collection)objectMapper.readValue(serializedMessages, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, Message.class)));
        Map initialParameters = (Map)args[2];
        HashMap<String, Object> hashMap = parameters = initialParameters != null ? new HashMap<String, Object>(initialParameters) : new HashMap();
        if (actionId == null || actionId.isBlank()) {
            actionId = API_ACTION_ID;
        }
        if ((actionDetails = aiActionsProvider.retrieveAIAction(actionId, parameters)) == null) {
            throw new CannotComputeCompletionDetailsException("Cannot find action: " + actionId);
        }
        if (!actionDetails.canBeInvokedByTools()) {
            throw new CannotComputeCompletionDetailsException("Action: " + actionId + "cannot be invoked by tools");
        }
        if (API_ACTION_ID.equals(actionId)) {
            boolean hasInstructionParam = false;
            List expandParams = actionDetails.getExpandParams();
            if (expandParams != null) {
                hasInstructionParam = expandParams.stream().anyMatch(param -> param.getName().equals(INSTRUCTION_EXPAND_VARIABLE));
            }
            if (hasInstructionParam && !parameters.containsKey(INSTRUCTION_EXPAND_VARIABLE) && !messages.isEmpty() && ((Message)messages.get(0)).getRole() == RoleType.SYSTEM) {
                parameters.put(INSTRUCTION_EXPAND_VARIABLE, INSTRUCTION_PREFIX + ((MessageTextContent)((Message)messages.get(0)).getContent().get(0)).getText());
                messages = messages.subList(1, messages.size());
            }
        }
        if (parameters.containsKey(TEMPERATURE)) {
            try {
                actionDetails.getParameters().setTemperature(NumberParserUtil.parseFloat((String)((String)parameters.get(TEMPERATURE))));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (parameters.containsKey(MODEL_PARAM)) {
            actionDetails.getParameters().setEngine(new Engine((String)parameters.get(MODEL_PARAM)));
            parameters.put("imposed.engine.model", parameters.get(MODEL_PARAM));
            parameters.remove(MODEL_PARAM);
        }
        if (parameters.containsKey(RESPONSE_FORMAT_SCHEMA)) {
            ResponseJsonSchemaDTO schema = (ResponseJsonSchemaDTO)objectMapper.readValue((String)parameters.get(RESPONSE_FORMAT_SCHEMA), ResponseJsonSchemaDTO.class);
            actionDetails = actionDetails.clone();
            Parameters actionParams = actionDetails.getParameters();
            actionParams.setResponseFormatSchema(schema);
            actionDetails.setParameters(actionParams);
            parameters.remove(RESPONSE_FORMAT_SCHEMA);
        }
        Map<String, String> actionParams = AIApplicationInstaller.prepareActionParams(parameters);
        HashMap<String, String> actionExpandParams = new HashMap<String, String>(actionParams);
        ParamsExpander.expandParams(actionDetails.getId(), actionDetails.getExpandParams(), null, actionExpandParams);
        for (Map.Entry<String, String> entry : actionParams.entrySet()) {
            if (!actionExpandParams.containsKey(entry.getKey())) continue;
            actionExpandParams.put(entry.getKey(), entry.getValue());
        }
        return new ExecutionParams(actionDetails, messages, actionExpandParams, initialParameters != null ? initialParameters : new HashMap());
    }

    private static Map<String, String> prepareActionParams(Map<String, Object> parameters) {
        HashMap<String, String> actionParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            actionParams.put(entry.getKey(), (String)entry.getValue());
        }
        return actionParams;
    }

    private static void handleAsyncInvokeAIAction(AIActionsProvider aiActionsProvider, String actionId) throws IOException {
        PositronAIActionBase action;
        if (aiActionsProvider instanceof PositronActionsProvider) {
            action = ((PositronActionsProvider)((Object)aiActionsProvider)).getPositronAIAction(actionId);
            if (action == null) {
                throw new IOException("Could not find action with ID " + actionId);
            }
        } else {
            throw new IOException("Could not locate action.");
        }
        action.actionPerformed(true);
    }

    private static class ExecutionParams {
        final AIActionDetails actionDetails;
        final List<Message> messages;
        final Map<String, String> actionExpandParams;
        final Map<String, Object> initialParams;

        public ExecutionParams(AIActionDetails actionDetails, List<Message> messages, Map<String, String> actionExpandParams, Map<String, Object> initialParams) {
            this.actionDetails = actionDetails;
            this.messages = messages;
            this.actionExpandParams = actionExpandParams;
            this.initialParams = initialParams;
        }

        public AIActionDetails getActionDetails() {
            return this.actionDetails;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public Map<String, String> getActionExpandParams() {
            return this.actionExpandParams;
        }

        public Map<String, Object> getInitialParams() {
            return this.initialParams;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecutionParams)) {
                return false;
            }
            ExecutionParams other = (ExecutionParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AIActionDetails this$actionDetails = this.getActionDetails();
            AIActionDetails other$actionDetails = other.getActionDetails();
            if (this$actionDetails == null ? other$actionDetails != null : !this$actionDetails.equals(other$actionDetails)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            Map<String, String> this$actionExpandParams = this.getActionExpandParams();
            Map<String, String> other$actionExpandParams = other.getActionExpandParams();
            if (this$actionExpandParams == null ? other$actionExpandParams != null : !((Object)this$actionExpandParams).equals(other$actionExpandParams)) {
                return false;
            }
            Map<String, Object> this$initialParams = this.getInitialParams();
            Map<String, Object> other$initialParams = other.getInitialParams();
            return !(this$initialParams == null ? other$initialParams != null : !((Object)this$initialParams).equals(other$initialParams));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExecutionParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AIActionDetails $actionDetails = this.getActionDetails();
            result = result * 59 + ($actionDetails == null ? 43 : $actionDetails.hashCode());
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            Map<String, String> $actionExpandParams = this.getActionExpandParams();
            result = result * 59 + ($actionExpandParams == null ? 43 : ((Object)$actionExpandParams).hashCode());
            Map<String, Object> $initialParams = this.getInitialParams();
            result = result * 59 + ($initialParams == null ? 43 : ((Object)$initialParams).hashCode());
            return result;
        }

        public String toString() {
            return "AIApplicationInstaller.ExecutionParams(actionDetails=" + this.getActionDetails() + ", messages=" + this.getMessages() + ", actionExpandParams=" + this.getActionExpandParams() + ", initialParams=" + this.getInitialParams() + ")";
        }
    }
}

