/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.thread.strategy;

import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.core.tools.ToolsExecutorBase;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ThreadFunctionCallStrategyUtil {
    private ThreadFunctionCallStrategyUtil() {
    }

    public static List<Message> applyFilteringToolCallsStrategies(List<Message> messages, ToolsExecutorBase toolsExecutor) {
        ArrayList<Message> toReturnFilteredMessages = new ArrayList<Message>();
        HashSet<String> processedCalls = new HashSet<String>();
        ArrayList<ToolCallResponseMessage> toolResponses = new ArrayList<ToolCallResponseMessage>();
        for (int i = messages.size() - 1; i >= 0; --i) {
            Message currentChatMessage = messages.get(i);
            if (currentChatMessage instanceof ToolCallResponseMessage) {
                toolResponses.add((ToolCallResponseMessage)currentChatMessage);
                continue;
            }
            if (currentChatMessage instanceof AssistantMessage && ((AssistantMessage)currentChatMessage).getToolCalls() != null) {
                if (toolsExecutor != null) {
                    toReturnFilteredMessages.addAll(ThreadFunctionCallStrategyUtil.filterToolCallsAndResponses((AssistantMessage)currentChatMessage, toolResponses, toolsExecutor, processedCalls));
                }
                toolResponses.clear();
                continue;
            }
            toReturnFilteredMessages.add(currentChatMessage);
        }
        Collections.reverse(toReturnFilteredMessages);
        return toReturnFilteredMessages;
    }

    private static List<Message> filterToolCallsAndResponses(AssistantMessage assitantToolCallsMessage, List<ToolCallResponseMessage> toolResponses, ToolsExecutorBase toolsExecutor, Set<String> processedCalls) {
        ArrayList<Message> toReturn = new ArrayList<Message>();
        List toolCalls = assitantToolCallsMessage.getToolCalls();
        ArrayList<CompletionToolCall> filteredToolCalls = new ArrayList<CompletionToolCall>();
        for (int j = toolCalls.size() - 1; j >= 0; --j) {
            String functionName;
            ThreadFunctionCallStrategy strategy;
            CompletionToolCall completionToolCall = (CompletionToolCall)toolCalls.get(j);
            Optional<ToolCallResponseMessage> callResponse = toolResponses.stream().filter(response -> response.getToolCallId().equals(completionToolCall.getId())).findFirst();
            if (!callResponse.isPresent() || (strategy = toolsExecutor.getFunctionCallsRequestThreadStrategy(functionName = completionToolCall.getFunction().getName())) != ThreadFunctionCallStrategy.KEEP_ALL_CALLS && (strategy != ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL || processedCalls.contains(functionName))) continue;
            filteredToolCalls.add(completionToolCall);
            toReturn.add((Message)callResponse.get());
            processedCalls.add(functionName);
        }
        if (!filteredToolCalls.isEmpty()) {
            Collections.reverse(filteredToolCalls);
            toReturn.add((Message)new AssistantMessage(filteredToolCalls, assitantToolCallsMessage.getContent()));
        }
        return toReturn;
    }
}

