/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.project;

import com.oxygenxml.positron.core.tools.project.OutputStreamCreator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.functions.RAGException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;

public class WebHelpSearchHelper {
    private static final Logger log = LoggerFactory.getLogger(WebHelpSearchHelper.class);
    private static final String WEBHELP_TO_DITA_XSLT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n    xmlns:math=\"http://www.w3.org/2005/xpath-functions/math\"\n    exclude-result-prefixes=\"xs math\"\n    version=\"2.0\">\n    \n    <xsl:output omit-xml-declaration=\"yes\"/>\n    \n    <xsl:template match=\"node() | @*\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"node() | @*\"/>\n        </xsl:copy>\n    </xsl:template>\n    \n    <xsl:template match=\"*[@class = ('edit-link', 'wh-label-container')]\" priority=\"101\"/>\n    <xsl:template match=\"*[contains(@class, 'author')]\" priority=\"101\"/>\n    \n    <xsl:template match=\"*\" priority=\"100\">\n        <xsl:choose>\n            <xsl:when test=\"matches(@class, '(.*) (.+\\S)title(.*\\S)$')\">\n                <!-- For titles the DITA OT adds an extra class value like '- topic/title title sectiontitle' -->\n                <title>\n                    <xsl:apply-templates select=\"@href\"/>\n                    <xsl:apply-templates select=\"node()\"/>\n                </title>\n            </xsl:when>\n            <xsl:when test=\"matches(@class, '(.*) (.+\\S)note(.*\\S)$')\">\n                <!-- For notes the DITA OT adds an extra class value like '- topic/note note tip note_tip' -->\n                <note>\n                    <xsl:apply-templates select=\"@href\"/>\n                    <xsl:apply-templates select=\"node()\"/>\n                </note>\n            </xsl:when>\n            <xsl:when test=\"contains(@class, 'topic/')\">\n                <xsl:variable name=\"name\">\n                    <xsl:value-of select=\"tokenize(normalize-space(@class), ' ')[last()]\"/>\n                </xsl:variable>\n                <xsl:element name=\"{$name}\">\n                    <xsl:apply-templates select=\"@href\"/>\n                    <xsl:apply-templates select=\"node()\"/>\n                </xsl:element>\n            </xsl:when>\n            <xsl:otherwise>\n                <xsl:apply-templates select=\"node()\"/>\n            </xsl:otherwise>\n        </xsl:choose>\n    </xsl:template>\n</xsl:stylesheet>";
    private static OutputStreamCreator osCreator = new OutputStreamCreator(){

        @Override
        public OutputStream createOutputStream(URLConnection connection) throws IOException {
            return connection.getOutputStream();
        }
    };

    private WebHelpSearchHelper() {
    }

    public static String getRelatedWebHelpContent(String feedbackToken, String keywords, int limit) throws RAGException {
        block11: {
            try {
                if (feedbackToken == null) break block11;
                URL url = WebHelpSearchHelper.computeFeedbackURL(feedbackToken);
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection conn = (HttpURLConnection)connection;
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/json; utf-8");
                    conn.setRequestProperty("Accept", "application/json");
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                }
                try (OutputStream os = osCreator.createOutputStream(connection);){
                    StringWriter sw = new StringWriter();
                    AIRequestUtil.defaultObjectMapper().writeValue((Writer)sw, (Object)keywords);
                    sw.close();
                    String kwJsonValue = sw.toString();
                    String jsonRequest = "{\"searchQuery\":" + kwJsonValue + ",\"currentPage\":1,\"pageSize\":5,\"exactSearch\":false,\"defaultJoinOperator\":\"OR\"}";
                    os.write(jsonRequest.getBytes(StandardCharsets.UTF_8));
                }
                InputStream is = connection.getInputStream();
                String jsonResponse = IOUtil.readFromStream((boolean)false, (InputStream)is, (String)"UTF-8");
                Map response = (Map)AIRequestUtil.defaultObjectMapper().readValue(jsonResponse, Map.class);
                List docs = (List)response.get("documents");
                if (docs != null) {
                    StringBuilder responseBuilder = new StringBuilder();
                    for (Object obj : docs) {
                        Map document = (Map)obj;
                        Map fields = (Map)document.get("fields");
                        String uri = (String)fields.get("uri");
                        responseBuilder.append(WebHelpSearchHelper.readAndFilterContent(uri, limit));
                        if (responseBuilder.length() <= limit) continue;
                        break;
                    }
                    return responseBuilder.toString();
                }
            }
            catch (Throwable ex) {
                throw new RAGException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    private static URL computeFeedbackURL(String feedbackToken) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(feedbackToken);
        }
        catch (MalformedURLException ex) {
            url = new URL("https://feedback.oxygenxml.com/api/html-content/search?token=" + feedbackToken);
        }
        return url;
    }

    private static String readAndFilterContent(String uri, int limit) throws IOException {
        StringBuilder content = new StringBuilder();
        String htmlContent = IOUtil.readURL((URL)new URL(uri), (String)"UTF-8");
        int mainIndex = htmlContent.indexOf("<main");
        if (mainIndex != -1) {
            int mainStartTagEnd = htmlContent.indexOf(62, mainIndex);
            if (mainStartTagEnd != -1) {
                int mainEnd = htmlContent.indexOf("</main>", mainStartTagEnd);
                if (mainEnd != -1) {
                    String mainContent = htmlContent.substring(mainStartTagEnd + 1, mainEnd);
                    try {
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        StreamSource xslt = new StreamSource(new StringReader(WEBHELP_TO_DITA_XSLT));
                        Transformer transformer = transformerFactory.newTransformer(xslt);
                        StringWriter sw = new StringWriter();
                        StreamResult result = new StreamResult(sw);
                        transformer.transform(new StreamSource(new StringReader(mainContent)), result);
                        sw.close();
                        content.append("Content:\n" + sw.toString());
                    }
                    catch (TransformerException | TransformerFactoryConfigurationError e) {
                        content.append(TextUtils.removeMarkup(mainContent));
                        log.debug(e.getMessage(), e);
                    }
                    if (content.length() > limit) {
                        content.delete(limit, content.length());
                    }
                }
            } else {
                content.append(TextUtils.removeMarkup(htmlContent));
            }
        } else {
            log.error("Could not determine content <main> tag in " + htmlContent);
            content.append(TextUtils.removeMarkup(htmlContent));
        }
        if (content.length() > 0) {
            content.insert(0, "\nURL: " + uri + "\n");
        }
        return content.toString();
    }

    public static void setOsCreator(OutputStreamCreator outputStreamCreator) {
        osCreator = outputStreamCreator;
    }
}

