/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.project;

import com.oxygenxml.positron.core.tools.project.WebHelpSearchHelper;
import com.oxygenxml.positron.core.util.ContextExtractorUtil;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.parameters.ContentParams;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public abstract class ProjectHelperBase
implements FunctionsAndRAGHelper {
    private static final Logger log = LoggerFactory.getLogger(ProjectHelperBase.class);
    public static final int DEFAULT_MAX_NUMBER_OF_TOKENS_IN_PROMPT = 15000;

    public String getDocumentContent(String docUrl, ContentParams params) throws IOException {
        String content = null;
        if (docUrl != null) {
            content = this.getContentFromOpenedDocuments(docUrl);
            if (content == null) {
                content = ContextExtractorUtil.readDocumentContent(new URL(docUrl));
            }
            if (params != null) {
                content = TextUtils.changeContentToFitLineRanges(params, content);
            }
        }
        return content;
    }

    protected String getContentFromOpenedDocuments(String docUrlString) throws IOException {
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null && docUrlString != null) {
            try {
                URL docURL = URLUtil.correct((URL)new URL(docUrlString));
                WSEditor ed = pw.getEditorAccess(docURL, 0);
                if (ed == null) {
                    ed = pw.getEditorAccess(docURL, 1);
                }
                if (ed != null) {
                    return IOUtil.read((Reader)ed.createContentReader()).toString();
                }
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected int getRAGCharacterLimit() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null && this.areFunctionsAvailable()) {
            String limitContentValue = optionsStorage.getOption("oxygen.positron.plugin.limit.content.rag", Integer.toString(15000));
            try {
                return (int)((float)NumberParserUtil.parseInt((String)limitContentValue) * 4.0f);
            }
            catch (NumberFormatException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
        return 60000;
    }

    public boolean isRAGEnabledForChatAndActions() {
        if (!this.areFunctionsAvailable()) {
            return false;
        }
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            String enableActionValue = optionsStorage.getOption("oxygen.positron.plugin.enable.project.rag.for.chat.actions", String.valueOf(true));
            return Boolean.parseBoolean(enableActionValue);
        }
        return true;
    }

    public boolean isAskConfirmationRAGFunctions() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            String enableActionValue = optionsStorage.getOption("oxygen.positron.plugin.ask.confirmation.rag", String.valueOf(true));
            return Boolean.parseBoolean(enableActionValue);
        }
        return true;
    }

    public boolean isAskConfirmationWriteFunctions() {
        return true;
    }

    public boolean isWriteEnabledForChatAndActions() {
        if (!this.areFunctionsAvailable()) {
            return false;
        }
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            String enableActionValue = optionsStorage.getOption("oxygen.positron.plugin.enable.project.write", String.valueOf(true));
            return Boolean.parseBoolean(enableActionValue);
        }
        return true;
    }

    public boolean isWebHelpRagEnabled() {
        WSOptionsStorage optionsStorage;
        if (this.isExternalRagEnabled() && this.areFunctionsAvailable() && (optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage()) != null) {
            String token = optionsStorage.getOption("oxygen.positron.plugin.webhelp.token", "");
            return token != null && !token.trim().isEmpty();
        }
        return false;
    }

    public boolean isExternalRagEnabled() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null && this.areFunctionsAvailable()) {
            String enableExternalRagValue = optionsStorage.getOption("oxygen.positron.plugin.enable.external.rag", Boolean.toString(true));
            return Boolean.valueOf(enableExternalRagValue);
        }
        return false;
    }

    public String getRelatedWebHelpContent(String imposedSiteToken, String keywords) throws RAGException {
        String token;
        WSOptionsStorage optionsStorage;
        String feedbackToken = imposedSiteToken;
        if (feedbackToken == null && (optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage()) != null && this.areFunctionsAvailable() && (token = optionsStorage.getOption("oxygen.positron.plugin.webhelp.token", "")) != null && !token.trim().isEmpty()) {
            feedbackToken = token;
        }
        return WebHelpSearchHelper.getRelatedWebHelpContent(feedbackToken, keywords, this.getRAGCharacterLimit());
    }

    public String getWebHelpSiteDescription() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null && this.areFunctionsAvailable()) {
            return optionsStorage.getOption("oxygen.positron.plugin.webhelp.site.description", "");
        }
        return null;
    }

    public boolean areFunctionsAvailable() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            String enableRAGOption = optionsStorage.getOption("oxygen.positron.plugin.enable.rag", String.valueOf(true));
            return Boolean.parseBoolean(enableRAGOption);
        }
        return false;
    }
}

