/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.tools.internal.ChainedProblemFilter;
import com.oxygenxml.positron.core.tools.internal.DefaultProblemFilter;
import com.oxygenxml.positron.core.tools.internal.DefaultProblemsCollector;
import com.oxygenxml.positron.core.tools.internal.FilesValidator;
import com.oxygenxml.positron.core.tools.internal.IProblemFilter;
import com.oxygenxml.positron.core.tools.internal.IncludeAllProblemFilter;
import com.oxygenxml.positron.core.tools.internal.RangeProblemFilter;
import com.oxygenxml.positron.utilities.functions.ValidateContentHelper;
import com.oxygenxml.positron.utilities.functions.ValidationReportConfig;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.xml.parser.FakeResolver;

public class ValidateContentHelperImpl
implements ValidateContentHelper {
    public String validate(URL url, String content, ValidationReportConfig config) {
        return this.validate(url, content, new IncludeAllProblemFilter(), config);
    }

    public String validate(URL url, String content, int startOffset, int endOffset, ValidationReportConfig config) {
        ChainedProblemFilter filter = new ChainedProblemFilter(new RangeProblemFilter(url, startOffset, endOffset), new DefaultProblemFilter());
        return this.validate(url, content, filter, config);
    }

    public String validate(URL url, String content, IProblemFilter filter, ValidationReportConfig config) {
        DefaultProblemsCollector coll = new DefaultProblemsCollector();
        coll.setFilter(filter);
        FilesValidator fv = this.createFilesValidator(coll);
        if (config != null) {
            fv.setReportConfig(config);
        }
        fv.validate(Arrays.asList(url), t -> content);
        return fv.generateValidationReport();
    }

    protected FilesValidator createFilesValidator(DefaultProblemsCollector coll) {
        return new FilesValidator(coll);
    }

    public String validateXMLWithSAX(String xmlContent) {
        if (xmlContent == null || xmlContent.trim().isEmpty()) {
            return ValidateContentHelperImpl.createErrorValidationReport("XML content is null or empty");
        }
        String result = null;
        try {
            XMLReader xmlReader = ValidateContentHelperImpl.createWellFormedXMLReader();
            XMLValidationErrorHandler errorHandler = new XMLValidationErrorHandler();
            xmlReader.setErrorHandler(errorHandler);
            xmlReader.parse(new InputSource(new StringReader(xmlContent)));
            result = errorHandler.hasErrors() ? ValidateContentHelperImpl.createValidationReportFromExceptions(errorHandler.getErrors()) : "[]";
        }
        catch (ParserConfigurationException e) {
            result = ValidateContentHelperImpl.createErrorValidationReport("Parser configuration error: " + e.getMessage());
        }
        catch (SAXException e) {
            result = ValidateContentHelperImpl.validateXMLWithoutRootWithSAX(xmlContent);
        }
        catch (IOException e) {
            result = ValidateContentHelperImpl.createErrorValidationReport("I/O error during parsing: " + e.getMessage());
        }
        return result;
    }

    private static XMLReader createWellFormedXMLReader() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        xmlReader.setEntityResolver((EntityResolver)new FakeResolver());
        return xmlReader;
    }

    private static String createValidationReportFromExceptions(List<SAXParseException> exceptions) {
        ArrayList<Map<String, Object>> problems = new ArrayList<Map<String, Object>>();
        FilesValidator validator = new FilesValidator();
        for (SAXParseException exception : exceptions) {
            DocumentPositionedInfo dpi = new DocumentPositionedInfo(2, exception.getMessage());
            dpi.setLine(exception.getLineNumber());
            dpi.setLine(exception.getColumnNumber());
            problems.add(validator.toJSON(dpi));
        }
        try {
            return new ObjectMapper().writeValueAsString(problems);
        }
        catch (Exception e) {
            return "[{\"severity\":\"error\",\"engine\":null,\"description\":\"Failed to generate validation report: " + e.getMessage() + "\"}]";
        }
    }

    private static String createErrorValidationReport(String message) {
        ArrayList<Map<String, Object>> problems = new ArrayList<Map<String, Object>>();
        FilesValidator validator = new FilesValidator();
        DocumentPositionedInfo dpi = new DocumentPositionedInfo(2, message);
        dpi.setLine(0);
        dpi.setLine(0);
        problems.add(validator.toJSON(dpi));
        try {
            return new ObjectMapper().writeValueAsString(problems);
        }
        catch (Exception e) {
            return "[{\"severity\":\"error\",\"engine\":null,\"description\":\"Failed to generate validation report: " + e.getMessage() + "\"}]";
        }
    }

    private static String validateXMLWithoutRootWithSAX(String xmlContent) {
        if (xmlContent == null || xmlContent.trim().isEmpty()) {
            return ValidateContentHelperImpl.createErrorValidationReport("XML content is null or empty");
        }
        String result = null;
        try {
            XMLReader xmlReader = ValidateContentHelperImpl.createWellFormedXMLReader();
            XMLValidationErrorHandler errorHandler = new XMLValidationErrorHandler();
            xmlReader.setErrorHandler(errorHandler);
            final boolean[] hasElementsInsideFakeRoot = new boolean[]{false};
            XMLValidationErrorHandler rootCounter = new XMLValidationErrorHandler(){
                private int depth = 0;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    ++this.depth;
                    if (this.depth == 2) {
                        hasElementsInsideFakeRoot[0] = true;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) {
                    --this.depth;
                }
            };
            xmlReader.setContentHandler(rootCounter);
            String wrappedContent = "<fake-root>" + xmlContent.trim() + "</fake-root>";
            xmlReader.parse(new InputSource(new StringReader(wrappedContent)));
            result = !hasElementsInsideFakeRoot[0] ? ValidateContentHelperImpl.createErrorValidationReport("The XML fragment doesn't have a root element ") : (errorHandler.hasErrors() ? ValidateContentHelperImpl.createValidationReportFromExceptions(errorHandler.getErrors()) : "[]");
        }
        catch (ParserConfigurationException e) {
            result = ValidateContentHelperImpl.createErrorValidationReport("Parser configuration error: " + e.getMessage());
        }
        catch (SAXException e) {
            result = ValidateContentHelperImpl.createErrorValidationReport("XML parsing error: " + e.getMessage());
        }
        catch (IOException e) {
            result = ValidateContentHelperImpl.createErrorValidationReport("I/O error during parsing: " + e.getMessage());
        }
        return result;
    }

    private static class XMLValidationErrorHandler
    extends DefaultHandler {
        private final List<SAXParseException> errors = new ArrayList<SAXParseException>();

        private XMLValidationErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        public List<SAXParseException> getErrors() {
            return this.errors;
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }
    }
}

