/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.tools.internal.DefaultProblemsCollector;
import com.oxygenxml.positron.core.tools.internal.IValidationCollector;
import com.oxygenxml.positron.core.tools.internal.IValidator;
import com.oxygenxml.positron.core.util.OxygenUtils;
import com.oxygenxml.positron.utilities.functions.ValidationReportConfig;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.util.validation.ValidationUtilAccess;
import ro.sync.exml.workspace.api.util.validation.ValidatorProblemCollector;

public class FilesValidator
implements IValidator {
    private IValidationCollector collector;
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesValidator.class);
    private ValidationReportConfig reportConfig;

    public FilesValidator() {
        this(new DefaultProblemsCollector());
    }

    public FilesValidator(IValidationCollector collector) {
        this.collector = collector;
    }

    public FilesValidator(IValidationCollector collector, ValidationReportConfig reportConfig) {
        this.collector = collector;
        this.reportConfig = reportConfig;
    }

    public void setReportConfig(ValidationReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    @Override
    public void validate(List<URL> files) {
        this.collector.reset();
        try {
            PluginWorkspace pluginWorkspaceAccess = PluginWorkspaceProvider.getPluginWorkspace();
            if (pluginWorkspaceAccess != null) {
                Optional.ofNullable(pluginWorkspaceAccess.getValidationUtilAccess()).ifPresent(validator -> validator.validateResources(files.iterator(), false, (ValidatorProblemCollector)this.collector));
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void validate(List<URL> files, Function<URL, String> contentProvider) {
        this.collector.reset();
        if (FilesValidator.allowsValidationWithCustomContent()) {
            try {
                PluginWorkspace pluginWorkspaceAccess = PluginWorkspaceProvider.getPluginWorkspace();
                if (pluginWorkspaceAccess != null && pluginWorkspaceAccess.getValidationUtilAccess() != null) {
                    ValidationUtilAccess validationUtilAccess = pluginWorkspaceAccess.getValidationUtilAccess();
                    Method validateMethod = validationUtilAccess.getClass().getMethod("validateResources", Iterator.class, Function.class, Boolean.TYPE, ValidatorProblemCollector.class);
                    validateMethod.invoke((Object)validationUtilAccess, files.iterator(), contentProvider, false, this.collector);
                }
            }
            catch (InvocationTargetException e) {
                for (Throwable cause = e; cause != null; cause = ((Throwable)cause).getCause()) {
                    if (!(cause instanceof InterruptedException)) continue;
                    Thread.currentThread().interrupt();
                    LOGGER.debug("Validation was interrupted", cause);
                    return;
                }
                LOGGER.error("Validation error: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String generateValidationReport() {
        String report = null;
        DocumentPositionedInfo[] problems = this.collector.getAll();
        ArrayList<Map<String, Object>> allProblemsAsJSON = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < problems.length; ++i) {
            if (this.reportConfig != null && this.reportConfig.isIgnoredProblem(problems[i].getErrorKey())) continue;
            allProblemsAsJSON.add(this.toJSON(problems[i]));
        }
        try {
            report = new ObjectMapper().writeValueAsString(allProblemsAsJSON);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return report;
    }

    public boolean isValidationFailed() {
        DocumentPositionedInfo[] problems = this.collector.getAll();
        return !Arrays.asList(problems).stream().filter(problem -> problem.getSeverity() == 2 || problem.getSeverity() == 3).collect(Collectors.toList()).isEmpty();
    }

    public Map<String, Object> toJSON(DocumentPositionedInfo dpi) {
        URL url;
        HashMap<String, Object> report = new HashMap<String, Object>();
        if (this.reportConfig == null || this.reportConfig.isIncludeEngine()) {
            report.put("engine", dpi.getEngineName());
        }
        report.put("severity", dpi.getSeverityAsString());
        String message = dpi.getMessage();
        if (message != null && message.length() > 0) {
            report.put("description", message);
            if (dpi.getMessageHighlightOffset() >= 0 && dpi.getLength() > 0 && dpi.getLength() < message.length() && dpi.getMessageHighlightOffset() < message.length()) {
                report.put("match", message.substring(dpi.getMessageHighlightOffset(), dpi.getMessageHighlightOffset() + dpi.getLength()));
            }
        }
        if ((this.reportConfig == null || this.reportConfig.isIncludeSystemId()) && dpi.getSystemID() != null && dpi.getSystemID().length() > 0 && (url = URLUtil.clearUserInfo((String)dpi.getSystemID())) != null) {
            report.put("systemID", url);
        }
        if (this.reportConfig == null || this.reportConfig.isIncludeLocation()) {
            FilesValidator.addLocation(dpi, report);
        }
        if (dpi.getAdditionalInfo() != null && !dpi.getAdditionalInfo().toString().contains("http://www.oxygenxml.com/internalHelp/")) {
            report.put("additionalInfo", dpi.getAdditionalInfo().toString());
        }
        return report;
    }

    private static void addLocation(DocumentPositionedInfo dpi, Map<String, Object> report) {
        HashMap<String, Object> location = new HashMap<String, Object>();
        if (dpi.getLine() != -1) {
            HashMap<String, String> startObject = new HashMap<String, String>();
            startObject.put("line", String.valueOf(dpi.getLine()));
            startObject.put("column", String.valueOf(dpi.getColumn() != -1 ? dpi.getColumn() : 0));
            location.put("start", startObject);
        }
        if (dpi.getEndLine() != -1) {
            HashMap<String, String> endObject = new HashMap<String, String>();
            endObject.put("line", String.valueOf(dpi.getEndLine()));
            endObject.put("column", String.valueOf(dpi.getEndColumn() != -1 ? dpi.getEndColumn() : 0));
            location.put("end", endObject);
        }
        if (dpi.getOffset() != -1) {
            location.put("offset", String.valueOf(dpi.getOffset()));
        }
        if (dpi.getLength() > 0) {
            location.put("length", String.valueOf(dpi.getLength()));
        }
        if (!location.isEmpty()) {
            report.put("location", location);
        }
    }

    public static boolean allowsValidationWithCustomContent() {
        PluginWorkspace pluginWorkspaceAccess = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspaceAccess != null) {
            ValidationUtilAccess validationUtilAccess = pluginWorkspaceAccess.getValidationUtilAccess();
            if (pluginWorkspaceAccess != null) {
                return validationUtilAccess != null && OxygenUtils.getCurrentMajorVersion() >= 27;
            }
        }
        return false;
    }
}

