/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools.internal;

import com.oxygenxml.positron.core.tools.internal.StructureNode;
import com.oxygenxml.positron.core.tools.internal.StructureNodeFactory;
import com.oxygenxml.positron.core.tools.internal.TreeAccess;
import com.oxygenxml.positron.core.tools.internal.TreeAccessProvider;
import com.oxygenxml.positron.core.tools.internal.exceptions.CannotComputeDitamapContextException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.HrefInfo;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;

public class DITAMapExtractorUtil {
    public static final String NO_TOC_AVAILABLE = "No table of contents structure is available";

    private DITAMapExtractorUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static AuthorNode getNodeFromTree(URL editorLocation, Object ditamapTree) {
        TreePath selectedPath;
        AuthorNode currentNode = null;
        if (editorLocation != null) {
            TreePath[] selectedPaths = TreeAccessProvider.getTreeAccess().getSelectionPaths(ditamapTree);
            if (selectedPaths != null) {
                for (TreePath selPath : selectedPaths) {
                    if (!DITAMapExtractorUtil.isSameNodeURL(editorLocation, (AuthorNode)selPath.getLastPathComponent())) continue;
                    currentNode = (AuthorNode)selPath.getLastPathComponent();
                    break;
                }
            }
            if (currentNode == null) {
                currentNode = DITAMapExtractorUtil.searchNode(ditamapTree, editorLocation);
            }
        }
        if (currentNode == null && (selectedPath = TreeAccessProvider.getTreeAccess().getSelectionPath(ditamapTree)) != null) {
            currentNode = (AuthorNode)selectedPath.getLastPathComponent();
        }
        return currentNode;
    }

    private static boolean isSameNodeURL(URL url, AuthorNode node) {
        HrefInfo hrefInfo = DITAAccess.getHrefInformation((AuthorNode)node);
        return hrefInfo != null && Objects.equals(url, hrefInfo.getReferenceURL());
    }

    private static AuthorNode searchNodeRecursive(Object tree, AuthorNode currentNode, URL url) {
        if (DITAMapExtractorUtil.isSameNodeURL(url, currentNode)) {
            return currentNode;
        }
        TreeModel model = TreeAccessProvider.getTreeAccess().getTreeModel(tree);
        int noOfChildren = model.getChildCount(currentNode);
        for (int i = 0; i < noOfChildren; ++i) {
            AuthorNode result = DITAMapExtractorUtil.searchNodeRecursive(tree, (AuthorNode)model.getChild(currentNode, i), url);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static AuthorNode searchNode(Object tree, URL url) {
        AuthorNode root = DITAMapExtractorUtil.getDitamapRoot(tree);
        return DITAMapExtractorUtil.searchNodeRecursive(tree, root, url);
    }

    public static StructureNode extractStructureFromDITAMap(String baseTopic, Object ditamapTree, int maxDepth, boolean includeDescendants) throws MalformedURLException, CannotComputeDitamapContextException {
        StructureNodeFactory structureNodeFactory = new StructureNodeFactory(ditamapTree);
        AuthorNode root = DITAMapExtractorUtil.getContextNode(baseTopic, ditamapTree);
        if (root == null) {
            throw new CannotComputeDitamapContextException(NO_TOC_AVAILABLE);
        }
        StructureNode rootNode = structureNodeFactory.createStructureNode(root);
        rootNode.setCurrent(true);
        if (includeDescendants) {
            DITAMapExtractorUtil.extractDescendantsRecursively(structureNodeFactory, root, 0, maxDepth, rootNode);
        } else {
            rootNode.setNonExpandedChildren(TreeAccessProvider.getTreeAccess().getTreeModel(ditamapTree).getChildCount(root));
        }
        return rootNode;
    }

    private static AuthorNode getContextNode(String contextTopic, Object ditamapTree) throws MalformedURLException {
        AuthorNode contextNode = null;
        if (contextTopic != null && !contextTopic.isEmpty() && !"null".equals(contextTopic)) {
            contextNode = DITAMapExtractorUtil.getNodeFromTree(new URL(contextTopic), ditamapTree);
        } else {
            WSEditor mainEditor = PluginWorkspaceProvider.getPluginWorkspace().getCurrentEditorAccess(0);
            URL editorLocation = mainEditor != null ? mainEditor.getEditorLocation() : null;
            contextNode = DITAMapExtractorUtil.getNodeFromTree(editorLocation, ditamapTree);
            if (contextNode == null) {
                contextNode = DITAMapExtractorUtil.getDitamapRoot(ditamapTree);
            }
        }
        return contextNode;
    }

    private static AuthorNode getDitamapRoot(Object ditamapTree) {
        TreeAccess treeAccess = TreeAccessProvider.getTreeAccess();
        TreeModel treeModel = treeAccess.getTreeModel(ditamapTree);
        Object root = (AuthorNode)treeModel.getRoot();
        if (root != null && Objects.isNull(treeAccess.getTextForNode((AuthorNode)root, ditamapTree))) {
            root = treeModel.getChildCount(root) == 1 ? (AuthorNode)treeModel.getChild(root, 0) : null;
        }
        return root;
    }

    private static void extractDescendantsRecursively(StructureNodeFactory structureNodeFactory, AuthorNode node, int depth, int maxDepth, StructureNode parentNodeStucture) {
        TreeModel model = TreeAccessProvider.getTreeAccess().getTreeModel(structureNodeFactory.getDitamapTree());
        int noOfChildren = model.getChildCount(node);
        if (depth >= maxDepth) {
            parentNodeStucture.setNonExpandedChildren(noOfChildren);
            return;
        }
        for (int i = 0; i < noOfChildren; ++i) {
            AuthorNode childNode = (AuthorNode)model.getChild(node, i);
            StructureNode childNodeStructure = structureNodeFactory.createStructureNode(childNode);
            parentNodeStucture.addChild(childNodeStructure);
            DITAMapExtractorUtil.extractDescendantsRecursively(structureNodeFactory, childNode, depth + 1, maxDepth, childNodeStructure);
        }
    }

    public static boolean isNotVisibleInMapTree(AuthorNode parent) {
        AuthorNode parentsParent;
        AuthorElement elem;
        AttrValue clazz;
        boolean toReturn = false;
        if (parent.getType() == 7) {
            toReturn = true;
        } else if (parent.getType() == 0 && (clazz = (elem = (AuthorElement)parent).getAttribute("class")) != null && clazz.getValue().contains(" map/map ") && (parentsParent = elem.getParent()) != null && parentsParent.getType() == 7) {
            toReturn = true;
        }
        return toReturn;
    }

    public static AuthorNode getParent(AuthorNode element) {
        AuthorNode parent = null;
        parent = element.getParent();
        if (parent != null) {
            if (parent.getType() == 2) {
                parent = null;
            } else if (DITAMapExtractorUtil.isNotVisibleInMapTree(parent)) {
                parent = DITAMapExtractorUtil.getParent(parent);
            }
        }
        return parent;
    }

    public static List<AuthorNode> getNodeChildren(TreeModel model, AuthorNode node) {
        ArrayList<AuthorNode> children = new ArrayList<AuthorNode>();
        int noOfChildren = model.getChildCount(node);
        for (int i = 0; i < noOfChildren; ++i) {
            children.add((AuthorNode)model.getChild(node, i));
        }
        return children;
    }

    public static AuthorNode getNodeToInsertTopic(URL editorLocationURL, URL anchorURL, Object ditamapTree) {
        AuthorNode searchNode = null;
        boolean isInsertingDirectlyToDitamap = Objects.equals(anchorURL, editorLocationURL);
        if (isInsertingDirectlyToDitamap) {
            AuthorNode root = DITAMapExtractorUtil.getDitamapRoot(ditamapTree);
            if (root != null) {
                searchNode = root;
            }
        } else {
            searchNode = DITAMapExtractorUtil.searchNode(ditamapTree, anchorURL);
        }
        return searchNode;
    }
}

