/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.FunctionExecutorUtils;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.ContextExtractorUtil;
import com.oxygenxml.positron.utilities.functions.ValidateContentHelperProvider;
import com.oxygenxml.positron.utilities.functions.parameters.ValidateDocumentProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;

public abstract class ValidateFunctionExecutorBase
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ValidateFunctionExecutorBase.class);

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        if (log.isDebugEnabled()) {
            log.debug("Validate document content with arguments: " + arguments);
        }
        Object toRet = null;
        ValidateDocumentProperties params = (ValidateDocumentProperties)arguments;
        try {
            URL url = null;
            url = params != null && params.url != null ? FunctionExecutorUtils.convertToURL(params.url, this::getCurrentEditedDocumentURL) : this.getCurrentEditedDocumentURL();
            if (url != null) {
                AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
                if (aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(url)) {
                    toRet = MessageFormat.format(Translator.getInstance().getTranslation("Access_denied_to_File_is_not_AI_accessible"), URLUtil.filterPasswords((String)url.toExternalForm()));
                } else {
                    String content = this.retrieveContent(params, url);
                    toRet = ValidateContentHelperProvider.getValidateContentHelper().validate(url, content, null);
                }
            } else {
                toRet = "Could not determine location for file to validate";
            }
        }
        catch (MalformedURLException e) {
            toRet = "Could not create URL from " + (params != null ? params.url : null);
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            toRet = "Could not obtain content from current document";
            log.error(e.getMessage(), (Throwable)e);
        }
        return toRet;
    }

    private String retrieveContent(ValidateDocumentProperties params, URL url) throws IOException {
        String content = null;
        if (params != null) {
            if (params.content != null) {
                content = params.content;
            } else {
                if (url.equals(this.getCurrentEditedDocumentURL())) {
                    content = this.getCurrentEditedDocumentContent();
                }
                if (content == null) {
                    content = this.getDocumentContent(url);
                }
            }
        } else {
            content = this.getCurrentEditedDocumentContent();
        }
        return content;
    }

    private String getDocumentContent(URL docURL) {
        try {
            return ContextExtractorUtil.readDocumentContent(this.enrichURLWithConnectionData(docURL));
        }
        catch (IOException e) {
            return null;
        }
    }

    protected URL enrichURLWithConnectionData(URL docURL) {
        return docURL;
    }

    protected abstract URL getCurrentEditedDocumentURL();

    protected abstract String getCurrentEditedDocumentContent() throws IOException;

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

