/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.ExternalFunctionExecutor;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.RAGDisabledException;
import com.oxygenxml.positron.core.tools.ToolsReloadListener;
import com.oxygenxml.positron.core.tools.WriteDisabledException;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import com.oxygenxml.positron.utilities.functions.RAGFunctionSignature;
import com.oxygenxml.positron.utilities.functions.WriteFunctionSignature;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public abstract class ToolsExecutorBase
implements IFunctionSignaturesRepository {
    private static final Logger log = LoggerFactory.getLogger(ToolsExecutorBase.class);
    private ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();
    protected Map<String, FunctionExecutor> functionExecutors = new LinkedHashMap<String, FunctionExecutor>();
    private Map<String, String> oldFunctionNamings = new HashMap<String, String>();
    private List<ToolsReloadListener> reloadListeners = new ArrayList<ToolsReloadListener>();

    protected ToolsExecutorBase() {
        this.reloadFunctions();
    }

    public final void reloadFunctions() {
        this.functionExecutors = this.loadToolsExecutors();
        this.oldFunctionNamings = new HashMap<String, String>();
        for (Map.Entry<String, FunctionExecutor> values : this.functionExecutors.entrySet()) {
            String id = values.getKey();
            FunctionExecutor executor = values.getValue();
            ChatFunctionSignature functionSignature = executor.getFunctionSignature();
            List oldIds = functionSignature.getAlternateNames();
            if (oldIds.isEmpty()) continue;
            oldIds.stream().forEach(oldId -> this.oldFunctionNamings.put((String)oldId, id));
        }
        this.loadExternalAIFunctions();
        for (ToolsReloadListener toolsReloadListener : this.reloadListeners) {
            toolsReloadListener.toolsReloaded();
        }
    }

    public void addToolsReloadListener(ToolsReloadListener listener) {
        this.reloadListeners.add(listener);
    }

    private void loadExternalAIFunctions() {
        List<Object> externalFunctionsList = this.loadExternalFunctionsList();
        if (externalFunctionsList != null) {
            for (Object externalFunction : externalFunctionsList) {
                this.loadExternalFunction(externalFunction);
            }
        }
    }

    private List<Object> loadExternalFunctionsList() {
        List<Object> functionsList = new ArrayList<Object>();
        try {
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            Method getAIFunctionsProvider = pluginWorkspace.getClass().getMethod("getExternalAIFunctionsProvider", new Class[0]);
            Object aiFunctionProvider = getAIFunctionsProvider.invoke((Object)pluginWorkspace, new Object[0]);
            Method loadAIFunctions = aiFunctionProvider.getClass().getMethod("loadAIFunctions", new Class[0]);
            functionsList = (List)loadAIFunctions.invoke(aiFunctionProvider, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return functionsList;
    }

    private void loadExternalFunction(Object externalFunction) {
        try {
            Method getNameMethod = externalFunction.getClass().getMethod("getName", new Class[0]);
            Method getDescriptionMethod = externalFunction.getClass().getMethod("getDescription", new Class[0]);
            Method getUIDecriptionMethod = externalFunction.getClass().getMethod("getUIDecription", new Class[0]);
            Method getParameterDescriptionsMethod = externalFunction.getClass().getMethod("getParameterDescriptions", new Class[0]);
            Method executeFunctionMethod = externalFunction.getClass().getMethod("executeFunction", String.class, Map.class);
            String functionName = (String)getNameMethod.invoke(externalFunction, new Object[0]);
            Object functionDescription = getDescriptionMethod.invoke(externalFunction, new Object[0]);
            if (functionName == null || functionName.isEmpty()) {
                log.error("External function cannot be load. Name is required.");
                return;
            }
            if (this.oldFunctionNamings.containsKey(functionName)) {
                functionName = this.oldFunctionNamings.get(functionName);
            }
            ExternalFunctionExecutor externalFunctionExecutor = this.createExternalFunctionInstance(functionName, (String)functionDescription, (String)getUIDecriptionMethod.invoke(externalFunction, new Object[0]), (String)getParameterDescriptionsMethod.invoke(externalFunction, new Object[0]), executeFunctionMethod, externalFunction);
            if (this.functionExecutors.containsKey(functionName)) {
                log.debug("Overriding the default function with an external one: " + functionName);
            }
            this.functionExecutors.put(functionName, externalFunctionExecutor);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    protected ExternalFunctionExecutor createExternalFunctionInstance(String name, String description, String uiDescription, String parametersSchema, Method executionMethod, Object executionObject) {
        return new ExternalFunctionExecutor(name, description, uiDescription, parametersSchema, executionMethod, executionObject);
    }

    protected abstract Map<String, FunctionExecutor> loadToolsExecutors();

    public boolean isAbleToExecuteFunction(String name) {
        return this.functionExecutors.containsKey(name) || this.oldFunctionNamings.containsKey(name);
    }

    public String executeFunction(String toolId, String name, String arguments) throws CannotExecuteFunctionException {
        FunctionExecutor executor = this.getFunctionExecutorByName(name);
        if (executor == null) {
            log.error("Cannot found an executor for function: {}", (Object)name);
            return "";
        }
        if (!executor.getFunctionSignature().isEnabled()) {
            return "Function is not available.";
        }
        return this.executeFunction(toolId, executor, arguments);
    }

    protected String executeFunction(String toolId, FunctionExecutor executor, String arguments) throws CannotExecuteFunctionException {
        String toRet = "";
        Object functionResult = null;
        try {
            if (executor.getFunctionSignature().isEnabled()) {
                String disabledFunctionResult = this.checkWarnForDisabledFunction(executor, arguments);
                if (disabledFunctionResult != null) {
                    toRet = disabledFunctionResult;
                } else {
                    functionResult = executor.executeWithSerializedArguments(toolId, arguments);
                    if (functionResult != null) {
                        toRet = functionResult instanceof String ? (String)functionResult : this.objectMapper.writeValueAsString(functionResult);
                    }
                }
            } else {
                toRet = "Function is not available.";
            }
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage());
        }
        return toRet;
    }

    private String checkWarnForDisabledFunction(FunctionExecutor executor, String serializeArguments) {
        RAGDisabledException ex = null;
        ChatFunctionSignature functionSignature = executor.getFunctionSignature();
        FunctionsAndRAGHelper helper = FunctionsAndRAGHelperProvider.getProjectRAGHelper();
        if (helper != null) {
            if (functionSignature instanceof RAGFunctionSignature && ((RAGFunctionSignature)functionSignature).accessesProjectResources()) {
                if (helper.isRAGEnabledForChatAndActions() && helper.isAskConfirmationRAGFunctions()) {
                    ex = new RAGDisabledException(functionSignature, serializeArguments);
                }
            } else if (this.isWriteFunctionWithConfirmation(functionSignature, helper, executor.requireUserConfirmation())) {
                ex = new WriteDisabledException(functionSignature, serializeArguments);
            }
            if (ex != null) {
                try {
                    this.checkContinueDisabledToolCall(ex);
                }
                catch (RAGDisabledException e) {
                    return e.getMessage();
                }
            }
        }
        return null;
    }

    private boolean isWriteFunctionWithConfirmation(ChatFunctionSignature functionSignature, FunctionsAndRAGHelper helper, boolean requireUserConfirmation) {
        return requireUserConfirmation && functionSignature instanceof WriteFunctionSignature && helper.isWriteEnabledForChatAndActions() && helper.isAskConfirmationWriteFunctions();
    }

    protected void checkContinueDisabledToolCall(RAGDisabledException ex) throws RAGDisabledException {
        throw ex;
    }

    public void addFunctionExecutorForTC(FunctionExecutor functionExecutor) {
        this.functionExecutors.put(functionExecutor.getFunctionSignature().getName(), functionExecutor);
    }

    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy(String functionName) {
        ThreadFunctionCallStrategy toRet = ThreadFunctionCallStrategy.DISCARD_ALL_CALLS;
        FunctionExecutor functionExecutor = this.getFunctionExecutorByName(functionName);
        if (functionExecutor != null) {
            toRet = functionExecutor.getFunctionCallsRequestThreadStrategy();
        }
        return toRet;
    }

    public ChatFunctionSignature searchForFunctionSignature(String name) {
        FunctionExecutor functionExecutor = this.getFunctionExecutorByName(name);
        return functionExecutor != null ? functionExecutor.getFunctionSignature() : null;
    }

    private FunctionExecutor getFunctionExecutorByName(String functionName) {
        FunctionExecutor functionExecutor = this.functionExecutors.get(functionName);
        if (functionExecutor == null && this.oldFunctionNamings.containsKey(functionName)) {
            functionExecutor = this.functionExecutors.get(this.oldFunctionNamings.get(functionName));
        }
        return functionExecutor;
    }

    public Set<String> getAvailableFunctionNames() {
        return this.functionExecutors.keySet();
    }

    public Map<String, FunctionExecutor> getFunctionExecutors() {
        return this.functionExecutors;
    }
}

