/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionFunctionCall;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.filter.FilteredContentRestorer;
import com.oxygenxml.positron.core.service.PositronServiceUtil;
import com.oxygenxml.positron.core.tools.ActionExecutorFunction;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.ParamsDescriptionUtil;
import com.oxygenxml.positron.core.tools.ToolsConfirmationInteractor;
import com.oxygenxml.positron.core.tools.ToolsExecutorBase;
import com.oxygenxml.positron.core.tools.ToolsExecutorListener;
import com.oxygenxml.positron.core.tools.ToolsExecutorUtil;
import com.oxygenxml.positron.core.tools.UnsafeFunctionInterceptor;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelper;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;

public abstract class ToolsExecutionHandler {
    private static final Logger log = LoggerFactory.getLogger(ToolsExecutionHandler.class);
    private ToolsExecutorListener executorListener;
    private ToolsConfirmationInteractor confirmationInteractor;
    private FilteredContentRestorer filteredContentRestorer;

    public abstract ToolsExecutorBase getToolsExecutor();

    public CompletionResponse handleToolCalls(List<Message> inputMessages, CompletionResponse completionResponse, ActionExecutorFunction<CompletionResponse> actionExecutor, boolean notifyListener) throws StoppedByUserException, CannotComputeCompletionDetailsException {
        List<CompletionToolCall> toolCalls;
        List completionChoices;
        List list = completionChoices = completionResponse != null ? completionResponse.getChoices() : null;
        if (completionChoices != null && !(toolCalls = CompletionResponseUtil.getToolCalls(completionResponse)).isEmpty()) {
            try {
                if (this.filteredContentRestorer != null) {
                    toolCalls = this.filteredContentRestorer.restoreContentInToolCallArguments(toolCalls);
                }
                List<Message> messagesWithResponses = this.executeTools(toolCalls, CompletionResponseUtil.getCompletion(completionResponse), inputMessages, completionResponse.getModel(), notifyListener ? this.executorListener : null, this.confirmationInteractor);
                if (this.executorListener == null || !this.executorListener.isStopped()) {
                    completionResponse = actionExecutor.execute(messagesWithResponses);
                    completionResponse = this.handleToolCalls(messagesWithResponses, completionResponse, actionExecutor, notifyListener);
                }
            }
            catch (CannotExecuteFunctionException e) {
                throw new CannotComputeCompletionDetailsException(e.getMessage(), e);
            }
        }
        return completionResponse;
    }

    public Flowable<? extends CompletionChunk> handleToolCalls(List<Message> inputMessages, Flowable<? extends CompletionChunk> completionResponseFlux, ActionExecutorFunction<Flowable<? extends CompletionChunk>> actionExecutor) {
        return this.handleToolCalls(inputMessages, completionResponseFlux, actionExecutor, true);
    }

    public Flowable<? extends CompletionChunk> handleToolCalls(List<Message> inputMessages, Flowable<? extends CompletionChunk> completionResponseFlux, ActionExecutorFunction<Flowable<? extends CompletionChunk>> actionExecutor, boolean shouldTryMergeToolCalls) {
        ArrayList toolCalls = new ArrayList();
        StringBuilder allCompletion = new StringBuilder();
        String[] model = new String[1];
        completionResponseFlux = PositronServiceUtil.handleFinalFlags(completionResponseFlux);
        return completionResponseFlux.doOnNext(chunk -> {
            String completion = CompletionResponseUtil.getCompletion((CompletionResponse)chunk);
            if (completion != null) {
                allCompletion.append(completion);
            }
            if (chunk.getChoices() != null && !chunk.getChoices().isEmpty()) {
                if (chunk.getModel() != null) {
                    model[0] = chunk.getModel();
                }
                toolCalls.addAll(CompletionResponseUtil.getToolCalls((CompletionResponse)chunk));
            }
        }).flatMap(item -> {
            Flowable<? extends CompletionChunk> toRet = Flowable.just((Object)item);
            if (!toolCalls.isEmpty() && CompletionResponseUtil.getFinishReason((CompletionResponse)item) != null) {
                try {
                    List<CompletionToolCall> toolCallsToExecute;
                    List<CompletionToolCall> list = toolCallsToExecute = shouldTryMergeToolCalls ? ToolsExecutorUtil.mergeToolCallsFromStreamChunks(toolCalls) : toolCalls;
                    if (this.filteredContentRestorer != null) {
                        toolCallsToExecute = this.filteredContentRestorer.restoreContentInToolCallArguments(toolCallsToExecute);
                    }
                    List<Message> messagesWithResponses = this.executeTools(toolCallsToExecute, allCompletion.toString(), inputMessages, model[0], this.executorListener, this.confirmationInteractor);
                    if (this.executorListener == null || !this.executorListener.isStopped()) {
                        Flowable newCompletionResponseFlux = (Flowable)actionExecutor.execute(messagesWithResponses);
                        toRet = this.handleToolCalls(messagesWithResponses, (Flowable<? extends CompletionChunk>)newCompletionResponseFlux, actionExecutor, shouldTryMergeToolCalls);
                    }
                }
                catch (CannotExecuteFunctionException e) {
                    toRet = Flowable.error((Throwable)new CannotComputeCompletionDetailsException(e.getMessage(), e));
                }
            }
            return toRet;
        });
    }

    private List<Message> executeTools(List<CompletionToolCall> toolCalls, String extraInfoToolCall, List<Message> initialMessages, String model, ToolsExecutorListener executorListener, ToolsConfirmationInteractor confirmationInteractor) throws CannotExecuteFunctionException {
        if (executorListener != null) {
            executorListener.startingToProcessFunctionCalls(toolCalls, extraInfoToolCall, model);
        }
        initialMessages.add((Message)new AssistantMessage(toolCalls, extraInfoToolCall));
        for (CompletionToolCall toolCall : toolCalls) {
            if (executorListener != null && executorListener.isStopped()) break;
            CompletionFunctionCall function = toolCall.getFunction();
            initialMessages.add((Message)this.executeFunctionAndNotifyListener(function.getName(), toolCall.getId(), function.getArguments(), executorListener, confirmationInteractor));
        }
        if (executorListener != null) {
            executorListener.allFunctionsExecuted();
        }
        return initialMessages;
    }

    protected ToolCallResponseMessage executeFunctionAndNotifyListener(String name, String id, String arguments, ToolsExecutorListener executorListener, ToolsConfirmationInteractor confirmationInteractor) throws CannotExecuteFunctionException {
        ToolCallResponseMessage toRet = new ToolCallResponseMessage(id, "");
        ToolsExecutorBase toolsExecutor = this.getToolsExecutor();
        if (executorListener != null || confirmationInteractor != null) {
            Object message = null;
            ChatFunctionSignature signature = toolsExecutor.searchForFunctionSignature(name);
            UnsafeFunctionInterceptor interceptor = null;
            if (signature != null) {
                Function<String, String> actionNameMapper = this.createActionNameMapper();
                message = ParamsDescriptionUtil.getUIFunctionCallWithParamsDescription(signature, arguments, actionNameMapper);
                if (!signature.isSafe()) {
                    interceptor = new UnsafeFunctionInterceptor(signature);
                }
            } else {
                message = "Call to missing function: '" + name + "'";
            }
            if (executorListener != null) {
                executorListener.startingToExecute(id, name, (String)message, arguments);
            }
            if (confirmationInteractor != null) {
                confirmationInteractor.checkExecutionAllowed(id, name, (String)message, arguments, interceptor);
                this.waitForInterceptor(executorListener, interceptor);
            }
        }
        if (!toolsExecutor.isAbleToExecuteFunction(name)) {
            if (executorListener != null) {
                executorListener.functionExecutionFailed(new CannotExecuteFunctionException("Cannot find an executor for function '" + name + "'"));
            }
        } else {
            block14: {
                try {
                    String functionResult = toolsExecutor.executeFunction(id, name, arguments);
                    toRet.setContent(Arrays.asList(new MessageTextContent(functionResult)));
                }
                catch (CannotExecuteFunctionException e) {
                    log.error("Cannot execute function '{}' because: {}; isFatalError: {}", new Object[]{name, e.getMessage(), e.isFatal()});
                    if (log.isDebugEnabled()) {
                        log.debug((Throwable)e);
                    }
                    toRet.setContent(Arrays.asList(new MessageTextContent("ERROR: " + e.getMessage())));
                    if (executorListener != null) {
                        executorListener.functionExecutionFailed(e);
                    }
                    if (!e.isFatal()) break block14;
                    throw e;
                }
            }
            if (executorListener != null) {
                executorListener.functionExecuted(toRet);
            }
        }
        return toRet;
    }

    private void waitForInterceptor(ToolsExecutorListener executorListener, UnsafeFunctionInterceptor interceptor) throws CannotExecuteFunctionException {
        if (interceptor != null) {
            int cnt;
            int maxWaitSeconds = 120;
            for (cnt = 0; interceptor.isPending() && !executorListener.isStopped() && cnt < maxWaitSeconds; ++cnt) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (cnt == maxWaitSeconds) {
                throw new CannotExecuteFunctionException("Tool execution rejected by AI Positron - user confirmation not received within 2-minute timeout period");
            }
            if (!interceptor.isAccepted() && !interceptor.isPending()) {
                throw new CannotExecuteFunctionException("Tool execution rejected by user");
            }
        }
    }

    private Function<String, String> createActionNameMapper() {
        Function<String, String> actionNameMapper = null;
        final InvokeActionHelper helper = InvokeActionHelperProvider.getInvokeActionHelper();
        if (helper != null) {
            actionNameMapper = new Function<String, String>(){

                @Override
                public String apply(String actionID) {
                    return helper.getActionName(actionID, ToolsExecutionHandler.this.getParams());
                }
            };
        }
        return actionNameMapper;
    }

    public void setToolsExecutorListener(ToolsExecutorListener listener) {
        this.executorListener = listener;
    }

    public void removeToolsExecutorListeners() {
        this.executorListener = null;
    }

    public void setToolsConfirmationInteractor(ToolsConfirmationInteractor confirmationInteractor) {
        this.confirmationInteractor = confirmationInteractor;
    }

    public void removeToolsConfirmationInteractor() {
        this.confirmationInteractor = null;
    }

    public void setFilteredContentRestorer(FilteredContentRestorer filteredContentRestorer) {
        this.filteredContentRestorer = filteredContentRestorer;
    }

    protected Map<String, Object> getParams() {
        return null;
    }
}

