/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.StoreInMemoryFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.Memory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class StoreInMemoryFunctionExecutor
implements FunctionExecutor {
    private StoreInMemoryFunctionSignature signature = new StoreInMemoryFunctionSignature();

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.signature;
    }

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        Object returnedMessage = null;
        Memory memory = (Memory)arguments;
        if (memory.rule != null && !memory.rule.isEmpty()) {
            PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
            if (pw != null && pw.getOptionsStorage() != null) {
                String currentMemory = pw.getOptionsStorage().getOption("oxygen.positron.plugin.memory", "");
                if ("".equals(currentMemory)) {
                    currentMemory = "# User Preferences\n\nThese are the user's registered preferences. Apply only those rules that enhance your response without interfering with the main task or altering the original intent of the request.\n\n----\n----";
                }
                StringBuilder updatedMemory = new StringBuilder();
                int insertionIndex = currentMemory.lastIndexOf("\n----");
                if (insertionIndex == -1) {
                    insertionIndex = currentMemory.length();
                }
                updatedMemory.append(currentMemory.substring(0, insertionIndex));
                if (currentMemory != null && !currentMemory.isEmpty()) {
                    updatedMemory.append("\n");
                }
                updatedMemory.append("- ").append(memory.rule);
                updatedMemory.append(currentMemory.substring(insertionIndex));
                pw.getOptionsStorage().setOption("oxygen.positron.plugin.memory", updatedMemory.toString());
                returnedMessage = "Stored new rule in memory, updated rules list:\n\n" + pw.getOptionsStorage().getOption("oxygen.positron.plugin.memory", "");
            } else {
                returnedMessage = "Could not initialize storage location";
            }
        } else {
            returnedMessage = "Could not find relevant content to store to memory.";
        }
        return returnedMessage;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

